/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import android.text.TextUtils;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.connection.RedirectHandler;
import com.liulishuo.filedownloader.download.ConnectionProfile;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectTask {
    public final int downloadId;
    public final String url;
    public final FileDownloadHeader header;
    private ConnectionProfile profile;
    private String etag;
    private Map<String, List<String>> requestHeader;
    private List<String> redirectedUrlList;

    private ConnectTask(ConnectionProfile connectionProfile, int n2, String string, String string2, FileDownloadHeader fileDownloadHeader) {
        this.downloadId = n2;
        this.url = string;
        this.etag = string2;
        this.header = fileDownloadHeader;
        this.profile = connectionProfile;
    }

    private void addUserRequiredHeader(FileDownloadConnection fileDownloadConnection) {
        Object object = ((ConnectTask)this).header;
        if (object != null && (object = ((FileDownloadHeader)object).getHeaders()) != null) {
            Object object2;
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[2];
                object2 = objectArray;
                objectArray[0] = ((ConnectTask)this).downloadId;
                objectArray[1] = object;
                FileDownloadLog.v(this, "%d add outside header: %s", (Object[])object2);
            }
            for (Map.Entry entry : ((HashMap)object).entrySet()) {
                object = (String)entry.getKey();
                object2 = (List)entry.getValue();
                if (object2 == null) continue;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    fileDownloadConnection.addHeader((String)object, (String)object2.next());
                }
            }
        }
    }

    private void addRangeHeader(FileDownloadConnection fileDownloadConnection) throws ProtocolException {
        if (fileDownloadConnection.dispatchAddResumeOffset(this.etag, this.profile.startOffset)) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.etag)) {
            fileDownloadConnection.addHeader("If-Match", this.etag);
        }
        this.profile.processProfile(fileDownloadConnection);
    }

    private void fixNeededHeader(FileDownloadConnection fileDownloadConnection) {
        FileDownloadHeader fileDownloadHeader = ((ConnectTask)((Object)fileDownloadHeader)).header;
        if (fileDownloadHeader == null || fileDownloadHeader.getHeaders().get("User-Agent") == null) {
            fileDownloadConnection.addHeader("User-Agent", FileDownloadUtils.defaultUserAgent());
        }
    }

    public /* synthetic */ ConnectTask(ConnectionProfile connectionProfile, int n2, String string, String string2, FileDownloadHeader fileDownloadHeader, 1 var6_6) {
        this(connectionProfile, n2, string, string2, fileDownloadHeader);
    }

    public void updateConnectionProfile(long l2) {
        ConnectionProfile connectionProfile;
        ConnectionProfile connectionProfile2 = objectArray3.profile;
        long l3 = connectionProfile2.currentOffset;
        if (l2 == l3) {
            FileDownloadLog.w(objectArray3, "no data download, no need to update", new Object[0]);
            return;
        }
        ConnectionProfile connectionProfile3 = connectionProfile2;
        l3 = connectionProfile3.contentLength - (l2 - l3);
        objectArray3.profile = connectionProfile = ConnectionProfile.ConnectionProfileBuild.buildConnectionProfile(connectionProfile3.startOffset, l2, connectionProfile2.endOffset, l3);
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = connectionProfile;
            FileDownloadLog.i(objectArray, "after update profile:%s", objectArray3);
        }
    }

    public FileDownloadConnection connect() throws IOException, IllegalAccessException {
        ArrayList<String> arrayList;
        Object[] objectArray;
        ConnectTask connectTask = this;
        FileDownloadConnection fileDownloadConnection = CustomComponentHolder.getImpl().createConnection(this.url);
        connectTask.addUserRequiredHeader(fileDownloadConnection);
        connectTask.addRangeHeader(fileDownloadConnection);
        connectTask.fixNeededHeader(fileDownloadConnection);
        connectTask.requestHeader = fileDownloadConnection.getRequestHeaderFields();
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = this.downloadId;
            objectArray2[1] = this.requestHeader;
            FileDownloadLog.d(this, "<---- %s request header %s", objectArray);
        }
        fileDownloadConnection.execute();
        objectArray = arrayList;
        this.redirectedUrlList = new ArrayList<String>();
        fileDownloadConnection = RedirectHandler.process(this.requestHeader, fileDownloadConnection, (List<String>)objectArray);
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = this.downloadId;
            objectArray3[1] = fileDownloadConnection.getResponseHeaderFields();
            FileDownloadLog.d(this, "----> %s response header %s", objectArray);
        }
        return fileDownloadConnection;
    }

    public boolean isRangeNotFromBeginning() {
        return this.profile.currentOffset > 0L;
    }

    public String getFinalRedirectedUrl() {
        List<String> list = this.redirectedUrlList;
        if (list != null && !list.isEmpty()) {
            List<String> list2 = this.redirectedUrlList;
            return list2.get(list2.size() - 1);
        }
        return null;
    }

    public Map<String, List<String>> getRequestHeader() {
        return this.requestHeader;
    }

    public ConnectionProfile getProfile() {
        return this.profile;
    }

    public void retryOnConnectedWithNewParam(ConnectionProfile connectionProfile, String string) throws Reconnect {
        if (connectionProfile == null) {
            throw new IllegalArgumentException();
        }
        ConnectTask connectTask = this;
        connectTask.profile = connectionProfile;
        connectTask.etag = string;
        throw new Reconnect();
    }

    public static class Builder {
        private Integer downloadId;
        private String url;
        private String etag;
        private FileDownloadHeader header;
        private ConnectionProfile connectionProfile;

        public Builder setDownloadId(int n2) {
            this.downloadId = n2;
            return this;
        }

        public Builder setUrl(String string) {
            this.url = string;
            return this;
        }

        public Builder setEtag(String string) {
            this.etag = string;
            return this;
        }

        public Builder setHeader(FileDownloadHeader fileDownloadHeader) {
            this.header = fileDownloadHeader;
            return this;
        }

        public Builder setConnectionProfile(ConnectionProfile connectionProfile) {
            this.connectionProfile = connectionProfile;
            return this;
        }

        public ConnectTask build() {
            ConnectionProfile connectionProfile;
            Object object = this.downloadId;
            if (object != null && (connectionProfile = this.connectionProfile) != null && this.url != null) {
                Builder builder = this;
                int n2 = (Integer)object;
                object = builder.url;
                String string = builder.etag;
                FileDownloadHeader fileDownloadHeader = builder.header;
                return new ConnectTask(connectionProfile, n2, (String)object, string, fileDownloadHeader, null);
            }
            throw new IllegalArgumentException();
        }
    }

    public class Reconnect
    extends Throwable {
    }
}

