/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.net.ProtocolException;

public class ConnectionProfile {
    public static final int RANGE_INFINITE = -1;
    public final long startOffset;
    public final long currentOffset;
    public final long endOffset;
    public final long contentLength;
    private final boolean isForceNoRange;
    private final boolean isTrialConnect;

    private ConnectionProfile() {
        this.startOffset = 0L;
        this.currentOffset = 0L;
        this.endOffset = 0L;
        this.contentLength = 0L;
        this.isForceNoRange = false;
        this.isTrialConnect = true;
    }

    private ConnectionProfile(long l2, long l3, long l4, long l5) {
        this(l2, l3, l4, l5, false);
    }

    private ConnectionProfile(long l2, long l3, long l4, long l5, boolean bl) {
        if (l2 == 0L && l4 == 0L || !bl) {
            ConnectionProfile connectionProfile = this;
            connectionProfile.startOffset = l2;
            connectionProfile.currentOffset = l3;
            connectionProfile.endOffset = l4;
            connectionProfile.contentLength = l5;
            connectionProfile.isForceNoRange = bl;
            connectionProfile.isTrialConnect = false;
            return;
        }
        throw new IllegalArgumentException();
    }

    public /* synthetic */ ConnectionProfile(1 var1_1) {
        this();
    }

    public /* synthetic */ ConnectionProfile(long l2, long l3, long l4, long l5, boolean bl, 1 var10_6) {
        this(l2, l3, l4, l5, bl);
    }

    public /* synthetic */ ConnectionProfile(long l2, long l3, long l4, long l5, 1 var9_2) {
        this(l2, l3, l4, l5);
    }

    public void processProfile(FileDownloadConnection fileDownloadConnection) throws ProtocolException {
        Object object;
        if (((ConnectionProfile)object).isForceNoRange) {
            return;
        }
        if (((ConnectionProfile)object).isTrialConnect && FileDownloadProperties.getImpl().trialConnectionHeadMethod) {
            fileDownloadConnection.setRequestMethod("HEAD");
        }
        if (((ConnectionProfile)object).endOffset == -1L) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = ((ConnectionProfile)object).currentOffset;
            object = FileDownloadUtils.formatString("bytes=%d-", objectArray2);
        } else {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray3[0] = ((ConnectionProfile)object).currentOffset;
            objectArray[1] = ((ConnectionProfile)object).endOffset;
            object = FileDownloadUtils.formatString("bytes=%d-%d", objectArray3);
        }
        fileDownloadConnection.addHeader("Range", (String)object);
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.startOffset;
        objectArray2[1] = this.endOffset;
        objectArray[2] = this.currentOffset;
        return FileDownloadUtils.formatString("range[%d, %d) current offset[%d]", objectArray2);
    }

    public static class ConnectionProfileBuild {
        public static ConnectionProfile buildTrialConnectionProfile() {
            return new ConnectionProfile(null);
        }

        public static ConnectionProfile buildTrialConnectionProfileNoRange() {
            return new ConnectionProfile(0L, 0L, 0L, 0L, true, null);
        }

        public static ConnectionProfile buildBeginToEndConnectionProfile(long l2) {
            return new ConnectionProfile(0L, 0L, -1L, l2, null);
        }

        public static ConnectionProfile buildToEndConnectionProfile(long l2, long l3, long l4) {
            return new ConnectionProfile(l2, l3, -1L, l4, null);
        }

        public static ConnectionProfile buildConnectionProfile(long l2, long l3, long l4, long l5) {
            return new ConnectionProfile(l2, l3, l4, l5, null);
        }
    }
}

