/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.services.DownloadMgrInitialParams;
import com.liulishuo.filedownloader.services.ForegroundServiceConfig;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.io.IOException;

public class CustomComponentHolder {
    private DownloadMgrInitialParams initialParams;
    private FileDownloadHelper.ConnectionCountAdapter connectionCountAdapter;
    private FileDownloadHelper.ConnectionCreator connectionCreator;
    private FileDownloadHelper.OutputStreamCreator outputStreamCreator;
    private FileDownloadDatabase database;
    private FileDownloadHelper.IdGenerator idGenerator;
    private ForegroundServiceConfig foregroundServiceConfig;

    public static CustomComponentHolder getImpl() {
        return LazyLoader.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileDownloadHelper.ConnectionCountAdapter getConnectionCountAdapter() {
        FileDownloadHelper.ConnectionCountAdapter connectionCountAdapter = this.connectionCountAdapter;
        if (connectionCountAdapter != null) {
            return connectionCountAdapter;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (customComponentHolder.connectionCountAdapter == null) {
                this.connectionCountAdapter = this.getDownloadMgrInitialParams().createConnectionCountAdapter();
            }
            CustomComponentHolder customComponentHolder2 = this;
            // ** MonitorExit[v1] (shouldn't be in output)
            return customComponentHolder2.connectionCountAdapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileDownloadHelper.ConnectionCreator getConnectionCreator() {
        FileDownloadHelper.ConnectionCreator connectionCreator = this.connectionCreator;
        if (connectionCreator != null) {
            return connectionCreator;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (customComponentHolder.connectionCreator == null) {
                this.connectionCreator = this.getDownloadMgrInitialParams().createConnectionCreator();
            }
            CustomComponentHolder customComponentHolder2 = this;
            // ** MonitorExit[v1] (shouldn't be in output)
            return customComponentHolder2.connectionCreator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileDownloadHelper.OutputStreamCreator getOutputStreamCreator() {
        FileDownloadHelper.OutputStreamCreator outputStreamCreator = this.outputStreamCreator;
        if (outputStreamCreator != null) {
            return outputStreamCreator;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (customComponentHolder.outputStreamCreator == null) {
                this.outputStreamCreator = this.getDownloadMgrInitialParams().createOutputStreamCreator();
            }
            CustomComponentHolder customComponentHolder2 = this;
            // ** MonitorExit[v1] (shouldn't be in output)
            return customComponentHolder2.outputStreamCreator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private DownloadMgrInitialParams getDownloadMgrInitialParams() {
        var1_1 = this.initialParams;
        if (var1_1 != null) {
            return var1_1;
        }
        v0 = this;
        synchronized (v0) {
            if (v0.initialParams != null) ** GOTO lbl17
            v2 = this;
            var1_1 = v3;
            v3 = new DownloadMgrInitialParams();
            v2.initialParams = var1_1;
lbl17:
            // 2 sources

            v4 = this;
            // ** MonitorExit[v4] (shouldn't be in output)
            return v4.initialParams;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void maintainDatabase(FileDownloadDatabase.Maintainer var0) {
        var1_1 = var0.iterator();
        var2_3 = 0L;
        var4_4 = 0L;
        var6_5 = 0L;
        var8_6 = CustomComponentHolder.getImpl().getIdGeneratorInstance();
        var9_7 = System.currentTimeMillis();
        while (true) {
            block44: {
                block42: {
                    block43: {
                        block41: {
                            block40: {
                                if (!var1_1.hasNext()) break;
                                var11_8 = 0;
                                var12_9 = (FileDownloadModel)var1_1.next();
                                if (var12_9.getStatus() == 3) break block40;
                                if (var12_9.getStatus() == 2) break block40;
                                if (var12_9.getStatus() == -1) break block40;
                                if (var12_9.getStatus() != 1) ** GOTO lbl26
                                if (var12_9.getSoFar() <= 0L) ** GOTO lbl26
                            }
                            var12_9.setStatus((byte)-2);
lbl26:
                            // 3 sources

                            if ((var13_10 = var12_9.getTargetFilePath()) != null) break block41;
lbl27:
                            // 4 sources

                            while (true) {
                                var11_8 = 1;
                                break block42;
                                break;
                            }
                        }
                        v0 = var12_9;
                        var14_13 = v1;
                        v1 = new File((String)var13_10);
                        if (v0.getStatus() != -2) ** GOTO lbl64
                        v2 = var12_9;
                        if (!FileDownloadUtils.isBreakpointAvailable(var12_9.getId(), v2, v2.getPath(), null)) ** GOTO lbl64
                        var13_10 = v3;
                        if (new File(var12_9.getTempFilePath()).exists()) ** GOTO lbl64
                        if (!var14_13.exists()) ** GOTO lbl64
                        var15_15 = var14_13.renameTo((File)var13_10);
                        if (!FileDownloadLog.NEED_LOG) ** GOTO lbl64
                        v4 = FileDownloadDatabase.class;
                        v5 = "resume from the old no-temp-file architecture [%B], [%s]->[%s]";
                        v6 = new Object[3];
                        var16_16 = v6;
                        var13_11 = 0;
                        var16_16[var13_11] = var15_15;
                        var13_11 = 1;
                        var16_16[var13_11] = var14_13.getPath();
                        var13_11 = 2;
                        v6[var13_11] = var13_10.getPath();
                        FileDownloadLog.d(v4, v5, v6);
lbl64:
                        // 6 sources

                        if (var12_9.getStatus() != 1) break block43;
                        if (var12_9.getSoFar() <= 0L) ** GOTO lbl27
                    }
                    if (!FileDownloadUtils.isBreakpointAvailable(var12_9.getId(), var12_9)) ** GOTO lbl27
                    if (!var14_13.exists()) ** break;
                    ** continue;
                }
                if (var11_8 != 0) {
                    var1_1.remove();
                    var0.onRemovedInvalidData(var12_9);
                    ++var4_4;
                    continue;
                }
                v7 = var8_6;
                v8 = var12_9;
                v9 = v8;
                v10 = v8;
                v11 = v8;
                var11_8 = v8.getId();
                var13_10 = v9.getUrl();
                var14_13 = v10.getPath();
                var15_15 = v11.isPathAsDirectory();
                var13_12 = v7.transOldId(var11_8, (String)var13_10, (String)var14_13, var15_15);
                if (var13_12 == var11_8) break block44;
                if (!FileDownloadLog.NEED_LOG) ** GOTO lbl109
                v12 = FileDownloadDatabase.class;
                v13 = "the id is changed on restoring from db: old[%d] -> new[%d]";
                v14 = new Object[2];
                var14_14 = 0;
                v14[var14_14] = var11_8;
                var14_14 = 1;
                v14[var14_14] = var13_12;
                FileDownloadLog.d(v12, v13, v14);
lbl109:
                // 2 sources

                v15 = var12_9;
                v15.setId(var13_12);
                var0.changeFileDownloadModelId(var11_8, v15);
                ++var6_5;
            }
            var0.onRefreshedValidData(var12_9);
            ++var2_3;
            continue;
            break;
        }
        FileDownloadUtils.markConverted(FileDownloadHelper.getAppContext());
        var0.onFinishMaintain();
        if (FileDownloadLog.NEED_LOG) {
            v16 = new Object[4];
            var0 = v16;
            var0[0] = var2_3;
            var0[1] = var4_4;
            v16[2] = var6_5;
            v16[3] = System.currentTimeMillis() - var9_7;
            FileDownloadLog.d(FileDownloadDatabase.class, "refreshed data count: %d , delete data count: %d, reset id count: %d. consume %d", var0);
        }
        return;
        catch (Throwable var1_2) {
            FileDownloadUtils.markConverted(FileDownloadHelper.getAppContext());
            var0.onFinishMaintain();
            if (FileDownloadLog.NEED_LOG) {
                v17 = new Object[4];
                var0 = v17;
                var0[0] = var2_3;
                var0[1] = var4_4;
                v17[2] = var6_5;
                v17[3] = System.currentTimeMillis() - var9_7;
                FileDownloadLog.d(FileDownloadDatabase.class, "refreshed data count: %d , delete data count: %d, reset id count: %d. consume %d", var0);
            }
            throw var1_2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitCustomMaker(DownloadMgrInitialParams.InitCustomMaker initCustomMaker) {
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            customComponentHolder.initialParams = new DownloadMgrInitialParams(initCustomMaker);
            customComponentHolder.connectionCreator = null;
            customComponentHolder.outputStreamCreator = null;
            customComponentHolder.database = null;
            customComponentHolder.idGenerator = null;
            return;
        }
    }

    public FileDownloadConnection createConnection(String string) throws IOException {
        return this.getConnectionCreator().create(string);
    }

    public FileDownloadOutputStream createOutputStream(File file) throws IOException {
        return this.getOutputStreamCreator().create(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileDownloadHelper.IdGenerator getIdGeneratorInstance() {
        FileDownloadHelper.IdGenerator idGenerator = this.idGenerator;
        if (idGenerator != null) {
            return idGenerator;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (customComponentHolder.idGenerator == null) {
                this.idGenerator = this.getDownloadMgrInitialParams().createIdGenerator();
            }
            CustomComponentHolder customComponentHolder2 = this;
            // ** MonitorExit[v1] (shouldn't be in output)
            return customComponentHolder2.idGenerator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileDownloadDatabase getDatabaseInstance() {
        FileDownloadDatabase fileDownloadDatabase = this.database;
        if (fileDownloadDatabase != null) {
            return fileDownloadDatabase;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (customComponentHolder.database == null) {
                CustomComponentHolder customComponentHolder2 = this;
                fileDownloadDatabase = customComponentHolder2.getDownloadMgrInitialParams().createDatabase();
                customComponentHolder2.database = fileDownloadDatabase;
                CustomComponentHolder.maintainDatabase(fileDownloadDatabase.maintainer());
            }
            CustomComponentHolder customComponentHolder3 = this;
            // ** MonitorExit[v2] (shouldn't be in output)
            return customComponentHolder3.database;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ForegroundServiceConfig getForegroundConfigInstance() {
        ForegroundServiceConfig foregroundServiceConfig = this.foregroundServiceConfig;
        if (foregroundServiceConfig != null) {
            return foregroundServiceConfig;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (customComponentHolder.foregroundServiceConfig == null) {
                this.foregroundServiceConfig = this.getDownloadMgrInitialParams().createForegroundServiceConfig();
            }
            CustomComponentHolder customComponentHolder2 = this;
            // ** MonitorExit[v1] (shouldn't be in output)
            return customComponentHolder2.foregroundServiceConfig;
        }
    }

    public int getMaxNetworkThreadCount() {
        return this.getDownloadMgrInitialParams().getMaxNetworkThreadCount();
    }

    public boolean isSupportSeek() {
        return this.getOutputStreamCreator().supportSeek();
    }

    public int determineConnectionCount(int n2, String string, String string2, long l2) {
        return this.getConnectionCountAdapter().determineConnectionCount(n2, string, string2, l2);
    }

    public static final class LazyLoader {
        private static final CustomComponentHolder INSTANCE = new CustomComponentHolder();

        private LazyLoader() {
        }
    }
}

