/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import com.liulishuo.filedownloader.IThreadPoolMonitor;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.ConnectTask;
import com.liulishuo.filedownloader.download.ConnectionProfile;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.download.DownloadRunnable;
import com.liulishuo.filedownloader.download.DownloadStatusCallback;
import com.liulishuo.filedownloader.download.ProcessCallback;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadHttpException;
import com.liulishuo.filedownloader.exception.FileDownloadNetworkPolicyException;
import com.liulishuo.filedownloader.exception.FileDownloadOutOfSpaceException;
import com.liulishuo.filedownloader.exception.FileDownloadSecurityException;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadLaunchRunnable
implements Runnable,
ProcessCallback {
    private static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final int TOTAL_VALUE_IN_CHUNKED_RESOURCE = -1;
    private static final ThreadPoolExecutor DOWNLOAD_EXECUTOR = FileDownloadExecutors.newFixedThreadPool("ConnectionBlock");
    private final DownloadStatusCallback statusCallback;
    private final int defaultConnectionCount;
    private final FileDownloadModel model;
    private final FileDownloadHeader userRequestHeader;
    private final boolean isForceReDownload;
    private final boolean isWifiRequired;
    private final FileDownloadDatabase database;
    private final IThreadPoolMonitor threadPoolMonitor;
    private boolean isTriedFixRangeNotSatisfiable;
    public int validRetryTimes;
    private boolean isNeedForceDiscardRange;
    private final boolean supportSeek;
    private final ArrayList<DownloadRunnable> downloadRunnableList;
    private DownloadRunnable singleDownloadRunnable;
    private boolean isSingleConnection;
    private boolean isResumeAvailableOnDB;
    private boolean acceptPartial;
    private boolean isChunked;
    private final AtomicBoolean alive;
    private volatile boolean paused;
    private volatile boolean error;
    private volatile Exception errorException;
    private String redirectedUrl;
    private long lastCallbackBytes;
    private long lastCallbackTimestamp;
    private long lastUpdateBytes;
    private long lastUpdateTimestamp;

    private DownloadLaunchRunnable(FileDownloadModel fileDownloadModel, FileDownloadHeader fileDownloadHeader, IThreadPoolMonitor iThreadPoolMonitor, int n2, int n3, boolean bl, boolean bl2, int n4) {
        DownloadLaunchRunnable downloadLaunchRunnable = this;
        DownloadLaunchRunnable downloadLaunchRunnable2 = this;
        this.defaultConnectionCount = 5;
        this.isNeedForceDiscardRange = false;
        this.downloadRunnableList = new ArrayList(5);
        this.lastCallbackBytes = 0L;
        this.lastCallbackTimestamp = 0L;
        this.lastUpdateBytes = 0L;
        this.lastUpdateTimestamp = 0L;
        this.alive = new AtomicBoolean(true);
        this.paused = false;
        this.isTriedFixRangeNotSatisfiable = false;
        this.model = fileDownloadModel;
        this.userRequestHeader = fileDownloadHeader;
        this.isForceReDownload = bl;
        downloadLaunchRunnable2.isWifiRequired = bl2;
        downloadLaunchRunnable2.database = CustomComponentHolder.getImpl().getDatabaseInstance();
        downloadLaunchRunnable2.supportSeek = CustomComponentHolder.getImpl().isSupportSeek();
        this.threadPoolMonitor = iThreadPoolMonitor;
        downloadLaunchRunnable.validRetryTimes = n4;
        downloadLaunchRunnable.statusCallback = new DownloadStatusCallback(fileDownloadModel, n4, n2, n3);
    }

    private DownloadLaunchRunnable(DownloadStatusCallback downloadStatusCallback, FileDownloadModel fileDownloadModel, FileDownloadHeader fileDownloadHeader, IThreadPoolMonitor iThreadPoolMonitor, int n2, int n3, boolean bl, boolean bl2, int n4) {
        DownloadLaunchRunnable downloadLaunchRunnable = this;
        this.defaultConnectionCount = 5;
        this.isNeedForceDiscardRange = false;
        this.downloadRunnableList = new ArrayList(5);
        this.lastCallbackBytes = 0L;
        this.lastCallbackTimestamp = 0L;
        this.lastUpdateBytes = 0L;
        this.lastUpdateTimestamp = 0L;
        this.alive = new AtomicBoolean(true);
        this.paused = false;
        this.isTriedFixRangeNotSatisfiable = false;
        this.model = fileDownloadModel;
        this.userRequestHeader = fileDownloadHeader;
        this.isForceReDownload = bl;
        downloadLaunchRunnable.isWifiRequired = bl2;
        downloadLaunchRunnable.database = CustomComponentHolder.getImpl().getDatabaseInstance();
        downloadLaunchRunnable.supportSeek = CustomComponentHolder.getImpl().isSupportSeek();
        this.threadPoolMonitor = iThreadPoolMonitor;
        this.validRetryTimes = n4;
        this.statusCallback = downloadStatusCallback;
    }

    public static DownloadLaunchRunnable createForTest(DownloadStatusCallback downloadStatusCallback, FileDownloadModel fileDownloadModel, FileDownloadHeader fileDownloadHeader, IThreadPoolMonitor iThreadPoolMonitor, int n2, int n3, boolean bl, boolean bl2, int n4) {
        return new DownloadLaunchRunnable(downloadStatusCallback, fileDownloadModel, fileDownloadHeader, iThreadPoolMonitor, n2, n3, bl, bl2, n4);
    }

    private int calcConnectionCount(long l2) {
        if (((DownloadLaunchRunnable)((Object)string)).isMultiConnectionAvailable()) {
            if (((DownloadLaunchRunnable)((Object)string)).isResumeAvailableOnDB) {
                return ((DownloadLaunchRunnable)((Object)string)).model.getConnectionCount();
            }
            DownloadLaunchRunnable downloadLaunchRunnable = string;
            String string = downloadLaunchRunnable.model.getUrl();
            return CustomComponentHolder.getImpl().determineConnectionCount(((DownloadLaunchRunnable)((Object)string)).model.getId(), string, downloadLaunchRunnable.model.getPath(), l2);
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void trialConnect() throws IOException, RetryDirectly, IllegalAccessException, FileDownloadSecurityException {
        FileDownloadConnection fileDownloadConnection = null;
        try {
            Object object = this.isNeedForceDiscardRange ? ConnectionProfile.ConnectionProfileBuild.buildTrialConnectionProfileNoRange() : ConnectionProfile.ConnectionProfileBuild.buildTrialConnectionProfile();
            object = new ConnectTask.Builder().setDownloadId(this.model.getId()).setUrl(this.model.getUrl()).setEtag(this.model.getETag()).setHeader(this.userRequestHeader).setConnectionProfile((ConnectionProfile)object).build();
            fileDownloadConnection = ((ConnectTask)object).connect();
            this.handleTrialConnectResult(((ConnectTask)object).getRequestHeader(), (ConnectTask)object, fileDownloadConnection);
            return;
        }
        finally {
            if (fileDownloadConnection != null) {
                fileDownloadConnection.ending();
            }
        }
    }

    private boolean isMultiConnectionAvailable() {
        if (this.isResumeAvailableOnDB && this.model.getConnectionCount() <= 1) {
            return false;
        }
        return this.acceptPartial && this.supportSeek && !this.isChunked;
    }

    private int determineConnectionCount() {
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleTrialConnectResult(Map<String, List<String>> objectArray, ConnectTask connectTask, FileDownloadConnection fileDownloadConnection) throws IOException, RetryDirectly, IllegalArgumentException, FileDownloadSecurityException {
        int n2 = ((DownloadLaunchRunnable)((Object)map)).model.getId();
        int n3 = fileDownloadConnection.getResponseCode();
        ((DownloadLaunchRunnable)((Object)map)).acceptPartial = FileDownloadUtils.isAcceptRange(n3, fileDownloadConnection);
        int n4 = n3 != 200 && n3 != 201 && n3 != 0 ? 0 : 1;
        long l2 = FileDownloadUtils.findInstanceLengthForTrial(fileDownloadConnection);
        String string = ((DownloadLaunchRunnable)((Object)map)).model.getETag();
        String string2 = FileDownloadUtils.findEtag(n2, fileDownloadConnection);
        boolean bl = false;
        if (n3 == 412 || string != null && !string.equals(string2) && (n4 != 0 || ((DownloadLaunchRunnable)((Object)map)).acceptPartial) || n3 == 201 && connectTask.isRangeNotFromBeginning()) {
            bl = true;
        } else if (n3 == 416) {
            if (((DownloadLaunchRunnable)((Object)map)).acceptPartial && l2 >= 0L) {
                FileDownloadLog.w(map, "get 416 but the Content-Range is returned, no need to retry", new Object[0]);
            } else if (((DownloadLaunchRunnable)((Object)map)).model.getSoFar() > 0L) {
                bl = true;
                FileDownloadLog.w(map, "get 416, precondition failed and just retry", new Object[0]);
            } else if (!((DownloadLaunchRunnable)((Object)map)).isNeedForceDiscardRange) {
                ((DownloadLaunchRunnable)((Object)map)).isNeedForceDiscardRange = true;
                bl = true;
                FileDownloadLog.w(map, "get 416, precondition failed and need to retry with discarding range", new Object[0]);
            }
        }
        if (bl) {
            if (((DownloadLaunchRunnable)((Object)map)).isResumeAvailableOnDB) {
                Object[] objectArray2 = new Object[4];
                Object[] objectArray3 = objectArray = objectArray2;
                objectArray3[0] = n2;
                objectArray3[1] = string;
                objectArray[2] = string2;
                objectArray2[3] = n3;
                FileDownloadLog.w(map, "there is precondition failed on this request[%d] with old etag[%s]\u3001new etag[%s]\u3001response code is %d", objectArray);
            }
            DownloadLaunchRunnable downloadLaunchRunnable = map;
            downloadLaunchRunnable.database.removeConnections(((DownloadLaunchRunnable)((Object)map)).model.getId());
            FileDownloadUtils.deleteTaskFiles(downloadLaunchRunnable.model.getTargetFilePath(), ((DownloadLaunchRunnable)((Object)map)).model.getTempFilePath());
            downloadLaunchRunnable.isResumeAvailableOnDB = false;
            if (string != null && string.equals(string2)) {
                Object[] objectArray4 = new Object[4];
                objectArray = objectArray4;
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = n3;
                objectArray4[3] = n2;
                FileDownloadLog.w(map, "the old etag[%s] is the same to the new etag[%s], but the response status code is %d not Partial(206), so wo have to start this task from very beginning for task[%d]!", objectArray);
                string2 = null;
            }
            Object object = map;
            ((DownloadLaunchRunnable)object).model.setSoFar(0L);
            ((DownloadLaunchRunnable)object).model.setTotal(0L);
            ((DownloadLaunchRunnable)object).model.setETag(string2);
            ((DownloadLaunchRunnable)object).model.resetConnectionCount();
            Object object2 = map;
            objectArray = ((DownloadLaunchRunnable)object2).model.getETag();
            long l3 = ((DownloadLaunchRunnable)object2).model.getSoFar();
            long l4 = ((DownloadLaunchRunnable)object2).model.getTotal();
            n4 = ((DownloadLaunchRunnable)object2).model.getConnectionCount();
            ((DownloadLaunchRunnable)object).database.updateOldEtagOverdue(n2, (String)objectArray, l3, l4, n4);
            throw (DownloadLaunchRunnable)((Object)map).new RetryDirectly();
        }
        ((DownloadLaunchRunnable)((Object)map)).redirectedUrl = connectTask.getFinalRedirectedUrl();
        if (!((DownloadLaunchRunnable)((Object)map)).acceptPartial && n4 == 0) {
            Map<String, List<String>> map = fileDownloadConnection.getResponseHeaderFields();
            throw new FileDownloadHttpException(n3, (Map<String, List<String>>)objectArray, map);
        }
        objectArray = null;
        if (((DownloadLaunchRunnable)((Object)map)).model.isPathAsDirectory()) {
            objectArray = FileDownloadUtils.findFilename(fileDownloadConnection, ((DownloadLaunchRunnable)((Object)map)).model.getUrl());
        }
        boolean bl2 = l2 == -1L;
        Map<String, List<String>> map = map;
        ((DownloadLaunchRunnable)((Object)map)).isChunked = bl2;
        DownloadStatusCallback downloadStatusCallback = ((DownloadLaunchRunnable)((Object)map)).statusCallback;
        boolean bl3 = ((DownloadLaunchRunnable)((Object)map)).isResumeAvailableOnDB && ((DownloadLaunchRunnable)((Object)map)).acceptPartial;
        downloadStatusCallback.onConnected(bl3, l2, string2, (String)objectArray);
    }

    private void realDownloadWithSingleConnection(long l2) throws IOException, IllegalAccessException {
        ConnectionProfile connectionProfile;
        if (!this.acceptPartial) {
            this.model.setSoFar(0L);
            connectionProfile = ConnectionProfile.ConnectionProfileBuild.buildBeginToEndConnectionProfile(l2);
        } else {
            long l3 = l2;
            DownloadLaunchRunnable downloadLaunchRunnable = this;
            l2 = downloadLaunchRunnable.model.getSoFar();
            long l4 = l3 - downloadLaunchRunnable.model.getSoFar();
            connectionProfile = ConnectionProfile.ConnectionProfileBuild.buildToEndConnectionProfile(this.model.getSoFar(), l2, l4);
        }
        DownloadLaunchRunnable downloadLaunchRunnable = this;
        downloadLaunchRunnable.singleDownloadRunnable = new DownloadRunnable.Builder().setId(this.model.getId()).setConnectionIndex(-1).setCallback(this).setUrl(this.model.getUrl()).setEtag(this.model.getETag()).setHeader(this.userRequestHeader).setWifiRequired(this.isWifiRequired).setConnectionModel(connectionProfile).setPath(this.model.getTempFilePath()).build();
        downloadLaunchRunnable.model.setConnectionCount(1);
        downloadLaunchRunnable.database.updateConnectionCount(this.model.getId(), 1);
        if (downloadLaunchRunnable.paused) {
            DownloadLaunchRunnable downloadLaunchRunnable2 = this;
            downloadLaunchRunnable2.model.setStatus((byte)-2);
            downloadLaunchRunnable2.singleDownloadRunnable.pause();
        } else {
            this.singleDownloadRunnable.run();
        }
    }

    private void realDownloadWithMultiConnectionFromResume(int n2, List<ConnectionModel> list) throws InterruptedException {
        if (n2 > 1 && list.size() == n2) {
            this.fetchWithMultipleConnection(list, this.model.getTotal());
            return;
        }
        throw new IllegalArgumentException();
    }

    private void realDownloadWithMultiConnectionFromBeginning(long l2, int n2) throws InterruptedException {
        ArrayList<ConnectionModel> arrayList;
        long l3 = 0L;
        long l4 = l2 / (long)n2;
        int n3 = this.model.getId();
        ArrayList<ConnectionModel> arrayList2 = arrayList;
        arrayList = new ArrayList<ConnectionModel>();
        for (int i2 = 0; i2 < n2; ++i2) {
            ConnectionModel connectionModel;
            long l5 = i2 == n2 - 1 ? -1L : l3 + l4 - 1L;
            ConnectionModel connectionModel2 = connectionModel;
            connectionModel2();
            connectionModel2.setId(n3);
            connectionModel2.setIndex(i2);
            connectionModel2.setStartOffset(l3);
            connectionModel2.setCurrentOffset(l3);
            connectionModel.setEndOffset(l5);
            arrayList2.add(connectionModel);
            this.database.insertConnectionModel(connectionModel2);
            l3 += l4;
        }
        DownloadLaunchRunnable downloadLaunchRunnable = this;
        downloadLaunchRunnable.model.setConnectionCount(n2);
        downloadLaunchRunnable.database.updateConnectionCount(n3, n2);
        this.fetchWithMultipleConnection(arrayList2, l2);
    }

    private void fetchWithMultipleConnection(List<ConnectionModel> list, long l2) throws InterruptedException {
        ArrayList arrayList;
        DownloadLaunchRunnable downloadLaunchRunnable = this;
        int n2 = downloadLaunchRunnable.model.getId();
        String string = downloadLaunchRunnable.model.getETag();
        String string2 = downloadLaunchRunnable.redirectedUrl;
        if (string2 == null) {
            string2 = this.model.getUrl();
        }
        String string3 = this.model.getTempFilePath();
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = list.size();
            objectArray2[1] = n2;
            objectArray[2] = l2;
            FileDownloadLog.d(this, "fetch data with multiple connection(count: [%d]) for task[%d] totalLength[%d]", objectArray2);
        }
        long l3 = 0L;
        boolean bl = this.isResumeAvailableOnDB;
        for (ConnectionModel connectionModel : list) {
            DownloadRunnable.Builder builder;
            long l4 = connectionModel.getEndOffset() == -1L ? l2 - connectionModel.getCurrentOffset() : connectionModel.getEndOffset() - connectionModel.getCurrentOffset() + 1L;
            l3 += connectionModel.getCurrentOffset() - connectionModel.getStartOffset();
            if (l4 == 0L) {
                if (!FileDownloadLog.NEED_LOG) continue;
                Object[] objectArray = new Object[2];
                Object[] objectArray3 = objectArray;
                objectArray3[0] = connectionModel.getId();
                objectArray[1] = connectionModel.getIndex();
                FileDownloadLog.d(this, "pass connection[%d-%d], because it has been completed", objectArray3);
                continue;
            }
            Object object = builder;
            ((DownloadRunnable.Builder)object)();
            ConnectionModel connectionModel2 = connectionModel;
            long l5 = connectionModel2.getCurrentOffset();
            long l6 = connectionModel2.getEndOffset();
            Object object2 = ConnectionProfile.ConnectionProfileBuild.buildConnectionProfile(connectionModel.getStartOffset(), l5, l6, l4);
            Object[] objectArray = builder.setId(n2).setConnectionIndex(connectionModel.getIndex()).setCallback(this).setUrl(string2);
            object = bl ? string : null;
            object2 = objectArray.setEtag((String)object).setHeader(this.userRequestHeader).setWifiRequired(this.isWifiRequired).setConnectionModel((ConnectionProfile)object2).setPath(string3).build();
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = connectionModel;
                FileDownloadLog.d(this, "enable multiple connection: %s", objectArray);
            }
            if (object2 != null) {
                this.downloadRunnableList.add((DownloadRunnable)object2);
                continue;
            }
            throw new IllegalArgumentException("the download runnable must not be null!");
        }
        if (l3 != this.model.getSoFar()) {
            DownloadLaunchRunnable downloadLaunchRunnable2 = this;
            Object[] objectArray = new Object[2];
            Object[] objectArray5 = objectArray;
            objectArray5[0] = this.model.getSoFar();
            objectArray[1] = l3;
            FileDownloadLog.w(downloadLaunchRunnable2, "correct the sofar[%d] from connection table[%d]", objectArray5);
            downloadLaunchRunnable2.model.setSoFar(l3);
        }
        Object object = arrayList;
        arrayList = new ArrayList(this.downloadRunnableList.size());
        for (DownloadRunnable objectArray : this.downloadRunnableList) {
            if (this.paused) {
                objectArray.pause();
                continue;
            }
            ((ArrayList)object).add(Executors.callable(objectArray));
        }
        if (this.paused) {
            this.model.setStatus((byte)-2);
            return;
        }
        object = DOWNLOAD_EXECUTOR.invokeAll(object);
        if (FileDownloadLog.NEED_LOG) {
            object = object.iterator();
            while (object.hasNext()) {
                Future future = (Future)object.next();
                Object[] objectArray = new Object[3];
                Object[] objectArray3 = objectArray;
                objectArray3[0] = n2;
                objectArray3[1] = future.isDone();
                objectArray[2] = future.isCancelled();
                FileDownloadLog.d(this, "finish sub-task for [%d] %B %B", objectArray3);
            }
        }
    }

    private void handlePreAllocate(long l2, String string) throws IOException, IllegalAccessException {
        block11: {
            FileDownloadOutputStream fileDownloadOutputStream = null;
            if (l2 != -1L) {
                String string2 = string;
                long l3 = l2;
                fileDownloadOutputStream = FileDownloadUtils.createOutputStream(this.model.getTempFilePath());
                long l4 = new File(string).length();
                long l5 = l3 - l4;
                try {
                    long l6 = FileDownloadUtils.getFreeSpaceBytes(string2);
                    if (l6 >= l5) {
                        if (!FileDownloadProperties.getImpl().fileNonPreAllocation) {
                            fileDownloadOutputStream.setLength(l2);
                        }
                        break block11;
                    }
                    throw new FileDownloadOutOfSpaceException(l6, l5, l4);
                }
                finally {
                    if (fileDownloadOutputStream != null) {
                        fileDownloadOutputStream.close();
                    }
                }
            }
        }
    }

    private void checkupBeforeConnect() throws FileDownloadGiveUpRetryException {
        if (this.isWifiRequired && !FileDownloadUtils.checkPermission("android.permission.ACCESS_NETWORK_STATE")) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.model.getId();
            objectArray[1] = "android.permission.ACCESS_NETWORK_STATE";
            throw new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("Task[%d] can't start the download runnable, because this task require wifi, but user application nor current process has %s, so we can't check whether the network type connection.", objectArray2));
        }
        if (this.isWifiRequired && FileDownloadUtils.isNetworkNotOnWifiType()) {
            throw new FileDownloadNetworkPolicyException();
        }
    }

    private void checkupAfterGetFilename() throws RetryDirectly, DiscardSafely {
        DownloadLaunchRunnable downloadLaunchRunnable = this;
        int n2 = downloadLaunchRunnable.model.getId();
        if (downloadLaunchRunnable.model.isPathAsDirectory()) {
            DownloadLaunchRunnable downloadLaunchRunnable2 = this;
            Object object = downloadLaunchRunnable2.model.getTargetFilePath();
            int n3 = FileDownloadUtils.generateId(downloadLaunchRunnable2.model.getUrl(), (String)object);
            if (!FileDownloadHelper.inspectAndInflowDownloaded(n2, (String)object, downloadLaunchRunnable2.isForceReDownload, false)) {
                IThreadPoolMonitor iThreadPoolMonitor;
                Object object2;
                FileDownloadModel fileDownloadModel = this.database.find(n3);
                if (fileDownloadModel != null) {
                    if (!FileDownloadHelper.inspectAndInflowDownloading(n2, fileDownloadModel, this.threadPoolMonitor, false)) {
                        DownloadLaunchRunnable downloadLaunchRunnable3 = this;
                        object2 = downloadLaunchRunnable3.database.findConnectionModel(n3);
                        downloadLaunchRunnable3.database.remove(n3);
                        downloadLaunchRunnable3.database.removeConnections(n3);
                        FileDownloadUtils.deleteTargetFile(downloadLaunchRunnable3.model.getTargetFilePath());
                        if (FileDownloadUtils.isBreakpointAvailable(n3, fileDownloadModel)) {
                            DownloadLaunchRunnable downloadLaunchRunnable4 = this;
                            downloadLaunchRunnable4.model.setSoFar(fileDownloadModel.getSoFar());
                            downloadLaunchRunnable4.model.setTotal(fileDownloadModel.getTotal());
                            downloadLaunchRunnable4.model.setETag(fileDownloadModel.getETag());
                            downloadLaunchRunnable4.model.setConnectionCount(fileDownloadModel.getConnectionCount());
                            downloadLaunchRunnable4.database.update(this.model);
                            if (object2 != null) {
                                object = object2.iterator();
                                while (object.hasNext()) {
                                    ConnectionModel connectionModel = (ConnectionModel)object.next();
                                    connectionModel.setId(n2);
                                    this.database.insertConnectionModel(connectionModel);
                                }
                            }
                            throw new RetryDirectly();
                        }
                    } else {
                        DownloadLaunchRunnable downloadLaunchRunnable5 = this;
                        downloadLaunchRunnable5.database.remove(n2);
                        downloadLaunchRunnable5.database.removeConnections(n2);
                        throw new DiscardSafely();
                    }
                }
                DownloadLaunchRunnable downloadLaunchRunnable6 = this;
                long l2 = downloadLaunchRunnable6.model.getSoFar();
                if (FileDownloadHelper.inspectAndInflowConflictPath(n2, l2, (String)(object2 = downloadLaunchRunnable6.model.getTempFilePath()), (String)object, iThreadPoolMonitor = downloadLaunchRunnable6.threadPoolMonitor)) {
                    DownloadLaunchRunnable downloadLaunchRunnable7 = this;
                    downloadLaunchRunnable7.database.remove(n2);
                    downloadLaunchRunnable7.database.removeConnections(n2);
                    throw new DiscardSafely();
                }
            } else {
                DownloadLaunchRunnable downloadLaunchRunnable8 = this;
                downloadLaunchRunnable8.database.remove(n2);
                downloadLaunchRunnable8.database.removeConnections(n2);
                throw new DiscardSafely();
            }
        }
    }

    public /* synthetic */ DownloadLaunchRunnable(FileDownloadModel fileDownloadModel, FileDownloadHeader fileDownloadHeader, IThreadPoolMonitor iThreadPoolMonitor, int n2, int n3, boolean bl, boolean bl2, int n4, 1 var9_9) {
        this(fileDownloadModel, fileDownloadHeader, iThreadPoolMonitor, n2, n3, bl, bl2, n4);
    }

    public void pause() {
        ((DownloadLaunchRunnable)this).paused = true;
        DownloadRunnable downloadRunnable2 = ((DownloadLaunchRunnable)this).singleDownloadRunnable;
        if (downloadRunnable2 != null) {
            downloadRunnable2.pause();
        }
        for (DownloadRunnable downloadRunnable2 : (ArrayList)((DownloadLaunchRunnable)this).downloadRunnableList.clone()) {
            if (downloadRunnable2 == null) continue;
            downloadRunnable2.pause();
        }
    }

    public void pending() {
        DownloadLaunchRunnable downloadLaunchRunnable = this;
        downloadLaunchRunnable.inspectTaskModelResumeAvailableOnDB(downloadLaunchRunnable.database.findConnectionModel(this.model.getId()));
        downloadLaunchRunnable.statusCallback.onPending();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [52[UNCONDITIONALDOLOOP]], but top level block is 32[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public void inspectTaskModelResumeAvailableOnDB(List<ConnectionModel> var1_1) {
        block7: {
            var2_3 = this.model.getConnectionCount();
            v0 = this;
            var3_4 = v0.model.getTempFilePath();
            var4_5 = v0.model.getTargetFilePath();
            var5_6 = var2_3 > 1;
            if (this.isNeedForceDiscardRange) lbl-1000:
            // 3 sources

            {
                while (true) {
                    var5_7 = 0L;
                    break block7;
                    break;
                }
            }
            if (var5_6 && !this.supportSeek || !FileDownloadUtils.isBreakpointAvailable(this.model.getId(), this.model)) ** GOTO lbl-1000
            if (!this.supportSeek) {
                var5_7 = new File(var3_4).length();
            } else if (var5_6) {
                if (var2_3 == var1_1.size()) ** break;
                ** continue;
                var5_7 = ConnectionModel.getTotalOffset(var1_1);
            } else {
                var5_7 = this.model.getSoFar();
            }
        }
        this.model.setSoFar(var5_7);
        var1_2 = var5_7 > 0L;
        this.isResumeAvailableOnDB = var1_2;
        if (!var1_2) {
            this.database.removeConnections(this.model.getId());
            FileDownloadUtils.deleteTaskFiles(var4_5, var3_4);
        }
    }

    @Override
    public void onProgress(long l2) {
        if (this.paused) {
            return;
        }
        this.statusCallback.onProgress(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onCompleted(DownloadRunnable objectArray, long l2, long l3) {
        if (this.paused) {
            if (!FileDownloadLog.NEED_LOG) return;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.model.getId();
            FileDownloadLog.d(this, "the task[%d] has already been paused, so pass the completed callback", objectArray);
            return;
        }
        int n2 = objectArray.connectionIndex;
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray3 = new Object[4];
            Object[] objectArray4 = objectArray3;
            objectArray4[0] = n2;
            objectArray4[1] = l2;
            objectArray4[2] = l3;
            objectArray3[3] = this.model.getTotal();
            FileDownloadLog.d(this, "the connection has been completed(%d): [%d, %d)  %d", objectArray4);
        }
        if (this.isSingleConnection) {
            if (l2 == 0L || l3 == this.model.getTotal()) return;
            Object[] objectArray5 = new Object[4];
            objectArray = objectArray5;
            objectArray[0] = l2;
            objectArray[1] = l3;
            objectArray[2] = this.model.getTotal();
            objectArray5[3] = this.model.getId();
            FileDownloadLog.e((Object)this, "the single task not completed corrected(%d, %d != %d) for task(%d)", objectArray);
            return;
        }
        ArrayList<DownloadRunnable> arrayList = this.downloadRunnableList;
        synchronized (arrayList) {
            this.downloadRunnableList.remove(objectArray);
            return;
        }
    }

    @Override
    public boolean isRetry(Exception exception) {
        if (exception instanceof FileDownloadHttpException) {
            int n2 = ((FileDownloadHttpException)exception).getCode();
            if (this.isSingleConnection && n2 == 416 && !this.isTriedFixRangeNotSatisfiable) {
                FileDownloadUtils.deleteTaskFiles(this.model.getTargetFilePath(), this.model.getTempFilePath());
                this.isTriedFixRangeNotSatisfiable = true;
                return true;
            }
        }
        return this.validRetryTimes > 0 && !(exception instanceof FileDownloadGiveUpRetryException);
    }

    @Override
    public void onError(Exception object2) {
        ((DownloadLaunchRunnable)this).error = true;
        ((DownloadLaunchRunnable)this).errorException = object2;
        if (((DownloadLaunchRunnable)this).paused) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[1];
                object2 = objectArray;
                objectArray[0] = ((DownloadLaunchRunnable)this).model.getId();
                FileDownloadLog.d(this, "the task[%d] has already been paused, so pass the error callback", object2);
            }
            return;
        }
        for (Object object2 : (ArrayList)((DownloadLaunchRunnable)this).downloadRunnableList.clone()) {
            if (object2 == null) continue;
            object2.discard();
        }
    }

    @Override
    public void onRetry(Exception objectArray) {
        int n2;
        if (this.paused) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.model.getId();
                FileDownloadLog.d(this, "the task[%d] has already been paused, so pass the retry callback", objectArray);
            }
            return;
        }
        int n3 = this.validRetryTimes;
        this.validRetryTimes = n2 = n3 - 1;
        if (n3 < 0) {
            Object[] objectArray3 = new Object[2];
            Object[] objectArray4 = objectArray3;
            objectArray4[0] = n2;
            objectArray3[1] = this.model.getId();
            FileDownloadLog.e((Object)this, "valid retry times is less than 0(%d) for download task(%d)", objectArray4);
        }
        this.statusCallback.onRetry((Exception)objectArray, this.validRetryTimes);
    }

    @Override
    public void syncProgressFromCache() {
        this.database.updateProgress(this.model.getId(), this.model.getSoFar());
    }

    public int getId() {
        return this.model.getId();
    }

    public boolean isAlive() {
        return this.alive.get() || this.statusCallback.isAlive();
    }

    public String getTempFilePath() {
        return this.model.getTempFilePath();
    }

    public static class Builder {
        private FileDownloadModel model;
        private FileDownloadHeader header;
        private IThreadPoolMonitor threadPoolMonitor;
        private Integer minIntervalMillis;
        private Integer callbackProgressMaxCount;
        private Boolean isForceReDownload;
        private Boolean isWifiRequired;
        private Integer maxRetryTimes;

        public Builder setModel(FileDownloadModel fileDownloadModel) {
            this.model = fileDownloadModel;
            return this;
        }

        public Builder setHeader(FileDownloadHeader fileDownloadHeader) {
            this.header = fileDownloadHeader;
            return this;
        }

        public Builder setThreadPoolMonitor(IThreadPoolMonitor iThreadPoolMonitor) {
            this.threadPoolMonitor = iThreadPoolMonitor;
            return this;
        }

        public Builder setMinIntervalMillis(Integer n2) {
            this.minIntervalMillis = n2;
            return this;
        }

        public Builder setCallbackProgressMaxCount(Integer n2) {
            this.callbackProgressMaxCount = n2;
            return this;
        }

        public Builder setForceReDownload(Boolean bl) {
            this.isForceReDownload = bl;
            return this;
        }

        public Builder setWifiRequired(Boolean bl) {
            this.isWifiRequired = bl;
            return this;
        }

        public Builder setMaxRetryTimes(Integer n2) {
            this.maxRetryTimes = n2;
            return this;
        }

        public DownloadLaunchRunnable build() {
            if (this.model != null && this.threadPoolMonitor != null && this.minIntervalMillis != null && this.callbackProgressMaxCount != null && this.isForceReDownload != null && this.isWifiRequired != null && this.maxRetryTimes != null) {
                Builder builder = this;
                FileDownloadModel fileDownloadModel = builder.model;
                FileDownloadHeader fileDownloadHeader = builder.header;
                IThreadPoolMonitor iThreadPoolMonitor = builder.threadPoolMonitor;
                Builder builder2 = this;
                int n2 = builder2.minIntervalMillis;
                int n3 = builder2.callbackProgressMaxCount;
                boolean bl = builder2.isForceReDownload;
                boolean bl2 = builder2.isWifiRequired;
                int n4 = builder2.maxRetryTimes;
                return new DownloadLaunchRunnable(fileDownloadModel, fileDownloadHeader, iThreadPoolMonitor, n2, n3, bl, bl2, n4, null);
            }
            throw new IllegalArgumentException();
        }
    }

    public class DiscardSafely
    extends Throwable {
    }

    public class RetryDirectly
    extends Throwable {
    }
}

