/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import android.os.Process;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.ConnectTask;
import com.liulishuo.filedownloader.download.ConnectionProfile;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.download.FetchDataTask;
import com.liulishuo.filedownloader.download.ProcessCallback;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.IOException;

public class DownloadRunnable
implements Runnable {
    private final ConnectTask connectTask;
    private final ProcessCallback callback;
    private final String path;
    private final boolean isWifiRequired;
    private FetchDataTask fetchDataTask;
    private volatile boolean paused;
    private final int downloadId;
    public final int connectionIndex;

    private DownloadRunnable(int n2, int n3, ConnectTask connectTask, ProcessCallback processCallback, boolean bl, String string) {
        this.downloadId = n2;
        this.connectionIndex = n3;
        this.paused = false;
        this.callback = processCallback;
        this.path = string;
        this.connectTask = connectTask;
        this.isWifiRequired = bl;
    }

    private long getDownloadedOffset() {
        FileDownloadDatabase fileDownloadDatabase = CustomComponentHolder.getImpl().getDatabaseInstance();
        if (((DownloadRunnable)((Object)fileDownloadModel)).connectionIndex >= 0) {
            for (ConnectionModel connectionModel : fileDownloadDatabase.findConnectionModel(((DownloadRunnable)((Object)fileDownloadModel)).downloadId)) {
                if (connectionModel.getIndex() != ((DownloadRunnable)((Object)fileDownloadModel)).connectionIndex) continue;
                return connectionModel.getCurrentOffset();
            }
        } else {
            FileDownloadModel fileDownloadModel = fileDownloadDatabase.find(((DownloadRunnable)((Object)fileDownloadModel)).downloadId);
            if (fileDownloadModel != null) {
                return fileDownloadModel.getSoFar();
            }
        }
        return 0L;
    }

    public /* synthetic */ DownloadRunnable(int n2, int n3, ConnectTask connectTask, ProcessCallback processCallback, boolean bl, String string, 1 var7_7) {
        this(n2, n3, connectTask, processCallback, bl, string);
    }

    public void pause() {
        ((DownloadRunnable)((Object)fetchDataTask)).paused = true;
        FetchDataTask fetchDataTask = ((DownloadRunnable)((Object)fetchDataTask)).fetchDataTask;
        if (fetchDataTask != null) {
            fetchDataTask.pause();
        }
    }

    public void discard() {
        this.pause();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block24: {
            block26: {
                block23: {
                    Process.setThreadPriority((int)10);
                    var1_2 = null;
                    this.connectTask.getProfile().currentOffset;
                    var2_3 = false;
                    while (true) {
                        block25: {
                            block22: {
                                block20: {
                                    block21: {
                                        if (!this.paused) break block20;
                                        if (var1_2 == null) break block21;
                                        var1_2.ending();
                                    }
                                    return;
                                }
                                var2_3 = false;
                                var1_2 = this.connectTask.connect();
                                var3_5 = var1_2.getResponseCode();
                                if (!FileDownloadLog.NEED_LOG) ** GOTO lbl30
                                v0 = this;
                                v1 = "the connection[%d] for %d, is connected %s with code[%d]";
                                v2 = new Object[4];
                                v2[0] = this.connectionIndex;
                                v2[1] = this.downloadId;
                                v2[2] = this.connectTask.getProfile();
                                var4_11 = 3;
                                v2[var4_11] = var3_5;
                                FileDownloadLog.d(v0, v1, v2);
lbl30:
                                // 2 sources

                                if (var3_5 == 206 || var3_5 == 200) ** GOTO lbl47
                                v3 = v4;
                                v5 = v4;
                                v6 = "Connection failed with request[%s] response[%s] http-state[%d] on task[%d-%d], which is changed after verify connection, so please try again.";
                                v7 = new Object[5];
                                var4_12 = v7;
                                v8 = var3_5;
                                var4_12[0] = this.connectTask.getRequestHeader();
                                var3_5 = 1;
                                var4_12[var3_5] = var1_2.getResponseHeaderFields();
                                var3_5 = 2;
                                v7[var3_5] = v8;
                                v7[3] = this.downloadId;
                                v7[4] = this.connectionIndex;
                                v3(FileDownloadUtils.formatString(v6, v7));
                                throw v5;
lbl47:
                                // 1 sources

                                v9 = this;
                                var2_3 = true;
                                var3_6 = v10;
                                v10 = new FetchDataTask.Builder();
                                if (!v9.paused) break block22;
                                var1_2.ending();
                                return;
                            }
                            v11 = this;
                            v12 = var3_6.setDownloadId(this.downloadId).setConnectionIndex(this.connectionIndex).setCallback(this.callback).setHost(this).setWifiRequired(this.isWifiRequired).setConnection(var1_2).setConnectionProfile(this.connectTask.getProfile()).setPath(this.path).build();
                            try {
                                this.fetchDataTask = v12;
                                v12.run();
                                if (v11.paused) {
                                    this.fetchDataTask.pause();
                                }
                                break block23;
                            }
                            catch (Throwable var0_1) {
                                break block24;
                            }
                            catch (IllegalArgumentException var3_7) {
                                break block25;
                            }
                            catch (FileDownloadGiveUpRetryException var3_8) {
                                break block25;
                            }
                            catch (IOException var3_9) {
                                break block25;
                            }
                            catch (IllegalAccessException var3_10) {
                                // empty catch block
                            }
                        }
                        if (!this.callback.isRetry((Exception)var3_4)) break;
                        if (var2_3 && this.fetchDataTask == null) {
                            v13 = this;
                            FileDownloadLog.w(v13, "it is valid to retry and connection is valid but create fetch-data-task failed, so give up directly with %s", new Object[]{var3_4});
                            v13.callback.onError((Exception)var3_4);
                            if (var1_2 == null) break block26;
                            break block23;
                        }
                        if (this.fetchDataTask == null || (var4_13 = this.getDownloadedOffset()) <= 0L) ** GOTO lbl86
                        {
                            this.connectTask.updateConnectionProfile(var4_13);
lbl86:
                            // 2 sources

                            this.callback.onRetry((Exception)var3_4);
                            if (var1_2 == null) continue;
                            var1_2.ending();
                            continue;
                        }
                        break;
                    }
                    {
                        this.callback.onError((Exception)var3_4);
                        if (var1_2 == null) break block26;
                    }
                }
                var1_2.ending();
            }
            return;
        }
        if (var1_2 != null) {
            var1_2.ending();
        }
        throw var0_1;
    }

    public static class Builder {
        private final ConnectTask.Builder connectTaskBuilder;
        private ProcessCallback callback;
        private String path;
        private Boolean isWifiRequired;
        private Integer connectionIndex;

        public Builder() {
            ConnectTask.Builder builder;
            ConnectTask.Builder builder2 = builder;
            builder = new ConnectTask.Builder();
            v1.connectTaskBuilder = builder2;
        }

        public Builder setCallback(ProcessCallback processCallback) {
            this.callback = processCallback;
            return this;
        }

        public Builder setId(int n2) {
            Builder builder = this;
            builder.connectTaskBuilder.setDownloadId(n2);
            return builder;
        }

        public Builder setUrl(String string) {
            Builder builder = this;
            builder.connectTaskBuilder.setUrl(string);
            return builder;
        }

        public Builder setEtag(String string) {
            Builder builder = this;
            builder.connectTaskBuilder.setEtag(string);
            return builder;
        }

        public Builder setHeader(FileDownloadHeader fileDownloadHeader) {
            Builder builder = this;
            builder.connectTaskBuilder.setHeader(fileDownloadHeader);
            return builder;
        }

        public Builder setConnectionModel(ConnectionProfile connectionProfile) {
            Builder builder = this;
            builder.connectTaskBuilder.setConnectionProfile(connectionProfile);
            return builder;
        }

        public Builder setPath(String string) {
            this.path = string;
            return this;
        }

        public Builder setWifiRequired(boolean bl) {
            this.isWifiRequired = bl;
            return this;
        }

        public Builder setConnectionIndex(Integer n2) {
            this.connectionIndex = n2;
            return this;
        }

        public DownloadRunnable build() {
            if (this.callback != null && this.path != null && this.isWifiRequired != null && this.connectionIndex != null) {
                ConnectTask connectTask = this.connectTaskBuilder.build();
                Builder builder = this;
                int n2 = connectTask.downloadId;
                int n3 = builder.connectionIndex;
                ProcessCallback processCallback = builder.callback;
                boolean bl = builder.isWifiRequired;
                String string = builder.path;
                return new DownloadRunnable(n2, n3, connectTask, processCallback, bl, string, null);
            }
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.callback;
            objectArray2[1] = this.path;
            objectArray[2] = this.isWifiRequired;
            throw new IllegalArgumentException(FileDownloadUtils.formatString("%s %s %B", objectArray2));
        }

        public DownloadRunnable buildForTest(ConnectTask connectTask) {
            int n2 = connectTask.downloadId;
            ProcessCallback processCallback = this.callback;
            return new DownloadRunnable(n2, 0, connectTask, processCallback, false, "", null);
        }
    }
}

