/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import android.database.sqlite.SQLiteFullException;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadOutOfSpaceException;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.message.MessageSnapshotTaker;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.services.FileDownloadBroadcastHandler;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class DownloadStatusCallback
implements Handler.Callback {
    private static final int CALLBACK_SAFE_MIN_INTERVAL_BYTES = 1;
    private static final int CALLBACK_SAFE_MIN_INTERVAL_MILLIS = 5;
    private static final int NO_ANY_PROGRESS_CALLBACK = -1;
    private static final String ALREADY_DEAD_MESSAGE = "require callback %d but the host thread of the flow has already dead, what is occurred because of there are several reason can final this flow on different thread.";
    private final FileDownloadModel model;
    private final FileDownloadDatabase database;
    private final ProcessParams processParams;
    private final int maxRetryTimes;
    private final int callbackProgressMinInterval;
    private final int callbackProgressMaxCount;
    private long callbackMinIntervalBytes;
    private Handler handler;
    private HandlerThread handlerThread;
    private volatile boolean handlingMessage;
    private volatile Thread parkThread;
    private volatile long lastCallbackTimestamp;
    private final AtomicLong callbackIncreaseBuffer;
    private final AtomicBoolean needCallbackProgressToUser;
    private final AtomicBoolean needSetProcess;
    private final AtomicBoolean isFirstCallback;

    public DownloadStatusCallback(FileDownloadModel fileDownloadModel, int n2, int n3, int n4) {
        ProcessParams processParams;
        DownloadStatusCallback downloadStatusCallback = processParams2;
        ((DownloadStatusCallback)((Object)processParams2)).handlingMessage = false;
        ((DownloadStatusCallback)((Object)processParams2)).lastCallbackTimestamp = 0L;
        ((DownloadStatusCallback)((Object)processParams2)).callbackIncreaseBuffer = new AtomicLong();
        ((DownloadStatusCallback)((Object)processParams2)).needCallbackProgressToUser = new AtomicBoolean(false);
        ((DownloadStatusCallback)((Object)processParams2)).needSetProcess = new AtomicBoolean(false);
        ((DownloadStatusCallback)((Object)processParams2)).isFirstCallback = new AtomicBoolean(true);
        downloadStatusCallback.model = fileDownloadModel;
        downloadStatusCallback.database = CustomComponentHolder.getImpl().getDatabaseInstance();
        if (n3 < 5) {
            n3 = 5;
        }
        DownloadStatusCallback downloadStatusCallback2 = processParams2;
        downloadStatusCallback2.callbackProgressMinInterval = n3;
        downloadStatusCallback2.callbackProgressMaxCount = n4;
        ProcessParams processParams2 = processParams;
        processParams = new ProcessParams();
        downloadStatusCallback2.processParams = processParams2;
        downloadStatusCallback2.maxRetryTimes = n2;
    }

    private synchronized void sendMessage(Message message) {
        IllegalStateException illegalStateException2;
        block4: {
            block5: {
                Object[] objectArray;
                if (!objectArray.handlerThread.isAlive()) {
                    if (FileDownloadLog.NEED_LOG) {
                        Object[] objectArray2 = objectArray;
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = message.what;
                        FileDownloadLog.d(objectArray2, ALREADY_DEAD_MESSAGE, objectArray);
                    }
                    return;
                }
                try {
                    objectArray.handler.sendMessage(message);
                }
                catch (IllegalStateException illegalStateException2) {
                    if (objectArray.handlerThread.isAlive()) break block4;
                    if (!FileDownloadLog.NEED_LOG) break block5;
                    Object[] objectArray4 = objectArray;
                    Object[] objectArray5 = new Object[1];
                    objectArray = objectArray5;
                    objectArray5[0] = message.what;
                    FileDownloadLog.d(objectArray4, ALREADY_DEAD_MESSAGE, objectArray);
                }
            }
            return;
        }
        throw illegalStateException2;
    }

    private static long calculateCallbackMinIntervalBytes(long l2, long l3) {
        if (l3 <= 0L) {
            return -1L;
        }
        if (l2 == -1L) {
            return 1L;
        }
        if ((l2 /= l3) <= 0L) {
            l2 = 1L;
        }
        return l2;
    }

    private Exception exFiltrate(Exception object) {
        long l2;
        String string = object2.model.getTempFilePath();
        if ((object2.model.isChunked() || FileDownloadProperties.getImpl().fileNonPreAllocation) && object instanceof IOException && new File(string).exists() && (l2 = FileDownloadUtils.getFreeSpaceBytes(string)) <= 4096L) {
            Object object2;
            File file;
            long l3 = 0L;
            File file2 = file;
            if (!new File(string).exists()) {
                Object[] objectArray = object2;
                object2 = new Object[]{};
                FileDownloadLog.e((Object)objectArray, (Throwable)object, "Exception with: free space isn't enough, and the target file not exist.", object2);
            } else {
                l3 = file2.length();
            }
            if (Build.VERSION.SDK_INT >= 9) {
                FileDownloadOutOfSpaceException fileDownloadOutOfSpaceException;
                object2 = fileDownloadOutOfSpaceException;
                fileDownloadOutOfSpaceException = new FileDownloadOutOfSpaceException(l2, 4096L, l3, (Throwable)object);
                object = object2;
            } else {
                FileDownloadOutOfSpaceException fileDownloadOutOfSpaceException;
                object = fileDownloadOutOfSpaceException;
                fileDownloadOutOfSpaceException = new FileDownloadOutOfSpaceException(l2, 4096L, l3);
            }
        }
        return object;
    }

    private void handleSQLiteFullException(SQLiteFullException sQLiteFullException) {
        int n2 = this.model.getId();
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n2;
            objectArray[1] = sQLiteFullException.toString();
            FileDownloadLog.d(this, "the data of the task[%d] is dirty, because the SQLite full exception[%s], so remove it from the database directly.", objectArray2);
        }
        DownloadStatusCallback downloadStatusCallback = this;
        downloadStatusCallback.model.setErrMsg(sQLiteFullException.toString());
        downloadStatusCallback.model.setStatus((byte)-1);
        downloadStatusCallback.database.remove(n2);
        downloadStatusCallback.database.removeConnections(n2);
    }

    /*
     * Unable to fully structure code
     */
    private void renameTempFile() throws IOException {
        block13: {
            block14: {
                var1_1 = this.model.getTempFilePath();
                var2_2 = this.model.getTargetFilePath();
                var3_5 = v0;
                v0 = new File(var1_1);
                var4_6 = true;
                var5_7 = v1;
                try {
                    if (!new File(var2_2).exists()) ** GOTO lbl50
                }
                catch (Throwable var2_4) {
                    if (var4_6 && var3_5.exists() && !var3_5.delete()) {
                        v2 = this;
                        v3 = new Object[1];
                        this = v3;
                        v3[0] = var1_1;
                        FileDownloadLog.w(v2, "delete the temp file(%s) failed, on completed downloading.", this);
                    }
                    throw var2_4;
                }
                v4 = var5_7;
                var6_8 = var5_7.length();
                if (!v4.delete()) ** GOTO lbl37
                v5 = this;
                v6 = "The target file([%s], [%d]) will be replaced with the new downloaded file[%d]";
                v7 = new Object[3];
                var8_10 = v7;
                v8 = var6_8;
                var8_10[0] = var2_2;
                var6_9 = 1;
                v7[var6_9] = v8;
                v7[2] = var3_5.length();
                FileDownloadLog.w(v5, v6, v7);
                ** GOTO lbl50
lbl37:
                // 1 sources

                v9 = v10;
                v11 = v10;
                v12 = "Can't delete the old file([%s], [%d]), so can't replace it with the new downloaded one.";
                v13 = new Object[2];
                var5_7 = v13;
                v14 = var6_8;
                var5_7[0] = var2_2;
                var2_3 = 1;
                v13[var2_3] = v14;
                v9(FileDownloadUtils.formatString(v12, v13));
                throw v11;
lbl50:
                // 2 sources

                if (var4_6 = var3_5.renameTo((File)var5_7) ^ true) break block13;
                if (!var4_6 || !var3_5.exists() || var3_5.delete()) break block14;
                v15 = this;
                v16 = new Object[1];
                this = v16;
                v16[0] = var1_1;
                FileDownloadLog.w(v15, "delete the temp file(%s) failed, on completed downloading.", this);
            }
            return;
        }
        throw new IOException(FileDownloadUtils.formatString("Can't rename the  temp downloaded file(%s) to the target file(%s)", new Object[]{var1_1, var2_2}));
    }

    private void handleProgress() {
        if (this.model.getSoFar() == this.model.getTotal()) {
            this.database.updateProgress(this.model.getId(), this.model.getSoFar());
            return;
        }
        if (this.needSetProcess.compareAndSet(true, false)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.i(this, "handleProgress update model's status with progress", new Object[0]);
            }
            this.model.setStatus((byte)3);
        }
        if (this.needCallbackProgressToUser.compareAndSet(true, false)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.i(this, "handleProgress notify user progress status", new Object[0]);
            }
            this.onStatusChanged((byte)3);
        }
    }

    private void handleCompleted() throws IOException {
        DownloadStatusCallback downloadStatusCallback = this;
        downloadStatusCallback.renameTempFile();
        downloadStatusCallback.model.setStatus((byte)-3);
        downloadStatusCallback.database.updateCompleted(this.model.getId(), this.model.getTotal());
        downloadStatusCallback.database.removeConnections(this.model.getId());
        downloadStatusCallback.onStatusChanged((byte)-3);
        if (FileDownloadProperties.getImpl().broadcastCompleted) {
            FileDownloadBroadcastHandler.sendCompletedBroadcast(this.model);
        }
    }

    private boolean interceptBeforeCompleted() {
        if (this.model.isChunked()) {
            FileDownloadModel fileDownloadModel = this.model;
            fileDownloadModel.setTotal(fileDownloadModel.getSoFar());
        } else if (this.model.getSoFar() != this.model.getTotal()) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.model.getSoFar();
            objectArray[1] = this.model.getTotal();
            this.onErrorDirectly(new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("sofar[%d] not equal total[%d]", objectArray2)));
            return true;
        }
        return false;
    }

    private void handleRetry(Exception exception, int n2) {
        DownloadStatusCallback downloadStatusCallback = this;
        exception = downloadStatusCallback.exFiltrate(exception);
        downloadStatusCallback.processParams.setException(exception);
        downloadStatusCallback.processParams.setRetryingTimes(this.maxRetryTimes - n2);
        downloadStatusCallback.model.setStatus((byte)5);
        downloadStatusCallback.model.setErrMsg(exception.toString());
        downloadStatusCallback.database.updateRetry(this.model.getId(), exception);
        downloadStatusCallback.onStatusChanged((byte)5);
    }

    private void handlePaused() {
        DownloadStatusCallback downloadStatusCallback = this;
        downloadStatusCallback.model.setStatus((byte)-2);
        downloadStatusCallback.database.updatePause(this.model.getId(), this.model.getSoFar());
        downloadStatusCallback.onStatusChanged((byte)-2);
    }

    private void handleError(Exception exception) {
        Throwable throwable = this.exFiltrate(exception);
        if (throwable instanceof SQLiteFullException) {
            this.handleSQLiteFullException((SQLiteFullException)throwable);
        } else {
            try {
                DownloadStatusCallback downloadStatusCallback = this;
                downloadStatusCallback.model.setStatus((byte)-1);
                downloadStatusCallback.model.setErrMsg(exception.toString());
                downloadStatusCallback.database.updateError(this.model.getId(), throwable, this.model.getSoFar());
            }
            catch (SQLiteFullException sQLiteFullException) {
                throwable = sQLiteFullException;
                this.handleSQLiteFullException((SQLiteFullException)throwable);
            }
        }
        DownloadStatusCallback downloadStatusCallback = this;
        downloadStatusCallback.processParams.setException((Exception)throwable);
        downloadStatusCallback.onStatusChanged((byte)-1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void inspectNeedCallbackToUser(long l2) {
        if (!this.isFirstCallback.compareAndSet(true, false)) {
            long l3 = l2 - this.lastCallbackTimestamp;
            if (this.callbackMinIntervalBytes == -1L) return;
            if (this.callbackIncreaseBuffer.get() < this.callbackMinIntervalBytes) return;
            if (l3 < (long)this.callbackProgressMinInterval) return;
        }
        boolean bl = true;
        if (!bl) return;
        if (!this.needCallbackProgressToUser.compareAndSet(false, true)) return;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.i(this, "inspectNeedCallbackToUser need callback to user", new Object[0]);
        }
        this.lastCallbackTimestamp = l2;
        this.callbackIncreaseBuffer.set(0L);
    }

    private void onStatusChanged(byte by) {
        if (by == -2) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = ((DownloadStatusCallback)((Object)fileDownloadModel)).model.getId();
                FileDownloadLog.d(fileDownloadModel, "High concurrent cause, Already paused and we don't need to call-back to Task in here, %d", objectArray2);
            }
            return;
        }
        DownloadStatusCallback downloadStatusCallback = fileDownloadModel;
        FileDownloadModel fileDownloadModel = downloadStatusCallback.model;
        MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.take(by, fileDownloadModel, downloadStatusCallback.processParams));
    }

    public boolean isAlive() {
        DownloadStatusCallback downloadStatusCallback = downloadStatusCallback.handlerThread;
        return downloadStatusCallback != null && downloadStatusCallback.isAlive();
    }

    public void discardAllMessage() {
        Handler handler = this.handler;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
            this.handlerThread.quit();
            this.parkThread = Thread.currentThread();
            while (this.handlingMessage) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
            }
            this.parkThread = null;
        }
    }

    public void onPending() {
        DownloadStatusCallback downloadStatusCallback = this;
        downloadStatusCallback.model.setStatus((byte)1);
        downloadStatusCallback.database.updatePending(this.model.getId());
        downloadStatusCallback.onStatusChanged((byte)1);
    }

    public void onStartThread() {
        DownloadStatusCallback downloadStatusCallback = this;
        downloadStatusCallback.model.setStatus((byte)6);
        downloadStatusCallback.onStatusChanged((byte)6);
        downloadStatusCallback.database.onTaskStart(this.model.getId());
    }

    public void onConnected(boolean bl, long l2, String string, String string2) throws IllegalArgumentException {
        String string3 = objectArray2.model.getETag();
        if (string3 != null && !string3.equals(string)) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = string3;
            throw new IllegalArgumentException(FileDownloadUtils.formatString("callback onConnected must with precondition succeed, but the etag is changes(%s != %s)", objectArray2));
        }
        Object[] objectArray = objectArray2;
        objectArray.processParams.setResuming(bl);
        objectArray2.model.setStatus((byte)2);
        objectArray.model.setTotal(l2);
        objectArray2.model.setETag(string);
        objectArray.model.setFilename(string2);
        objectArray2.database.updateConnected(objectArray2.model.getId(), l2, string, string2);
        super.onStatusChanged((byte)2);
        objectArray2.callbackMinIntervalBytes = DownloadStatusCallback.calculateCallbackMinIntervalBytes(l2, objectArray2.callbackProgressMaxCount);
        objectArray2.needSetProcess.compareAndSet(false, true);
    }

    public void onMultiConnection() {
        this.handlerThread = new HandlerThread("source-status-callback");
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper(), (Handler.Callback)this);
    }

    public void onProgress(long l2) {
        DownloadStatusCallback downloadStatusCallback = this;
        downloadStatusCallback.callbackIncreaseBuffer.addAndGet(l2);
        downloadStatusCallback.model.increaseSoFar(l2);
        downloadStatusCallback.inspectNeedCallbackToUser(SystemClock.elapsedRealtime());
        if (downloadStatusCallback.handler == null) {
            this.handleProgress();
        } else if (this.needCallbackProgressToUser.get()) {
            DownloadStatusCallback downloadStatusCallback2 = this;
            downloadStatusCallback2.sendMessage(downloadStatusCallback2.handler.obtainMessage(3));
        }
    }

    public void onRetry(Exception exception, int n2) {
        DownloadStatusCallback downloadStatusCallback = this;
        downloadStatusCallback.callbackIncreaseBuffer.set(0L);
        Handler handler = downloadStatusCallback.handler;
        if (handler == null) {
            this.handleRetry(exception, n2);
        } else {
            this.sendMessage(handler.obtainMessage(5, n2, 0, (Object)exception));
        }
    }

    public void onPausedDirectly() {
        this.handlePaused();
    }

    public void onErrorDirectly(Exception exception) {
        this.handleError(exception);
    }

    public void onCompletedDirectly() throws IOException {
        if (this.interceptBeforeCompleted()) {
            return;
        }
        this.handleCompleted();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean handleMessage(Message var1_1) {
        block7: {
            this.handlingMessage = true;
            var2_3 = var1_1 /* !! */ .what;
            if (var2_3 == 3) ** GOTO lbl11
            if (var2_3 != 5) {
            } else {
                v0 = var1_1 /* !! */ ;
                var1_1 /* !! */  = (Exception)v0.obj;
                this.handleRetry((Exception)var1_1 /* !! */ , v0.arg1);
                break block7;
lbl11:
                // 1 sources

                this.handleProgress();
            }
        }
        return true;
        finally {
            this.handlingMessage = false;
            if (this.parkThread != null) {
                LockSupport.unpark(this.parkThread);
            }
        }
    }

    public static class ProcessParams {
        private boolean isResuming;
        private Exception exception;
        private int retryingTimes;

        public void setResuming(boolean bl) {
            this.isResuming = bl;
        }

        public boolean isResuming() {
            return this.isResuming;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public void setRetryingTimes(int n2) {
            this.retryingTimes = n2;
        }

        public Exception getException() {
            return this.exception;
        }

        public int getRetryingTimes() {
            return this.retryingTimes;
        }
    }
}

