/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import android.os.SystemClock;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.ConnectionProfile;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.download.DownloadRunnable;
import com.liulishuo.filedownloader.download.ProcessCallback;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadNetworkPolicyException;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.IOException;
import java.io.InputStream;

public class FetchDataTask {
    public static final int BUFFER_SIZE = 4096;
    private final ProcessCallback callback;
    private final int downloadId;
    private final int connectionIndex;
    private final DownloadRunnable hostRunnable;
    private final FileDownloadConnection connection;
    private final boolean isWifiRequired;
    private final long startOffset;
    private final long endOffset;
    private final long contentLength;
    private final String path;
    public long currentOffset;
    private FileDownloadOutputStream outputStream;
    private volatile boolean paused;
    private final FileDownloadDatabase database;
    private volatile long lastSyncBytes;
    private volatile long lastSyncTimestamp;

    private FetchDataTask(FileDownloadConnection fileDownloadConnection, ConnectionProfile connectionProfile, DownloadRunnable downloadRunnable, int n2, int n3, boolean bl, ProcessCallback processCallback, String string) {
        FetchDataTask fetchDataTask = this;
        this.lastSyncBytes = 0L;
        this.lastSyncTimestamp = 0L;
        this.callback = processCallback;
        this.path = string;
        this.connection = fileDownloadConnection;
        this.isWifiRequired = bl;
        this.hostRunnable = downloadRunnable;
        this.connectionIndex = n3;
        fetchDataTask.downloadId = n2;
        fetchDataTask.database = CustomComponentHolder.getImpl().getDatabaseInstance();
        this.startOffset = connectionProfile.startOffset;
        this.endOffset = connectionProfile.endOffset;
        this.currentOffset = connectionProfile.currentOffset;
        this.contentLength = connectionProfile.contentLength;
    }

    private void checkAndSync() {
        long l2 = SystemClock.elapsedRealtime();
        if (FileDownloadUtils.isNeedSync(this.currentOffset - this.lastSyncBytes, l2 - this.lastSyncTimestamp)) {
            FetchDataTask fetchDataTask = this;
            fetchDataTask.sync();
            fetchDataTask.lastSyncBytes = fetchDataTask.currentOffset;
            this.lastSyncTimestamp = l2;
        }
    }

    private void sync() {
        int n2;
        int n3;
        long l2 = SystemClock.uptimeMillis();
        try {
            this.outputStream.flushAndSync();
            n3 = 1;
        }
        catch (IOException iOException) {
            n2 = 0;
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = iOException;
                FileDownloadLog.d(this, "Because of the system cannot guarantee that all the buffers have been synchronized with physical media, or write to filefailed, we just not flushAndSync process to database too %s", objectArray2);
            }
            n3 = n2;
        }
        if (n3 != 0) {
            n3 = this.connectionIndex;
            if (n3 >= 0) {
                FetchDataTask fetchDataTask = this;
                n2 = fetchDataTask.downloadId;
                long l3 = fetchDataTask.currentOffset;
                this.database.updateConnectionModel(n2, n3, l3);
            } else {
                this.callback.syncProgressFromCache();
            }
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[4];
                Object[] objectArray3 = objectArray;
                objectArray3[0] = this.downloadId;
                objectArray3[1] = this.connectionIndex;
                objectArray[2] = this.currentOffset;
                objectArray[3] = SystemClock.uptimeMillis() - l2;
                FileDownloadLog.d(this, "require flushAndSync id[%d] index[%d] offset[%d], consume[%d]", objectArray3);
            }
        }
    }

    public /* synthetic */ FetchDataTask(FileDownloadConnection fileDownloadConnection, ConnectionProfile connectionProfile, DownloadRunnable downloadRunnable, int n2, int n3, boolean bl, ProcessCallback processCallback, String string, 1 var9_9) {
        this(fileDownloadConnection, connectionProfile, downloadRunnable, n2, n3, bl, processCallback, string);
    }

    public void pause() {
        this.paused = true;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws IOException, IllegalAccessException, IllegalArgumentException, FileDownloadGiveUpRetryException {
        int n2;
        byte[] byArray;
        FileDownloadOutputStream fileDownloadOutputStream;
        InputStream inputStream;
        long l2;
        long l3;
        block56: {
            block57: {
                if (((FetchDataTask)((Object)downloadRunnable)).paused) {
                    return;
                }
                l3 = FileDownloadUtils.findContentLength(((FetchDataTask)((Object)downloadRunnable)).connectionIndex, ((FetchDataTask)((Object)downloadRunnable)).connection);
                if (l3 == -1L) {
                    l3 = FileDownloadUtils.findContentLengthFromContentRange(((FetchDataTask)((Object)downloadRunnable)).connection);
                }
                if (l3 == 0L) {
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = ((FetchDataTask)((Object)downloadRunnable)).downloadId;
                    objectArray[1] = ((FetchDataTask)((Object)downloadRunnable)).connectionIndex;
                    throw new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("there isn't any content need to download on %d-%d with the content-length is 0", objectArray2));
                }
                l2 = ((FetchDataTask)((Object)downloadRunnable)).contentLength;
                if (l2 > 0L && l3 != l2) {
                    void var3_13;
                    if (((FetchDataTask)((Object)downloadRunnable)).endOffset == -1L) {
                        Object[] objectArray = new Object[1];
                        Object[] objectArray3 = objectArray;
                        objectArray[0] = ((FetchDataTask)((Object)downloadRunnable)).currentOffset;
                        String string = FileDownloadUtils.formatString("range[%d-)", objectArray3);
                    } else {
                        Object[] objectArray = new Object[2];
                        Object[] objectArray4 = objectArray;
                        objectArray4[0] = ((FetchDataTask)((Object)downloadRunnable)).currentOffset;
                        objectArray[1] = ((FetchDataTask)((Object)downloadRunnable)).endOffset;
                        String string = FileDownloadUtils.formatString("range[%d-%d)", objectArray4);
                    }
                    Object[] objectArray = new Object[5];
                    Object[] objectArray5 = objectArray;
                    objectArray5[0] = var3_13;
                    objectArray5[1] = ((FetchDataTask)((Object)downloadRunnable)).contentLength;
                    objectArray5[2] = l3;
                    objectArray5[3] = ((FetchDataTask)((Object)downloadRunnable)).downloadId;
                    objectArray[4] = ((FetchDataTask)((Object)downloadRunnable)).connectionIndex;
                    throw new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("require %s with contentLength(%d), but the backend response contentLength is %d on downloadId[%d]-connectionIndex[%d], please ask your backend dev to fix such problem.", objectArray5));
                }
                FetchDataTask fetchDataTask = downloadRunnable;
                l2 = fetchDataTask.currentOffset;
                inputStream = null;
                fileDownloadOutputStream = null;
                boolean bl = CustomComponentHolder.getImpl().isSupportSeek();
                if (fetchDataTask.hostRunnable != null) {
                    if (!bl) throw new IllegalAccessException("can't using multi-download when the output stream can't support seek");
                }
                fileDownloadOutputStream = FileDownloadUtils.createOutputStream(((FetchDataTask)((Object)downloadRunnable)).path);
                ((FetchDataTask)((Object)downloadRunnable)).outputStream = fileDownloadOutputStream;
                if (bl) {
                    fileDownloadOutputStream.seek(((FetchDataTask)((Object)downloadRunnable)).currentOffset);
                }
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(downloadRunnable, "start fetch(%d): range [%d, %d), seek to[%d]", ((FetchDataTask)((Object)downloadRunnable)).connectionIndex, ((FetchDataTask)((Object)downloadRunnable)).startOffset, ((FetchDataTask)((Object)downloadRunnable)).endOffset, ((FetchDataTask)((Object)downloadRunnable)).currentOffset);
                }
                FetchDataTask fetchDataTask2 = downloadRunnable;
                inputStream = fetchDataTask2.connection.getInputStream();
                byArray = new byte[4096];
                if (!fetchDataTask2.paused) break block56;
                if (inputStream == null) break block57;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileDownloadOutputStream != null) {
                try {
                    ((FetchDataTask)((Object)downloadRunnable)).sync();
                }
                catch (Throwable throwable) {
                    try {
                        fileDownloadOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable;
                }
            }
            if (fileDownloadOutputStream == null) return;
            try {
                fileDownloadOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        while (true) {
            n2 = inputStream.read(byArray);
            if (n2 != -1) break block58;
            break;
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileDownloadOutputStream != null) {
                try {
                    ((FetchDataTask)((Object)downloadRunnable)).sync();
                }
                catch (Throwable throwable2) {
                    try {
                        fileDownloadOutputStream.close();
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable2;
                }
            }
            if (fileDownloadOutputStream == null) throw throwable;
            try {
                fileDownloadOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        {
            block59: {
                FileDownloadOutputStream fileDownloadOutputStream2;
                block58: {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (fileDownloadOutputStream != null) {
                        try {
                            ((FetchDataTask)((Object)downloadRunnable)).sync();
                        }
                        catch (Throwable throwable) {
                            try {
                                fileDownloadOutputStream.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            throw throwable;
                        }
                    }
                    if (fileDownloadOutputStream != null) {
                        try {
                            fileDownloadOutputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    long l4 = ((FetchDataTask)((Object)downloadRunnable)).currentOffset - l2;
                    if (l3 != -1L && l3 != l4) {
                        Object[] objectArray = new Object[6];
                        Object[] objectArray6 = objectArray;
                        objectArray6[0] = l4;
                        objectArray6[1] = l3;
                        objectArray6[2] = ((FetchDataTask)((Object)downloadRunnable)).startOffset;
                        objectArray6[3] = ((FetchDataTask)((Object)downloadRunnable)).endOffset;
                        objectArray6[4] = ((FetchDataTask)((Object)downloadRunnable)).currentOffset;
                        objectArray[5] = l2;
                        throw new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("fetched length[%d] != content length[%d], range[%d, %d) offset[%d] fetch begin offset[%d]", objectArray6));
                    }
                    FetchDataTask fetchDataTask = downloadRunnable;
                    DownloadRunnable downloadRunnable = fetchDataTask.hostRunnable;
                    l3 = fetchDataTask.startOffset;
                    l2 = fetchDataTask.endOffset;
                    ((FetchDataTask)((Object)downloadRunnable)).callback.onCompleted(downloadRunnable, l3, l2);
                    return;
                }
                FetchDataTask fetchDataTask = downloadRunnable;
                FetchDataTask fetchDataTask3 = fetchDataTask;
                FetchDataTask fetchDataTask4 = fetchDataTask;
                FetchDataTask fetchDataTask5 = fetchDataTask;
                FetchDataTask fetchDataTask6 = fetchDataTask;
                fileDownloadOutputStream.write(byArray, 0, n2);
                long l5 = fetchDataTask.currentOffset;
                long l6 = n2;
                fetchDataTask4.currentOffset = l5 + l6;
                fetchDataTask5.callback.onProgress(l6);
                fetchDataTask6.checkAndSync();
                if (!fetchDataTask3.paused) break block59;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    fileDownloadOutputStream2 = fileDownloadOutputStream;
                    super.sync();
                }
                catch (Throwable throwable) {
                    try {
                        fileDownloadOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    fileDownloadOutputStream2.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            if (!((FetchDataTask)((Object)downloadRunnable)).isWifiRequired) continue;
            if (FileDownloadUtils.isNetworkNotOnWifiType()) throw new FileDownloadNetworkPolicyException();
            continue;
        }
    }

    public static class Builder {
        public DownloadRunnable downloadRunnable;
        public FileDownloadConnection connection;
        public ConnectionProfile connectionProfile;
        public ProcessCallback callback;
        public String path;
        public Boolean isWifiRequired;
        public Integer connectionIndex;
        public Integer downloadId;

        public Builder setConnection(FileDownloadConnection fileDownloadConnection) {
            this.connection = fileDownloadConnection;
            return this;
        }

        public Builder setConnectionProfile(ConnectionProfile connectionProfile) {
            this.connectionProfile = connectionProfile;
            return this;
        }

        public Builder setCallback(ProcessCallback processCallback) {
            this.callback = processCallback;
            return this;
        }

        public Builder setPath(String string) {
            this.path = string;
            return this;
        }

        public Builder setWifiRequired(boolean bl) {
            this.isWifiRequired = bl;
            return this;
        }

        public Builder setHost(DownloadRunnable downloadRunnable) {
            this.downloadRunnable = downloadRunnable;
            return this;
        }

        public Builder setConnectionIndex(int n2) {
            this.connectionIndex = n2;
            return this;
        }

        public Builder setDownloadId(int n2) {
            this.downloadId = n2;
            return this;
        }

        public FetchDataTask build() throws IllegalArgumentException {
            Integer n2;
            ConnectionProfile connectionProfile;
            FileDownloadConnection fileDownloadConnection;
            if (((Builder)((Object)downloadRunnable)).isWifiRequired != null && (fileDownloadConnection = ((Builder)((Object)downloadRunnable)).connection) != null && (connectionProfile = ((Builder)((Object)downloadRunnable)).connectionProfile) != null && ((Builder)((Object)downloadRunnable)).callback != null && ((Builder)((Object)downloadRunnable)).path != null && (n2 = ((Builder)((Object)downloadRunnable)).downloadId) != null && ((Builder)((Object)downloadRunnable)).connectionIndex != null) {
                Builder builder = downloadRunnable;
                DownloadRunnable downloadRunnable = ((Builder)((Object)downloadRunnable)).downloadRunnable;
                int n3 = n2;
                int n4 = builder.connectionIndex;
                boolean bl = builder.isWifiRequired;
                ProcessCallback processCallback = builder.callback;
                String string = builder.path;
                return new FetchDataTask(fileDownloadConnection, connectionProfile, downloadRunnable, n3, n4, bl, processCallback, string, null);
            }
            throw new IllegalArgumentException();
        }
    }
}

