/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import android.os.Parcel;
import com.liulishuo.filedownloader.message.IFlowDirectly;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import java.io.Serializable;

public abstract class LargeMessageSnapshot
extends MessageSnapshot {
    public LargeMessageSnapshot(int n2) {
        super(n2);
        this.isLargeFile = true;
    }

    public LargeMessageSnapshot(Parcel parcel) {
        super(parcel);
    }

    @Override
    public int getSmallSofarBytes() {
        if (this.getLargeSofarBytes() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.getLargeSofarBytes();
    }

    @Override
    public int getSmallTotalBytes() {
        if (this.getLargeTotalBytes() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.getLargeTotalBytes();
    }

    public static class PausedSnapshot
    extends PendingMessageSnapshot {
        public PausedSnapshot(int n2, long l2, long l3) {
            super(n2, l2, l3);
        }

        @Override
        public byte getStatus() {
            return -2;
        }
    }

    public static class WarnMessageSnapshot
    extends PendingMessageSnapshot
    implements MessageSnapshot.IWarnMessageSnapshot {
        public WarnMessageSnapshot(int n2, long l2, long l3) {
            super(n2, l2, l3);
        }

        public WarnMessageSnapshot(Parcel parcel) {
            super(parcel);
        }

        @Override
        public MessageSnapshot turnToPending() {
            return new PendingMessageSnapshot(this);
        }

        @Override
        public byte getStatus() {
            return -4;
        }
    }

    public static class WarnFlowDirectlySnapshot
    extends WarnMessageSnapshot
    implements IFlowDirectly {
        public WarnFlowDirectlySnapshot(int n2, long l2, long l3) {
            super(n2, l2, l3);
        }

        public WarnFlowDirectlySnapshot(Parcel parcel) {
            super(parcel);
        }
    }

    public static class RetryMessageSnapshot
    extends ErrorMessageSnapshot {
        private final int retryingTimes;

        public RetryMessageSnapshot(int n2, long l2, Throwable throwable, int n3) {
            super(n2, l2, throwable);
            this.retryingTimes = n3;
        }

        public RetryMessageSnapshot(Parcel parcel) {
            super(parcel);
            this.retryingTimes = parcel.readInt();
        }

        @Override
        public int getRetryingTimes() {
            return this.retryingTimes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            RetryMessageSnapshot retryMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeInt(retryMessageSnapshot.retryingTimes);
        }

        @Override
        public byte getStatus() {
            return 5;
        }
    }

    public static class ErrorMessageSnapshot
    extends LargeMessageSnapshot {
        private final long sofarBytes;
        private final Throwable throwable;

        public ErrorMessageSnapshot(int n2, long l2, Throwable throwable) {
            super(n2);
            this.sofarBytes = l2;
            this.throwable = throwable;
        }

        public ErrorMessageSnapshot(Parcel parcel) {
            super(parcel);
            this.sofarBytes = parcel.readLong();
            this.throwable = (Throwable)parcel.readSerializable();
        }

        @Override
        public long getLargeSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public byte getStatus() {
            return -1;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            ErrorMessageSnapshot errorMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeLong(errorMessageSnapshot.sofarBytes);
            parcel.writeSerializable((Serializable)this.throwable);
        }
    }

    public static class CompletedSnapshot
    extends LargeMessageSnapshot {
        private final boolean reusedDownloadedFile;
        private final long totalBytes;

        public CompletedSnapshot(int n2, boolean bl, long l2) {
            super(n2);
            this.reusedDownloadedFile = bl;
            this.totalBytes = l2;
        }

        public CompletedSnapshot(Parcel parcel) {
            super(parcel);
            boolean bl = parcel.readByte() != 0;
            this.reusedDownloadedFile = bl;
            this.totalBytes = parcel.readLong();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            CompletedSnapshot completedSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeByte((byte)(completedSnapshot.reusedDownloadedFile ? 1 : 0));
            parcel.writeLong(this.totalBytes);
        }

        @Override
        public byte getStatus() {
            return -3;
        }

        @Override
        public long getLargeTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public boolean isReusedDownloadedFile() {
            return this.reusedDownloadedFile;
        }
    }

    public static class CompletedFlowDirectlySnapshot
    extends CompletedSnapshot
    implements IFlowDirectly {
        public CompletedFlowDirectlySnapshot(int n2, boolean bl, long l2) {
            super(n2, bl, l2);
        }

        public CompletedFlowDirectlySnapshot(Parcel parcel) {
            super(parcel);
        }
    }

    public static class ProgressMessageSnapshot
    extends LargeMessageSnapshot {
        private final long sofarBytes;

        public ProgressMessageSnapshot(int n2, long l2) {
            super(n2);
            this.sofarBytes = l2;
        }

        public ProgressMessageSnapshot(Parcel parcel) {
            super(parcel);
            this.sofarBytes = parcel.readLong();
        }

        @Override
        public byte getStatus() {
            return 3;
        }

        @Override
        public long getLargeSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            ProgressMessageSnapshot progressMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeLong(progressMessageSnapshot.sofarBytes);
        }
    }

    public static class ConnectedMessageSnapshot
    extends LargeMessageSnapshot {
        private final boolean resuming;
        private final long totalBytes;
        private final String etag;
        private final String fileName;

        public ConnectedMessageSnapshot(int n2, boolean bl, long l2, String string, String string2) {
            super(n2);
            this.resuming = bl;
            this.totalBytes = l2;
            this.etag = string;
            this.fileName = string2;
        }

        public ConnectedMessageSnapshot(Parcel parcel) {
            super(parcel);
            boolean bl = parcel.readByte() != 0;
            this.resuming = bl;
            this.totalBytes = parcel.readLong();
            this.etag = parcel.readString();
            this.fileName = parcel.readString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            ConnectedMessageSnapshot connectedMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeByte((byte)(connectedMessageSnapshot.resuming ? 1 : 0));
            parcel.writeLong(this.totalBytes);
            parcel.writeString(this.etag);
            parcel.writeString(this.fileName);
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public byte getStatus() {
            return 2;
        }

        @Override
        public boolean isResuming() {
            return this.resuming;
        }

        @Override
        public long getLargeTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public String getEtag() {
            return this.etag;
        }
    }

    public static class PendingMessageSnapshot
    extends LargeMessageSnapshot {
        private final long sofarBytes;
        private final long totalBytes;

        public PendingMessageSnapshot(PendingMessageSnapshot pendingMessageSnapshot) {
            PendingMessageSnapshot pendingMessageSnapshot2 = pendingMessageSnapshot;
            int n2 = pendingMessageSnapshot2.getId();
            long l2 = pendingMessageSnapshot2.getLargeSofarBytes();
            long l3 = pendingMessageSnapshot2.getLargeTotalBytes();
            this(n2, l2, l3);
        }

        public PendingMessageSnapshot(int n2, long l2, long l3) {
            super(n2);
            this.sofarBytes = l2;
            this.totalBytes = l3;
        }

        public PendingMessageSnapshot(Parcel parcel) {
            super(parcel);
            this.sofarBytes = parcel.readLong();
            this.totalBytes = parcel.readLong();
        }

        @Override
        public byte getStatus() {
            return 1;
        }

        @Override
        public long getLargeSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public long getLargeTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            PendingMessageSnapshot pendingMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeLong(pendingMessageSnapshot.sofarBytes);
            parcel.writeLong(this.totalBytes);
        }
    }
}

