/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import android.os.Parcel;
import android.os.Parcelable;
import com.liulishuo.filedownloader.message.IMessageSnapshot;
import com.liulishuo.filedownloader.message.LargeMessageSnapshot;
import com.liulishuo.filedownloader.message.SmallMessageSnapshot;
import com.liulishuo.filedownloader.util.FileDownloadUtils;

public abstract class MessageSnapshot
implements IMessageSnapshot,
Parcelable {
    public static final Parcelable.Creator<MessageSnapshot> CREATOR = new Parcelable.Creator<MessageSnapshot>(){

        public MessageSnapshot createFromParcel(Parcel parcel) {
            MessageSnapshot messageSnapshot;
            boolean bl = parcel.readByte() == 1;
            byte by = parcel.readByte();
            switch (by) {
                default: {
                    messageSnapshot = null;
                    break;
                }
                case 6: {
                    StartedMessageSnapshot startedMessageSnapshot;
                    messageSnapshot = startedMessageSnapshot;
                    startedMessageSnapshot = new StartedMessageSnapshot(parcel);
                    break;
                }
                case 5: {
                    SmallMessageSnapshot.RetryMessageSnapshot retryMessageSnapshot;
                    if (bl) {
                        LargeMessageSnapshot.RetryMessageSnapshot retryMessageSnapshot2;
                        messageSnapshot = retryMessageSnapshot2;
                        retryMessageSnapshot2 = new LargeMessageSnapshot.RetryMessageSnapshot(parcel);
                        break;
                    }
                    messageSnapshot = retryMessageSnapshot;
                    retryMessageSnapshot = new SmallMessageSnapshot.RetryMessageSnapshot(parcel);
                    break;
                }
                case 3: {
                    SmallMessageSnapshot.ProgressMessageSnapshot progressMessageSnapshot;
                    if (bl) {
                        LargeMessageSnapshot.ProgressMessageSnapshot progressMessageSnapshot2;
                        messageSnapshot = progressMessageSnapshot2;
                        progressMessageSnapshot2 = new LargeMessageSnapshot.ProgressMessageSnapshot(parcel);
                        break;
                    }
                    messageSnapshot = progressMessageSnapshot;
                    progressMessageSnapshot = new SmallMessageSnapshot.ProgressMessageSnapshot(parcel);
                    break;
                }
                case 2: {
                    SmallMessageSnapshot.ConnectedMessageSnapshot connectedMessageSnapshot;
                    if (bl) {
                        LargeMessageSnapshot.ConnectedMessageSnapshot connectedMessageSnapshot2;
                        messageSnapshot = connectedMessageSnapshot2;
                        connectedMessageSnapshot2 = new LargeMessageSnapshot.ConnectedMessageSnapshot(parcel);
                        break;
                    }
                    messageSnapshot = connectedMessageSnapshot;
                    connectedMessageSnapshot = new SmallMessageSnapshot.ConnectedMessageSnapshot(parcel);
                    break;
                }
                case 1: {
                    SmallMessageSnapshot.PendingMessageSnapshot pendingMessageSnapshot;
                    if (bl) {
                        LargeMessageSnapshot.PendingMessageSnapshot pendingMessageSnapshot2;
                        messageSnapshot = pendingMessageSnapshot2;
                        pendingMessageSnapshot2 = new LargeMessageSnapshot.PendingMessageSnapshot(parcel);
                        break;
                    }
                    messageSnapshot = pendingMessageSnapshot;
                    pendingMessageSnapshot = new SmallMessageSnapshot.PendingMessageSnapshot(parcel);
                    break;
                }
                case -1: {
                    SmallMessageSnapshot.ErrorMessageSnapshot errorMessageSnapshot;
                    if (bl) {
                        LargeMessageSnapshot.ErrorMessageSnapshot errorMessageSnapshot2;
                        messageSnapshot = errorMessageSnapshot2;
                        errorMessageSnapshot2 = new LargeMessageSnapshot.ErrorMessageSnapshot(parcel);
                        break;
                    }
                    messageSnapshot = errorMessageSnapshot;
                    errorMessageSnapshot = new SmallMessageSnapshot.ErrorMessageSnapshot(parcel);
                    break;
                }
                case -3: {
                    SmallMessageSnapshot.CompletedSnapshot completedSnapshot;
                    if (bl) {
                        LargeMessageSnapshot.CompletedSnapshot completedSnapshot2;
                        messageSnapshot = completedSnapshot2;
                        completedSnapshot2 = new LargeMessageSnapshot.CompletedSnapshot(parcel);
                        break;
                    }
                    messageSnapshot = completedSnapshot;
                    completedSnapshot = new SmallMessageSnapshot.CompletedSnapshot(parcel);
                    break;
                }
                case -4: {
                    SmallMessageSnapshot.WarnMessageSnapshot warnMessageSnapshot;
                    if (bl) {
                        LargeMessageSnapshot.WarnMessageSnapshot warnMessageSnapshot2;
                        messageSnapshot = warnMessageSnapshot2;
                        warnMessageSnapshot2 = new LargeMessageSnapshot.WarnMessageSnapshot(parcel);
                        break;
                    }
                    messageSnapshot = warnMessageSnapshot;
                    warnMessageSnapshot = new SmallMessageSnapshot.WarnMessageSnapshot(parcel);
                }
            }
            if (messageSnapshot != null) {
                messageSnapshot.isLargeFile = bl;
                return messageSnapshot;
            }
            throw new IllegalStateException("Can't restore the snapshot because unknown status: " + by);
        }

        public MessageSnapshot[] newArray(int n2) {
            return new MessageSnapshot[n2];
        }
    };
    private final int id;
    public boolean isLargeFile;

    public MessageSnapshot(int n2) {
        this.id = n2;
    }

    public MessageSnapshot(Parcel parcel) {
        this.id = parcel.readInt();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Throwable getThrowable() {
        throw new NoFieldException("getThrowable", this);
    }

    @Override
    public int getRetryingTimes() {
        throw new NoFieldException("getRetryingTimes", this);
    }

    @Override
    public boolean isResuming() {
        throw new NoFieldException("isResuming", this);
    }

    @Override
    public String getEtag() {
        throw new NoFieldException("getEtag", this);
    }

    @Override
    public long getLargeSofarBytes() {
        throw new NoFieldException("getLargeSofarBytes", this);
    }

    @Override
    public long getLargeTotalBytes() {
        throw new NoFieldException("getLargeTotalBytes", this);
    }

    @Override
    public int getSmallSofarBytes() {
        throw new NoFieldException("getSmallSofarBytes", this);
    }

    @Override
    public int getSmallTotalBytes() {
        throw new NoFieldException("getSmallTotalBytes", this);
    }

    @Override
    public boolean isReusedDownloadedFile() {
        throw new NoFieldException("isReusedDownloadedFile", this);
    }

    @Override
    public String getFileName() {
        throw new NoFieldException("getFileName", this);
    }

    @Override
    public boolean isLargeFile() {
        return this.isLargeFile;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeByte((byte)(this.isLargeFile ? 1 : 0));
        parcel.writeByte(this.getStatus());
        parcel.writeInt(this.id);
    }

    @Override
    public abstract /* synthetic */ byte getStatus();

    public static class StartedMessageSnapshot
    extends MessageSnapshot {
        public StartedMessageSnapshot(int n2) {
            super(n2);
        }

        public StartedMessageSnapshot(Parcel parcel) {
            super(parcel);
        }

        @Override
        public byte getStatus() {
            return 6;
        }
    }

    public static class NoFieldException
    extends IllegalStateException {
        public NoFieldException(String string, MessageSnapshot messageSnapshot) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[4];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = string;
            objectArray3[1] = messageSnapshot.getId();
            objectArray3[2] = messageSnapshot.getStatus();
            objectArray2[3] = messageSnapshot.getClass().getName();
            super(FileDownloadUtils.formatString("There isn't a field for '%s' in this message %d %d %s", objectArray3));
        }
    }

    public static interface IWarnMessageSnapshot {
        public MessageSnapshot turnToPending();
    }
}

