/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import android.os.Parcel;
import com.liulishuo.filedownloader.message.IFlowDirectly;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import java.io.Serializable;

public abstract class SmallMessageSnapshot
extends MessageSnapshot {
    public SmallMessageSnapshot(int n2) {
        super(n2);
        this.isLargeFile = false;
    }

    public SmallMessageSnapshot(Parcel parcel) {
        super(parcel);
    }

    @Override
    public long getLargeTotalBytes() {
        return this.getSmallTotalBytes();
    }

    @Override
    public long getLargeSofarBytes() {
        return this.getSmallSofarBytes();
    }

    public static class PausedSnapshot
    extends PendingMessageSnapshot {
        public PausedSnapshot(int n2, int n3, int n4) {
            super(n2, n3, n4);
        }

        @Override
        public byte getStatus() {
            return -2;
        }
    }

    public static class WarnMessageSnapshot
    extends PendingMessageSnapshot
    implements MessageSnapshot.IWarnMessageSnapshot {
        public WarnMessageSnapshot(int n2, int n3, int n4) {
            super(n2, n3, n4);
        }

        public WarnMessageSnapshot(Parcel parcel) {
            super(parcel);
        }

        @Override
        public MessageSnapshot turnToPending() {
            return new PendingMessageSnapshot(this);
        }

        @Override
        public byte getStatus() {
            return -4;
        }
    }

    public static class WarnFlowDirectlySnapshot
    extends WarnMessageSnapshot
    implements IFlowDirectly {
        public WarnFlowDirectlySnapshot(int n2, int n3, int n4) {
            super(n2, n3, n4);
        }

        public WarnFlowDirectlySnapshot(Parcel parcel) {
            super(parcel);
        }
    }

    public static class RetryMessageSnapshot
    extends ErrorMessageSnapshot {
        private final int retryingTimes;

        public RetryMessageSnapshot(int n2, int n3, Throwable throwable, int n4) {
            super(n2, n3, throwable);
            this.retryingTimes = n4;
        }

        public RetryMessageSnapshot(Parcel parcel) {
            super(parcel);
            this.retryingTimes = parcel.readInt();
        }

        @Override
        public int getRetryingTimes() {
            return this.retryingTimes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            RetryMessageSnapshot retryMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeInt(retryMessageSnapshot.retryingTimes);
        }

        @Override
        public byte getStatus() {
            return 5;
        }
    }

    public static class ErrorMessageSnapshot
    extends SmallMessageSnapshot {
        private final int sofarBytes;
        private final Throwable throwable;

        public ErrorMessageSnapshot(int n2, int n3, Throwable throwable) {
            super(n2);
            this.sofarBytes = n3;
            this.throwable = throwable;
        }

        public ErrorMessageSnapshot(Parcel parcel) {
            super(parcel);
            this.sofarBytes = parcel.readInt();
            this.throwable = (Throwable)parcel.readSerializable();
        }

        @Override
        public int getSmallSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public byte getStatus() {
            return -1;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            ErrorMessageSnapshot errorMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeInt(errorMessageSnapshot.sofarBytes);
            parcel.writeSerializable((Serializable)this.throwable);
        }
    }

    public static class CompletedSnapshot
    extends SmallMessageSnapshot {
        private final boolean reusedDownloadedFile;
        private final int totalBytes;

        public CompletedSnapshot(int n2, boolean bl, int n3) {
            super(n2);
            this.reusedDownloadedFile = bl;
            this.totalBytes = n3;
        }

        public CompletedSnapshot(Parcel parcel) {
            super(parcel);
            boolean bl = parcel.readByte() != 0;
            this.reusedDownloadedFile = bl;
            this.totalBytes = parcel.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            CompletedSnapshot completedSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeByte((byte)(completedSnapshot.reusedDownloadedFile ? 1 : 0));
            parcel.writeInt(this.totalBytes);
        }

        @Override
        public byte getStatus() {
            return -3;
        }

        @Override
        public int getSmallTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public boolean isReusedDownloadedFile() {
            return this.reusedDownloadedFile;
        }
    }

    public static class CompletedFlowDirectlySnapshot
    extends CompletedSnapshot
    implements IFlowDirectly {
        public CompletedFlowDirectlySnapshot(int n2, boolean bl, int n3) {
            super(n2, bl, n3);
        }

        public CompletedFlowDirectlySnapshot(Parcel parcel) {
            super(parcel);
        }
    }

    public static class ProgressMessageSnapshot
    extends SmallMessageSnapshot {
        private final int sofarBytes;

        public ProgressMessageSnapshot(int n2, int n3) {
            super(n2);
            this.sofarBytes = n3;
        }

        public ProgressMessageSnapshot(Parcel parcel) {
            super(parcel);
            this.sofarBytes = parcel.readInt();
        }

        @Override
        public byte getStatus() {
            return 3;
        }

        @Override
        public int getSmallSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            ProgressMessageSnapshot progressMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeInt(progressMessageSnapshot.sofarBytes);
        }
    }

    public static class ConnectedMessageSnapshot
    extends SmallMessageSnapshot {
        private final boolean resuming;
        private final int totalBytes;
        private final String etag;
        private final String fileName;

        public ConnectedMessageSnapshot(int n2, boolean bl, int n3, String string, String string2) {
            super(n2);
            this.resuming = bl;
            this.totalBytes = n3;
            this.etag = string;
            this.fileName = string2;
        }

        public ConnectedMessageSnapshot(Parcel parcel) {
            super(parcel);
            boolean bl = parcel.readByte() != 0;
            this.resuming = bl;
            this.totalBytes = parcel.readInt();
            this.etag = parcel.readString();
            this.fileName = parcel.readString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            ConnectedMessageSnapshot connectedMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeByte((byte)(connectedMessageSnapshot.resuming ? 1 : 0));
            parcel.writeInt(this.totalBytes);
            parcel.writeString(this.etag);
            parcel.writeString(this.fileName);
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public byte getStatus() {
            return 2;
        }

        @Override
        public boolean isResuming() {
            return this.resuming;
        }

        @Override
        public int getSmallTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public String getEtag() {
            return this.etag;
        }
    }

    public static class PendingMessageSnapshot
    extends SmallMessageSnapshot {
        private final int sofarBytes;
        private final int totalBytes;

        public PendingMessageSnapshot(PendingMessageSnapshot pendingMessageSnapshot) {
            PendingMessageSnapshot pendingMessageSnapshot2 = pendingMessageSnapshot;
            int n2 = pendingMessageSnapshot2.getId();
            int n3 = pendingMessageSnapshot2.getSmallSofarBytes();
            int n4 = pendingMessageSnapshot2.getSmallTotalBytes();
            this(n2, n3, n4);
        }

        public PendingMessageSnapshot(int n2, int n3, int n4) {
            super(n2);
            this.sofarBytes = n3;
            this.totalBytes = n4;
        }

        public PendingMessageSnapshot(Parcel parcel) {
            super(parcel);
            this.sofarBytes = parcel.readInt();
            this.totalBytes = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            PendingMessageSnapshot pendingMessageSnapshot = this;
            super.writeToParcel(parcel, n2);
            parcel.writeInt(pendingMessageSnapshot.sofarBytes);
            parcel.writeInt(this.totalBytes);
        }

        @Override
        public byte getStatus() {
            return 1;
        }

        @Override
        public int getSmallSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public int getSmallTotalBytes() {
            return this.totalBytes;
        }
    }
}

