/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.model;

import android.content.ContentValues;
import android.os.Parcel;
import android.os.Parcelable;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FileDownloadModel
implements Parcelable {
    public static final int TOTAL_VALUE_IN_CHUNKED_RESOURCE = -1;
    public static final int DEFAULT_CALLBACK_PROGRESS_TIMES = 100;
    public static final String ID = "_id";
    public static final String URL = "url";
    public static final String PATH = "path";
    public static final String PATH_AS_DIRECTORY = "pathAsDirectory";
    public static final String FILENAME = "filename";
    public static final String STATUS = "status";
    public static final String SOFAR = "sofar";
    public static final String TOTAL = "total";
    public static final String ERR_MSG = "errMsg";
    public static final String ETAG = "etag";
    public static final String CONNECTION_COUNT = "connectionCount";
    public static final Parcelable.Creator<FileDownloadModel> CREATOR = new Parcelable.Creator<FileDownloadModel>(){

        public FileDownloadModel createFromParcel(Parcel parcel) {
            return new FileDownloadModel(parcel);
        }

        public FileDownloadModel[] newArray(int n2) {
            return new FileDownloadModel[n2];
        }
    };
    private int id;
    private String url;
    private String path;
    private boolean pathAsDirectory;
    private String filename;
    private final AtomicInteger status;
    private final AtomicLong soFar;
    private long total;
    private String errMsg;
    private String eTag;
    private int connectionCount;
    private boolean isLargeFile;

    public FileDownloadModel() {
        AtomicInteger atomicInteger;
        AtomicLong atomicLong;
        Object object = atomicLong;
        atomicLong = new AtomicLong();
        v1.soFar = object;
        object = atomicInteger;
        atomicInteger = new AtomicInteger();
        v1.status = object;
    }

    public FileDownloadModel(Parcel parcel) {
        this.id = parcel.readInt();
        this.url = parcel.readString();
        this.path = parcel.readString();
        boolean bl = parcel.readByte() != 0;
        FileDownloadModel fileDownloadModel = this;
        this.pathAsDirectory = bl;
        fileDownloadModel.filename = parcel.readString();
        fileDownloadModel.status = new AtomicInteger(parcel.readByte());
        fileDownloadModel.soFar = new AtomicLong(parcel.readLong());
        this.total = parcel.readLong();
        this.errMsg = parcel.readString();
        this.eTag = parcel.readString();
        this.connectionCount = parcel.readInt();
        boolean bl2 = parcel.readByte() != 0;
        this.isLargeFile = bl2;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setPath(String string, boolean bl) {
        FileDownloadModel fileDownloadModel = this;
        fileDownloadModel.path = string;
        fileDownloadModel.pathAsDirectory = bl;
    }

    public void setStatus(byte by) {
        this.status.set(by);
    }

    public void setSoFar(long l2) {
        this.soFar.set(l2);
    }

    public void increaseSoFar(long l2) {
        this.soFar.addAndGet(l2);
    }

    public void setTotal(long l2) {
        boolean bl = l2 > Integer.MAX_VALUE;
        FileDownloadModel fileDownloadModel = this;
        fileDownloadModel.isLargeFile = bl;
        fileDownloadModel.total = l2;
    }

    public int getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getTargetFilePath() {
        FileDownloadModel fileDownloadModel = this;
        boolean bl = fileDownloadModel.isPathAsDirectory();
        return FileDownloadUtils.getTargetFilePath(this.getPath(), bl, fileDownloadModel.getFilename());
    }

    public String getTempFilePath() {
        if (this.getTargetFilePath() == null) {
            return null;
        }
        return FileDownloadUtils.getTempPath(this.getTargetFilePath());
    }

    public byte getStatus() {
        return (byte)this.status.get();
    }

    public long getSoFar() {
        return this.soFar.get();
    }

    public long getTotal() {
        return this.total;
    }

    public boolean isChunked() {
        return this.total == -1L;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String string) {
        this.eTag = string;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String string) {
        this.errMsg = string;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public boolean isPathAsDirectory() {
        return this.pathAsDirectory;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setConnectionCount(int n2) {
        this.connectionCount = n2;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public void resetConnectionCount() {
        this.connectionCount = 1;
    }

    public ContentValues toContentValues() {
        ContentValues contentValues;
        ContentValues contentValues2 = contentValues;
        contentValues2();
        contentValues2.put(ID, Integer.valueOf(this.getId()));
        contentValues2.put(URL, this.getUrl());
        contentValues2.put(PATH, this.getPath());
        contentValues2.put(STATUS, Byte.valueOf(this.getStatus()));
        contentValues2.put(SOFAR, Long.valueOf(this.getSoFar()));
        contentValues2.put(TOTAL, Long.valueOf(this.getTotal()));
        contentValues2.put(ERR_MSG, this.getErrMsg());
        contentValues2.put(ETAG, this.getETag());
        contentValues2.put(CONNECTION_COUNT, Integer.valueOf(this.getConnectionCount()));
        contentValues.put(PATH_AS_DIRECTORY, Boolean.valueOf(this.isPathAsDirectory()));
        if (this.isPathAsDirectory() && this.getFilename() != null) {
            contentValues2.put(FILENAME, this.getFilename());
        }
        return contentValues2;
    }

    public boolean isLargeFile() {
        return this.isLargeFile;
    }

    public void deleteTaskFiles() {
        FileDownloadModel fileDownloadModel = this;
        fileDownloadModel.deleteTempFile();
        fileDownloadModel.deleteTargetFile();
    }

    public void deleteTempFile() {
        if ((this = ((FileDownloadModel)this).getTempFilePath()) != null) {
            File file;
            File file2 = file;
            if (new File((String)this).exists()) {
                file2.delete();
            }
        }
    }

    public void deleteTargetFile() {
        if ((this = ((FileDownloadModel)this).getTargetFilePath()) != null) {
            File file;
            File file2 = file;
            if (new File((String)this).exists()) {
                file2.delete();
            }
        }
    }

    public String toString() {
        Object[] objectArray = new Object[8];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.id;
        objectArray2[1] = this.url;
        objectArray2[2] = this.path;
        objectArray2[3] = this.status.get();
        objectArray2[4] = this.soFar;
        objectArray2[5] = this.total;
        objectArray2[6] = this.eTag;
        objectArray[7] = super.toString();
        return FileDownloadUtils.formatString("id[%d], url[%s], path[%s], status[%d], sofar[%s], total[%d], etag[%s], %s", objectArray2);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.id);
        parcel.writeString(this.url);
        parcel.writeString(this.path);
        parcel.writeByte((byte)(this.pathAsDirectory ? 1 : 0));
        parcel.writeString(this.filename);
        parcel.writeByte((byte)this.status.get());
        parcel.writeLong(this.soFar.get());
        parcel.writeLong(this.total);
        parcel.writeString(this.errMsg);
        parcel.writeString(this.eTag);
        parcel.writeInt(this.connectionCount);
        parcel.writeByte((byte)(this.isLargeFile ? 1 : 0));
    }
}

