/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.model;

import com.liulishuo.filedownloader.BaseDownloadTask;

public class FileDownloadStatus {
    public static final byte toLaunchPool = 10;
    public static final byte toFileDownloadService = 11;
    public static final byte pending = 1;
    public static final byte started = 6;
    public static final byte connected = 2;
    public static final byte progress = 3;
    public static final byte blockComplete = 4;
    public static final byte retry = 5;
    public static final byte error = -1;
    public static final byte paused = -2;
    public static final byte completed = -3;
    public static final byte warn = -4;
    public static final byte INVALID_STATUS = 0;

    public static boolean isOver(int n2) {
        return n2 < 0;
    }

    public static boolean isIng(int n2) {
        return n2 > 0;
    }

    public static boolean isKeepAhead(int n2, int n3) {
        if (n2 != 3 && n2 != 5 && n2 == n3) {
            return false;
        }
        if (FileDownloadStatus.isOver(n2)) {
            return false;
        }
        if (n2 >= 1 && n2 <= 6 && n3 >= 10 && n3 <= 11) {
            return false;
        }
        switch (n2) {
            default: {
                return true;
            }
            case 6: {
                return n3 != 0 && n3 != 1;
            }
            case 5: {
                return n3 != 1 && n3 != 6;
            }
            case 3: {
                return n3 != 0 && n3 != 1 && n3 != 2 && n3 != 6;
            }
            case 2: {
                return n3 != 0 && n3 != 1 && n3 != 6;
            }
            case 1: 
        }
        return n3 != 0;
    }

    public static boolean isKeepFlow(int n2, int n3) {
        if (n2 != 3 && n2 != 5 && n2 == n3) {
            return false;
        }
        if (FileDownloadStatus.isOver(n2)) {
            return false;
        }
        if (n3 == -2) {
            return true;
        }
        if (n3 == -1) {
            return true;
        }
        switch (n2) {
            default: {
                return false;
            }
            case 11: {
                return n3 == -4 || n3 == -3 || n3 == 1;
            }
            case 10: {
                return n3 == 11;
            }
            case 5: 
            case 6: {
                return n3 == 2 || n3 == 5;
            }
            case 2: 
            case 3: {
                return n3 == -3 || n3 == 3 || n3 == 5;
            }
            case 1: {
                return n3 == 6;
            }
            case 0: 
        }
        return n3 == 10;
    }

    public static boolean isMoreLikelyCompleted(BaseDownloadTask baseDownloadTask) {
        return baseDownloadTask.getStatus() == 0 || baseDownloadTask.getStatus() == 3;
    }
}

