/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.notification;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.notification.BaseNotificationItem;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationHelper;

public abstract class FileDownloadNotificationListener
extends FileDownloadListener {
    private final FileDownloadNotificationHelper helper;

    public FileDownloadNotificationListener(FileDownloadNotificationHelper fileDownloadNotificationHelper) {
        if (fileDownloadNotificationHelper != null) {
            this.helper = fileDownloadNotificationHelper;
            return;
        }
        throw new IllegalArgumentException("helper must not be null!");
    }

    public FileDownloadNotificationHelper getHelper() {
        return this.helper;
    }

    public void addNotificationItem(int n2) {
        if (n2 == 0) {
            return;
        }
        BaseDownloadTask.IRunningTask iRunningTask = FileDownloadList.getImpl().get(n2);
        if (iRunningTask != null) {
            this.addNotificationItem(iRunningTask.getOrigin());
        }
    }

    public void addNotificationItem(BaseDownloadTask object) {
        if (this.disableNotification((BaseDownloadTask)object)) {
            return;
        }
        if ((object = this.create((BaseDownloadTask)object)) != null) {
            this.helper.add(object);
        }
    }

    public void destroyNotification(BaseDownloadTask baseDownloadTask) {
        if (this.disableNotification(baseDownloadTask)) {
            return;
        }
        FileDownloadNotificationListener fileDownloadNotificationListener = this;
        BaseDownloadTask baseDownloadTask2 = baseDownloadTask;
        int n2 = baseDownloadTask2.getId();
        fileDownloadNotificationListener.helper.showIndeterminate(n2, baseDownloadTask2.getStatus());
        Object t2 = fileDownloadNotificationListener.helper.remove(baseDownloadTask.getId());
        if (!this.interceptCancel(baseDownloadTask, (BaseNotificationItem)t2) && t2 != null) {
            ((BaseNotificationItem)t2).cancel();
        }
    }

    public void showIndeterminate(BaseDownloadTask baseDownloadTask) {
        if (this.disableNotification(baseDownloadTask)) {
            return;
        }
        BaseDownloadTask baseDownloadTask2 = baseDownloadTask;
        int n2 = baseDownloadTask2.getId();
        this.helper.showIndeterminate(n2, baseDownloadTask2.getStatus());
    }

    public void showProgress(BaseDownloadTask baseDownloadTask, int n2, int n3) {
        if (this.disableNotification(baseDownloadTask)) {
            return;
        }
        BaseDownloadTask baseDownloadTask2 = baseDownloadTask;
        int n4 = baseDownloadTask2.getId();
        int n5 = baseDownloadTask2.getSmallFileSoFarBytes();
        n2 = baseDownloadTask2.getSmallFileTotalBytes();
        this.helper.showProgress(n4, n5, n2);
    }

    public abstract BaseNotificationItem create(BaseDownloadTask var1);

    public boolean interceptCancel(BaseDownloadTask baseDownloadTask, BaseNotificationItem baseNotificationItem) {
        return false;
    }

    public boolean disableNotification(BaseDownloadTask baseDownloadTask) {
        return false;
    }

    @Override
    public void pending(BaseDownloadTask baseDownloadTask, int n2, int n3) {
        FileDownloadNotificationListener fileDownloadNotificationListener = this;
        fileDownloadNotificationListener.addNotificationItem(baseDownloadTask);
        fileDownloadNotificationListener.showIndeterminate(baseDownloadTask);
    }

    @Override
    public void started(BaseDownloadTask baseDownloadTask) {
        FileDownloadNotificationListener fileDownloadNotificationListener = this;
        super.started(baseDownloadTask);
        fileDownloadNotificationListener.showIndeterminate(baseDownloadTask);
    }

    @Override
    public void progress(BaseDownloadTask baseDownloadTask, int n2, int n3) {
        this.showProgress(baseDownloadTask, n2, n3);
    }

    @Override
    public void retry(BaseDownloadTask baseDownloadTask, Throwable throwable, int n2, int n3) {
        FileDownloadNotificationListener fileDownloadNotificationListener = this;
        super.retry(baseDownloadTask, throwable, n2, n3);
        fileDownloadNotificationListener.showIndeterminate(baseDownloadTask);
    }

    @Override
    public void blockComplete(BaseDownloadTask baseDownloadTask) {
    }

    @Override
    public void completed(BaseDownloadTask baseDownloadTask) {
        this.destroyNotification(baseDownloadTask);
    }

    @Override
    public void paused(BaseDownloadTask baseDownloadTask, int n2, int n3) {
        this.destroyNotification(baseDownloadTask);
    }

    @Override
    public void error(BaseDownloadTask baseDownloadTask, Throwable throwable) {
        this.destroyNotification(baseDownloadTask);
    }

    @Override
    public void warn(BaseDownloadTask baseDownloadTask) {
    }
}

