/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import com.liulishuo.filedownloader.FileDownloadEventPool;
import com.liulishuo.filedownloader.IFileDownloadServiceProxy;
import com.liulishuo.filedownloader.event.DownloadServiceConnectChangedEvent;
import com.liulishuo.filedownloader.event.IDownloadEvent;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class BaseFileServiceUIGuard<CALLBACK extends Binder, INTERFACE extends IInterface>
implements IFileDownloadServiceProxy,
ServiceConnection {
    private final CALLBACK callback;
    private volatile INTERFACE service;
    private final Class<?> serviceClass;
    public boolean runServiceForeground = false;
    private final HashMap<String, Object> uiCacheMap = new HashMap();
    private final List<Context> bindContexts = new ArrayList<Context>();
    private final ArrayList<Runnable> connectedRunnableList = new ArrayList();

    public BaseFileServiceUIGuard(Class<?> clazz) {
        this.serviceClass = clazz;
        this.callback = this.createCallback();
    }

    private void releaseConnect(boolean bl) {
        Object[] objectArray;
        if (!bl && this.service != null) {
            BaseFileServiceUIGuard baseFileServiceUIGuard = this;
            BaseFileServiceUIGuard baseFileServiceUIGuard2 = baseFileServiceUIGuard;
            BaseFileServiceUIGuard baseFileServiceUIGuard3 = baseFileServiceUIGuard;
            objectArray = baseFileServiceUIGuard.service;
            try {
                baseFileServiceUIGuard2.unregisterCallback(objectArray, baseFileServiceUIGuard3.callback);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.service;
            FileDownloadLog.d(this, "release connect resources %s", objectArray);
        }
        this.service = null;
        FileDownloadEventPool fileDownloadEventPool = FileDownloadEventPool.getImpl();
        DownloadServiceConnectChangedEvent.ConnectStatus connectStatus = bl ? DownloadServiceConnectChangedEvent.ConnectStatus.lost : DownloadServiceConnectChangedEvent.ConnectStatus.disconnected;
        objectArray = new DownloadServiceConnectChangedEvent(connectStatus, this.serviceClass);
        fileDownloadEventPool.asyncPublishInNewThread((IDownloadEvent)objectArray);
    }

    public CALLBACK getCallback() {
        return this.callback;
    }

    public INTERFACE getService() {
        return this.service;
    }

    public abstract CALLBACK createCallback();

    public void onServiceConnected(ComponentName object, IBinder objectArray) {
        object2.service = object2.asInterface((IBinder)objectArray);
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = object;
            objectArray2[1] = object2.service;
            FileDownloadLog.d(object2, "onServiceConnected %s %s", objectArray);
        }
        BaseFileServiceUIGuard baseFileServiceUIGuard = object2;
        BaseFileServiceUIGuard baseFileServiceUIGuard2 = baseFileServiceUIGuard;
        BaseFileServiceUIGuard baseFileServiceUIGuard3 = baseFileServiceUIGuard;
        object = baseFileServiceUIGuard.service;
        try {
            baseFileServiceUIGuard2.registerCallback(object, baseFileServiceUIGuard3.callback);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        List list = (List)object2.connectedRunnableList.clone();
        object2.connectedRunnableList.clear();
        object = list.iterator();
        while (object.hasNext()) {
            ((Runnable)object.next()).run();
        }
        BaseFileServiceUIGuard baseFileServiceUIGuard4 = object2;
        Object object2 = DownloadServiceConnectChangedEvent.ConnectStatus.connected;
        FileDownloadEventPool.getImpl().asyncPublishInNewThread(new DownloadServiceConnectChangedEvent((DownloadServiceConnectChangedEvent.ConnectStatus)((Object)object2), baseFileServiceUIGuard4.serviceClass));
    }

    public void onServiceDisconnected(ComponentName componentName) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = componentName;
            objectArray[1] = this.service;
            FileDownloadLog.d(this, "onServiceDisconnected %s %s", objectArray2);
        }
        this.releaseConnect(true);
    }

    @Override
    public void bindStartByContext(Context context) {
        this.bindStartByContext(context, null);
    }

    @Override
    public void bindStartByContext(Context context, Runnable runnable) {
        if (!FileDownloadUtils.isDownloaderProcess(context)) {
            boolean bl;
            Intent intent;
            Intent intent2;
            if (FileDownloadLog.NEED_LOG) {
                Intent intent3 = new Object[1];
                intent2 = intent3;
                intent3[0] = context.getClass().getSimpleName();
                FileDownloadLog.d(this, "bindStartByContext %s", (Object[])intent2);
            }
            intent2 = intent;
            intent = new Intent(context, this.serviceClass);
            if (runnable != null && !this.connectedRunnableList.contains(runnable)) {
                this.connectedRunnableList.add(runnable);
            }
            if (!this.bindContexts.contains(context)) {
                this.bindContexts.add(context);
            }
            Intent intent4 = intent2;
            this.runServiceForeground = bl = FileDownloadUtils.needMakeServiceForeground(context);
            intent4.putExtra("is_foreground", bl);
            context.bindService(intent4, (ServiceConnection)this, 1);
            if (this.runServiceForeground) {
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, "start foreground service", new Object[0]);
                }
                if (Build.VERSION.SDK_INT >= 26) {
                    context.startForegroundService(intent2);
                }
            } else {
                context.startService(intent2);
            }
            return;
        }
        throw new IllegalStateException("Fatal-Exception: You can't bind the FileDownloadService in :filedownloader process.\n It's the invalid operation and is likely to cause unexpected problems.\n Maybe you want to use non-separate process mode for FileDownloader, More detail about non-separate mode, please move to wiki manually: https://github.com/lingochamp/FileDownloader/wiki/filedownloader.properties");
    }

    @Override
    public void unbindByContext(Context context) {
        Intent intent;
        Intent intent2;
        if (!this.bindContexts.contains(context)) {
            return;
        }
        if (FileDownloadLog.NEED_LOG) {
            Intent intent3 = new Object[1];
            intent2 = intent3;
            intent3[0] = context;
            FileDownloadLog.d(this, "unbindByContext %s", (Object[])intent2);
        }
        BaseFileServiceUIGuard baseFileServiceUIGuard = this;
        baseFileServiceUIGuard.bindContexts.remove(context);
        if (baseFileServiceUIGuard.bindContexts.isEmpty()) {
            this.releaseConnect(false);
        }
        Context context2 = context;
        intent2 = intent;
        intent = new Intent(context, this.serviceClass);
        context2.unbindService((ServiceConnection)this);
        context2.stopService(intent2);
    }

    @Override
    public boolean isRunServiceForeground() {
        return this.runServiceForeground;
    }

    public abstract INTERFACE asInterface(IBinder var1);

    public abstract void registerCallback(INTERFACE var1, CALLBACK var2) throws RemoteException;

    public abstract void unregisterCallback(INTERFACE var1, CALLBACK var2) throws RemoteException;

    public Object popCache(String string) {
        return this.uiCacheMap.remove(string);
    }

    public String putCache(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        this.uiCacheMap.put(string, object);
        return string;
    }

    @Override
    public boolean isConnected() {
        return this.getService() != null;
    }
}

