/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import com.liulishuo.filedownloader.connection.DefaultConnectionCountAdapter;
import com.liulishuo.filedownloader.connection.FileDownloadUrlConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.database.RemitDatabase;
import com.liulishuo.filedownloader.services.DefaultIdGenerator;
import com.liulishuo.filedownloader.services.ForegroundServiceConfig;
import com.liulishuo.filedownloader.stream.FileDownloadRandomAccessFile;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;

public class DownloadMgrInitialParams {
    private final InitCustomMaker mMaker;

    public DownloadMgrInitialParams() {
        this.mMaker = null;
    }

    public DownloadMgrInitialParams(InitCustomMaker initCustomMaker) {
        this.mMaker = initCustomMaker;
    }

    private ForegroundServiceConfig createDefaultForegroundServiceConfig() {
        return new ForegroundServiceConfig.Builder().needRecreateChannelId(true).build();
    }

    private FileDownloadHelper.IdGenerator createDefaultIdGenerator() {
        return new DefaultIdGenerator();
    }

    private int getDefaultMaxNetworkThreadCount() {
        return FileDownloadProperties.getImpl().downloadMaxNetworkThreadCount;
    }

    private FileDownloadDatabase createDefaultDatabase() {
        return new RemitDatabase();
    }

    private FileDownloadHelper.OutputStreamCreator createDefaultOutputStreamCreator() {
        return new FileDownloadRandomAccessFile.Creator();
    }

    private FileDownloadHelper.ConnectionCreator createDefaultConnectionCreator() {
        return new FileDownloadUrlConnection.Creator();
    }

    private FileDownloadHelper.ConnectionCountAdapter createDefaultConnectionCountAdapter() {
        return new DefaultConnectionCountAdapter();
    }

    public int getMaxNetworkThreadCount() {
        Object object = objectArray3.mMaker;
        if (object == null) {
            return objectArray3.getDefaultMaxNetworkThreadCount();
        }
        object = ((InitCustomMaker)object).mMaxNetworkThreadCount;
        if (object != null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object;
                FileDownloadLog.d(objectArray, "initial FileDownloader manager with the customize maxNetworkThreadCount: %d", objectArray3);
            }
            return FileDownloadProperties.getValidNetworkThreadCount((Integer)object);
        }
        return objectArray3.getDefaultMaxNetworkThreadCount();
    }

    public FileDownloadDatabase createDatabase() {
        Object object = objectArray3.mMaker;
        if (object != null && (object = ((InitCustomMaker)object).mDatabaseCustomMaker) != null) {
            if ((object = object.customMake()) != null) {
                if (FileDownloadLog.NEED_LOG) {
                    Object[] objectArray = objectArray3;
                    Object[] objectArray2 = new Object[1];
                    Object[] objectArray3 = objectArray2;
                    objectArray2[0] = object;
                    FileDownloadLog.d(objectArray, "initial FileDownloader manager with the customize database: %s", objectArray3);
                }
                return object;
            }
            return objectArray3.createDefaultDatabase();
        }
        return objectArray3.createDefaultDatabase();
    }

    public FileDownloadHelper.OutputStreamCreator createOutputStreamCreator() {
        Object object = objectArray3.mMaker;
        if (object == null) {
            return objectArray3.createDefaultOutputStreamCreator();
        }
        object = ((InitCustomMaker)object).mOutputStreamCreator;
        if (object != null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object;
                FileDownloadLog.d(objectArray, "initial FileDownloader manager with the customize output stream: %s", objectArray3);
            }
            return object;
        }
        return objectArray3.createDefaultOutputStreamCreator();
    }

    public FileDownloadHelper.ConnectionCreator createConnectionCreator() {
        Object object = objectArray3.mMaker;
        if (object == null) {
            return objectArray3.createDefaultConnectionCreator();
        }
        object = ((InitCustomMaker)object).mConnectionCreator;
        if (object != null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object;
                FileDownloadLog.d(objectArray, "initial FileDownloader manager with the customize connection creator: %s", objectArray3);
            }
            return object;
        }
        return objectArray3.createDefaultConnectionCreator();
    }

    public FileDownloadHelper.ConnectionCountAdapter createConnectionCountAdapter() {
        Object object = objectArray3.mMaker;
        if (object == null) {
            return objectArray3.createDefaultConnectionCountAdapter();
        }
        object = ((InitCustomMaker)object).mConnectionCountAdapter;
        if (object != null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object;
                FileDownloadLog.d(objectArray, "initial FileDownloader manager with the customize connection count adapter: %s", objectArray3);
            }
            return object;
        }
        return objectArray3.createDefaultConnectionCountAdapter();
    }

    public FileDownloadHelper.IdGenerator createIdGenerator() {
        Object object = objectArray3.mMaker;
        if (object == null) {
            return objectArray3.createDefaultIdGenerator();
        }
        object = ((InitCustomMaker)object).mIdGenerator;
        if (object != null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object;
                FileDownloadLog.d(objectArray, "initial FileDownloader manager with the customize id generator: %s", objectArray3);
            }
            return object;
        }
        return objectArray3.createDefaultIdGenerator();
    }

    public ForegroundServiceConfig createForegroundServiceConfig() {
        Object object = objectArray3.mMaker;
        if (object == null) {
            return objectArray3.createDefaultForegroundServiceConfig();
        }
        object = ((InitCustomMaker)object).mForegroundServiceConfig;
        if (object != null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object;
                FileDownloadLog.d(objectArray, "initial FileDownloader manager with the customize foreground service config: %s", objectArray3);
            }
            return object;
        }
        return objectArray3.createDefaultForegroundServiceConfig();
    }

    public static class InitCustomMaker {
        public FileDownloadHelper.DatabaseCustomMaker mDatabaseCustomMaker;
        public Integer mMaxNetworkThreadCount;
        public FileDownloadHelper.OutputStreamCreator mOutputStreamCreator;
        public FileDownloadHelper.ConnectionCreator mConnectionCreator;
        public FileDownloadHelper.ConnectionCountAdapter mConnectionCountAdapter;
        public FileDownloadHelper.IdGenerator mIdGenerator;
        public ForegroundServiceConfig mForegroundServiceConfig;

        public InitCustomMaker idGenerator(FileDownloadHelper.IdGenerator idGenerator) {
            this.mIdGenerator = idGenerator;
            return this;
        }

        public InitCustomMaker connectionCountAdapter(FileDownloadHelper.ConnectionCountAdapter connectionCountAdapter) {
            this.mConnectionCountAdapter = connectionCountAdapter;
            return this;
        }

        public InitCustomMaker database(FileDownloadHelper.DatabaseCustomMaker databaseCustomMaker) {
            this.mDatabaseCustomMaker = databaseCustomMaker;
            return this;
        }

        public InitCustomMaker maxNetworkThreadCount(int n2) {
            if (n2 > 0) {
                this.mMaxNetworkThreadCount = n2;
            }
            return this;
        }

        public InitCustomMaker outputStreamCreator(FileDownloadHelper.OutputStreamCreator outputStreamCreator) {
            this.mOutputStreamCreator = outputStreamCreator;
            if (outputStreamCreator != null && !outputStreamCreator.supportSeek() && !FileDownloadProperties.getImpl().fileNonPreAllocation) {
                throw new IllegalArgumentException("Since the provided FileDownloadOutputStream does not support the seek function, if FileDownloader pre-allocates file size at the beginning of the download, it will can not be resumed from the breakpoint. If you need to ensure that the resumption is available, please add and set the value of 'file.non-pre-allocation' field to 'true' in the 'filedownloader.properties' file which is in your application assets folder manually for resolving this problem.");
            }
            return this;
        }

        public InitCustomMaker connectionCreator(FileDownloadHelper.ConnectionCreator connectionCreator) {
            this.mConnectionCreator = connectionCreator;
            return this;
        }

        public InitCustomMaker foregroundServiceConfig(ForegroundServiceConfig foregroundServiceConfig) {
            this.mForegroundServiceConfig = foregroundServiceConfig;
            return this;
        }

        public void commit() {
        }

        public String toString() {
            Object[] objectArray = new Object[5];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mDatabaseCustomMaker;
            objectArray2[1] = this.mMaxNetworkThreadCount;
            objectArray2[2] = this.mOutputStreamCreator;
            objectArray2[3] = this.mConnectionCreator;
            objectArray[4] = this.mConnectionCountAdapter;
            return FileDownloadUtils.formatString("component: database[%s], maxNetworkCount[%s], outputStream[%s], connection[%s], connectionCountAdapter[%s]", objectArray2);
        }
    }
}

