/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.app.Notification;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import com.liulishuo.filedownloader.i.IFileDownloadIPCCallback;
import com.liulishuo.filedownloader.i.IFileDownloadIPCService;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.services.FileDownloadManager;
import com.liulishuo.filedownloader.services.FileDownloadService;
import com.liulishuo.filedownloader.services.IFileDownloadServiceHandler;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.lang.ref.WeakReference;

public class FDServiceSeparateHandler
extends IFileDownloadIPCService.Stub
implements MessageSnapshotFlow.MessageReceiver,
IFileDownloadServiceHandler {
    private final RemoteCallbackList<IFileDownloadIPCCallback> callbackList = new RemoteCallbackList();
    private final FileDownloadManager downloadManager;
    private final WeakReference<FileDownloadService> wService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized int callback(MessageSnapshot messageSnapshot) {
        int n2 = this.callbackList.beginBroadcast();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.callbackList.finishBroadcast();
                return n2;
            }
            try {
                ((IFileDownloadIPCCallback)this.callbackList.getBroadcastItem(n3)).callback(messageSnapshot);
                ++n3;
            }
            catch (RemoteException remoteException) {
                try {
                    FDServiceSeparateHandler fDServiceSeparateHandler = this;
                    FileDownloadLog.e((Object)fDServiceSeparateHandler, remoteException, "callback error", new Object[0]);
                    fDServiceSeparateHandler.callbackList.finishBroadcast();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            return n2;
        }
    }

    public FDServiceSeparateHandler(WeakReference<FileDownloadService> weakReference, FileDownloadManager fileDownloadManager) {
        this.wService = weakReference;
        this.downloadManager = fileDownloadManager;
        MessageSnapshotFlow.getImpl().setReceiver(this);
    }

    @Override
    public void registerCallback(IFileDownloadIPCCallback iFileDownloadIPCCallback) throws RemoteException {
        this.callbackList.register((IInterface)iFileDownloadIPCCallback);
    }

    @Override
    public void unregisterCallback(IFileDownloadIPCCallback iFileDownloadIPCCallback) throws RemoteException {
        this.callbackList.unregister((IInterface)iFileDownloadIPCCallback);
    }

    @Override
    public boolean checkDownloading(String string2, String string3) throws RemoteException {
        return this.downloadManager.isDownloading(string2, string3);
    }

    @Override
    public void start(String string2, String string3, boolean bl, int n2, int n3, int n4, boolean bl2, FileDownloadHeader fileDownloadHeader, boolean bl3) throws RemoteException {
        this.downloadManager.start(string2, string3, bl, n2, n3, n4, bl2, fileDownloadHeader, bl3);
    }

    @Override
    public boolean pause(int n2) throws RemoteException {
        return this.downloadManager.pause(n2);
    }

    @Override
    public void pauseAllTasks() throws RemoteException {
        this.downloadManager.pauseAll();
    }

    @Override
    public boolean setMaxNetworkThreadCount(int n2) throws RemoteException {
        return this.downloadManager.setMaxNetworkThreadCount(n2);
    }

    @Override
    public long getSofar(int n2) throws RemoteException {
        return this.downloadManager.getSoFar(n2);
    }

    @Override
    public long getTotal(int n2) throws RemoteException {
        return this.downloadManager.getTotal(n2);
    }

    @Override
    public byte getStatus(int n2) throws RemoteException {
        return this.downloadManager.getStatus(n2);
    }

    @Override
    public boolean isIdle() throws RemoteException {
        return this.downloadManager.isIdle();
    }

    @Override
    public void startForeground(int n2, Notification notification) throws RemoteException {
        WeakReference<FileDownloadService> weakReference = this.wService;
        if (weakReference != null && weakReference.get() != null) {
            ((FileDownloadService)((Object)this.wService.get())).startForeground(n2, notification);
        }
    }

    @Override
    public void stopForeground(boolean bl) throws RemoteException {
        WeakReference<FileDownloadService> weakReference = this.wService;
        if (weakReference != null && weakReference.get() != null) {
            ((FileDownloadService)((Object)this.wService.get())).stopForeground(bl);
        }
    }

    @Override
    public boolean clearTaskData(int n2) throws RemoteException {
        return this.downloadManager.clearTaskData(n2);
    }

    @Override
    public void clearAllTaskData() throws RemoteException {
        this.downloadManager.clearAllTaskData();
    }

    @Override
    public void onStartCommand(Intent intent, int n2, int n3) {
    }

    @Override
    public IBinder onBind(Intent intent) {
        return this;
    }

    @Override
    public void onDestroy() {
        MessageSnapshotFlow.getImpl().setReceiver(null);
    }

    @Override
    public void receive(MessageSnapshot messageSnapshot) {
        this.callback(messageSnapshot);
    }
}

