/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.text.TextUtils;
import com.liulishuo.filedownloader.IThreadPoolMonitor;
import com.liulishuo.filedownloader.PauseAllMarker;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.download.DownloadLaunchRunnable;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.services.FileDownloadThreadPool;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.List;

class FileDownloadManager
implements IThreadPoolMonitor {
    private final FileDownloadDatabase mDatabase;
    private final FileDownloadThreadPool mThreadPool;

    public FileDownloadManager() {
        CustomComponentHolder customComponentHolder = CustomComponentHolder.getImpl();
        v0.mDatabase = customComponentHolder.getDatabaseInstance();
        v0.mThreadPool = new FileDownloadThreadPool(customComponentHolder.getMaxNetworkThreadCount());
    }

    public synchronized void start(String object, String object22, boolean bl, int n2, int n3, int n4, boolean bl2, FileDownloadHeader fileDownloadHeader, boolean bl3) {
        boolean bl4;
        String string2;
        Object object3;
        Object object4;
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = object;
            objectArray2[1] = object22;
            objectArray[2] = bl;
            FileDownloadLog.d(object3, "request start the task with url(%s) path(%s) isDirectory(%B)", objectArray2);
        }
        PauseAllMarker.clearMarker();
        int n5 = FileDownloadUtils.generateId((String)object, (String)object22, bl);
        Object object5 = object3.mDatabase.find(n5);
        Object[] objectArray = null;
        if (!bl && object5 == null) {
            int n6 = FileDownloadUtils.generateId((String)object, FileDownloadUtils.getParent((String)object22), true);
            object4 = object3.mDatabase.find(n6);
            if (object4 != null && ((String)object22).equals(((FileDownloadModel)object4).getTargetFilePath())) {
                if (FileDownloadLog.NEED_LOG) {
                    Object[] objectArray3 = new Object[2];
                    objectArray = objectArray3;
                    objectArray[0] = n5;
                    objectArray3[1] = n6;
                    FileDownloadLog.d(object3, "task[%d] find model by dirCaseId[%d]", objectArray);
                }
                objectArray = object3.mDatabase.findConnectionModel(n6);
                object5 = object4;
            } else {
                object5 = object4;
            }
        }
        if (FileDownloadHelper.inspectAndInflowDownloading(n5, (FileDownloadModel)object5, (IThreadPoolMonitor)object3, true)) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray4 = object3;
                Object[] objectArray5 = new Object[1];
                object3 = objectArray5;
                objectArray5[0] = n5;
                FileDownloadLog.d(objectArray4, "has already started download %d", object3);
            }
            return;
        }
        object4 = object5 != null ? ((FileDownloadModel)object5).getTargetFilePath() : FileDownloadUtils.getTargetFilePath((String)object22, bl, null);
        if (FileDownloadHelper.inspectAndInflowDownloaded(n5, (String)object4, bl2, true)) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray6 = object3;
                Object[] objectArray7 = new Object[1];
                object3 = objectArray7;
                objectArray7[0] = n5;
                FileDownloadLog.d(objectArray6, "has already completed downloading %d", object3);
            }
            return;
        }
        long l2 = object5 != null ? ((FileDownloadModel)object5).getSoFar() : 0L;
        if (FileDownloadHelper.inspectAndInflowConflictPath(n5, l2, string2 = object5 != null ? ((FileDownloadModel)object5).getTempFilePath() : FileDownloadUtils.getTempPath((String)object4), (String)object4, (IThreadPoolMonitor)object3)) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray8 = new Object[2];
                object = objectArray8;
                objectArray8[0] = n5;
                objectArray8[1] = object4;
                FileDownloadLog.d(object3, "there is an another task with the same target-file-path %d %s", (Object[])object);
            }
            if (object5 != null) {
                object3.mDatabase.remove(n5);
                object3.mDatabase.removeConnections(n5);
            }
            return;
        }
        if (object5 != null && (((FileDownloadModel)object5).getStatus() == -2 || ((FileDownloadModel)object5).getStatus() == -1 || ((FileDownloadModel)object5).getStatus() == 1 || ((FileDownloadModel)object5).getStatus() == 6 || ((FileDownloadModel)object5).getStatus() == 2)) {
            if (((FileDownloadModel)object5).getId() != n5) {
                object3.mDatabase.remove(((FileDownloadModel)object5).getId());
                object3.mDatabase.removeConnections(((FileDownloadModel)object5).getId());
                ((FileDownloadModel)object5).setId(n5);
                ((FileDownloadModel)object5).setPath((String)object22, bl);
                if (objectArray != null) {
                    for (Object object22 : objectArray) {
                        ((ConnectionModel)object22).setId(n5);
                        object3.mDatabase.insertConnectionModel((ConnectionModel)object22);
                    }
                }
                bl4 = true;
            } else if (!TextUtils.equals((CharSequence)object, (CharSequence)((FileDownloadModel)object5).getUrl())) {
                ((FileDownloadModel)object5).setUrl((String)object);
                bl4 = true;
            } else {
                bl4 = false;
            }
        } else {
            if (object5 == null) {
                FileDownloadModel fileDownloadModel;
                object5 = fileDownloadModel;
                fileDownloadModel = new FileDownloadModel();
            }
            Object object6 = object5;
            ((FileDownloadModel)object6).setUrl((String)object);
            ((FileDownloadModel)object6).setPath((String)object22, bl);
            ((FileDownloadModel)object6).setId(n5);
            ((FileDownloadModel)object6).setSoFar(0L);
            ((FileDownloadModel)object6).setTotal(0L);
            ((FileDownloadModel)object6).setStatus((byte)1);
            ((FileDownloadModel)object6).setConnectionCount(1);
            bl4 = true;
        }
        if (bl4) {
            object3.mDatabase.update((FileDownloadModel)object5);
        }
        Object[] objectArray9 = object3;
        object3 = new DownloadLaunchRunnable.Builder().setModel((FileDownloadModel)object5).setHeader(fileDownloadHeader).setThreadPoolMonitor((IThreadPoolMonitor)object3).setMinIntervalMillis(n3).setCallbackProgressMaxCount(n2).setForceReDownload(bl2).setWifiRequired(bl3).setMaxRetryTimes(n4).build();
        objectArray9.mThreadPool.execute((DownloadLaunchRunnable)object3);
    }

    public boolean isDownloading(String string2, String string3) {
        return this.isDownloading(FileDownloadUtils.generateId(string2, string3));
    }

    public boolean isDownloading(int n2) {
        FileDownloadManager fileDownloadManager = this;
        return fileDownloadManager.isDownloading(fileDownloadManager.mDatabase.find(n2));
    }

    public boolean pause(int n2) {
        Object object;
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n2;
            FileDownloadLog.d(this, "request pause the task %d", (Object[])object);
        }
        if ((object = this.mDatabase.find(n2)) == null) {
            return false;
        }
        ((FileDownloadModel)object).setStatus((byte)-2);
        this.mThreadPool.cancel(n2);
        return true;
    }

    public void pauseAll() {
        Object object = this.mThreadPool.getAllExactRunningDownloadIds();
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object.size();
            FileDownloadLog.d(this, "pause all tasks %d", objectArray2);
        }
        object = object.iterator();
        while (object.hasNext()) {
            this.pause((Integer)object.next());
        }
    }

    public long getSoFar(int n2) {
        FileDownloadModel fileDownloadModel = ((FileDownloadManager)((Object)list)).mDatabase.find(n2);
        if (fileDownloadModel == null) {
            return 0L;
        }
        int n3 = fileDownloadModel.getConnectionCount();
        if (n3 <= 1) {
            return fileDownloadModel.getSoFar();
        }
        List<ConnectionModel> list = ((FileDownloadManager)((Object)list)).mDatabase.findConnectionModel(n2);
        if (list != null && list.size() == n3) {
            return ConnectionModel.getTotalOffset(list);
        }
        return 0L;
    }

    public long getTotal(int n2) {
        FileDownloadModel fileDownloadModel = ((FileDownloadManager)((Object)fileDownloadModel)).mDatabase.find(n2);
        if (fileDownloadModel == null) {
            return 0L;
        }
        return fileDownloadModel.getTotal();
    }

    public byte getStatus(int n2) {
        FileDownloadModel fileDownloadModel = ((FileDownloadManager)((Object)fileDownloadModel)).mDatabase.find(n2);
        if (fileDownloadModel == null) {
            return 0;
        }
        return fileDownloadModel.getStatus();
    }

    public boolean isIdle() {
        return this.mThreadPool.exactSize() <= 0;
    }

    public synchronized boolean setMaxNetworkThreadCount(int n2) {
        return this.mThreadPool.setMaxNetworkThreadCount(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDownloading(FileDownloadModel fileDownloadModel) {
        if (fileDownloadModel == null) {
            return false;
        }
        boolean bl = objectArray3.mThreadPool.isInThreadPool(fileDownloadModel.getId());
        if (FileDownloadStatus.isOver(fileDownloadModel.getStatus())) {
            if (!bl) return false;
            return true;
        }
        if (bl) {
            return true;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = fileDownloadModel.getId();
        objectArray2[1] = fileDownloadModel.getStatus();
        FileDownloadLog.e((Object)objectArray, "%d status is[%s](not finish) & but not in the pool", objectArray3);
        return false;
    }

    @Override
    public int findRunningTaskIdBySameTempPath(String string2, int n2) {
        return this.mThreadPool.findRunningTaskIdBySameTempPath(string2, n2);
    }

    public boolean clearTaskData(int n2) {
        Object[] objectArray;
        if (n2 == 0) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = n2;
            FileDownloadLog.w(objectArray2, "The task[%d] id is invalid, can't clear it.", objectArray);
            return false;
        }
        if (objectArray.isDownloading(n2)) {
            Object[] objectArray4 = objectArray;
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = n2;
            FileDownloadLog.w(objectArray4, "The task[%d] is downloading, can't clear it.", objectArray);
            return false;
        }
        objectArray.mDatabase.remove(n2);
        objectArray.mDatabase.removeConnections(n2);
        return true;
    }

    public void clearAllTaskData() {
        this.mDatabase.clear();
    }
}

