/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.annotation.SuppressLint;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import com.liulishuo.filedownloader.PauseAllMarker;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.i.IFileDownloadIPCService;
import com.liulishuo.filedownloader.services.FDServiceSeparateHandler;
import com.liulishuo.filedownloader.services.FDServiceSharedHandler;
import com.liulishuo.filedownloader.services.FileDownloadManager;
import com.liulishuo.filedownloader.services.ForegroundServiceConfig;
import com.liulishuo.filedownloader.services.IFileDownloadServiceHandler;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.lang.ref.WeakReference;

@SuppressLint(value={"Registered"})
public class FileDownloadService
extends Service {
    private IFileDownloadServiceHandler handler;
    private PauseAllMarker pauseAllMarker;

    private void inspectRunServiceForeground(Intent object) {
        if (object == null) {
            return;
        }
        if (object.getBooleanExtra("is_foreground", false)) {
            object = CustomComponentHolder.getImpl().getForegroundConfigInstance();
            if (((ForegroundServiceConfig)object).isNeedRecreateChannelId() && Build.VERSION.SDK_INT >= 26) {
                NotificationChannel notificationChannel;
                NotificationChannel notificationChannel2 = notificationChannel;
                Object object2 = object;
                String string2 = ((ForegroundServiceConfig)object2).getNotificationChannelId();
                notificationChannel = new NotificationChannel(string2, (CharSequence)((ForegroundServiceConfig)object2).getNotificationChannelName(), 2);
                string2 = (NotificationManager)objectArray3.getSystemService("notification");
                if (string2 == null) {
                    return;
                }
                string2.createNotificationChannel(notificationChannel2);
            }
            int n2 = ((ForegroundServiceConfig)object).getNotificationId();
            objectArray3.startForeground(n2, ((ForegroundServiceConfig)object).getNotification((Context)objectArray3));
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object;
                FileDownloadLog.d(objectArray, "run service foreground with config: %s", objectArray3);
            }
        }
    }

    public void onCreate() {
        FileDownloadManager fileDownloadManager;
        FileDownloadService fileDownloadService = this;
        super.onCreate();
        FileDownloadHelper.holdContext((Context)fileDownloadService);
        try {
            FileDownloadUtils.setMinProgressStep(FileDownloadProperties.getImpl().downloadMinProgressStep);
            FileDownloadUtils.setMinProgressTime(FileDownloadProperties.getImpl().downloadMinProgressTime);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        FileDownloadManager fileDownloadManager2 = fileDownloadManager;
        fileDownloadManager = new FileDownloadManager();
        if (FileDownloadProperties.getImpl().processNonSeparate) {
            WeakReference<FileDownloadService> weakReference;
            FDServiceSharedHandler fDServiceSharedHandler;
            FDServiceSharedHandler fDServiceSharedHandler2 = fDServiceSharedHandler;
            WeakReference<FileDownloadService> weakReference2 = weakReference;
            weakReference = new WeakReference<FileDownloadService>(this);
            fDServiceSharedHandler = new FDServiceSharedHandler(weakReference2, fileDownloadManager2);
            this.handler = fDServiceSharedHandler2;
        } else {
            WeakReference<FileDownloadService> weakReference;
            FDServiceSeparateHandler fDServiceSeparateHandler;
            FDServiceSeparateHandler fDServiceSeparateHandler2 = fDServiceSeparateHandler;
            WeakReference<FileDownloadService> weakReference3 = weakReference;
            weakReference = new WeakReference<FileDownloadService>(this);
            fDServiceSeparateHandler = new FDServiceSeparateHandler(weakReference3, fileDownloadManager2);
            this.handler = fDServiceSeparateHandler2;
        }
        PauseAllMarker.clearMarker();
        this.pauseAllMarker = new PauseAllMarker((IFileDownloadIPCService)((Object)this.handler));
        this.pauseAllMarker.startPauseAllLooperCheck();
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        this.handler.onStartCommand(intent, n2, n3);
        this.inspectRunServiceForeground(intent);
        return 1;
    }

    public void onDestroy() {
        FileDownloadService fileDownloadService = this;
        fileDownloadService.pauseAllMarker.stopPauseAllLooperCheck();
        fileDownloadService.stopForeground(true);
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return this.handler.onBind(intent);
    }

    public static class SeparateProcessService
    extends FileDownloadService {
    }

    public static class SharedMainProcessService
    extends FileDownloadService {
    }
}

