/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.util.SparseArray;
import com.liulishuo.filedownloader.download.DownloadLaunchRunnable;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

class FileDownloadThreadPool {
    private SparseArray<DownloadLaunchRunnable> runnablePool = new SparseArray();
    private ThreadPoolExecutor mThreadPool;
    private final String threadPrefix;
    private int mMaxThreadCount;
    private int mIgnoreCheckTimes = 0;

    public FileDownloadThreadPool(int n2) {
        this.threadPrefix = "Network";
        this.mThreadPool = FileDownloadExecutors.newDefaultThreadPool(n2, "Network");
        this.mMaxThreadCount = n2;
    }

    private synchronized void filterOutNoExist() {
        SparseArray sparseArray;
        SparseArray sparseArray2 = sparseArray;
        sparseArray = new SparseArray();
        int n2 = this.runnablePool.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FileDownloadThreadPool fileDownloadThreadPool = this;
            int n3 = fileDownloadThreadPool.runnablePool.keyAt(i2);
            DownloadLaunchRunnable downloadLaunchRunnable = (DownloadLaunchRunnable)fileDownloadThreadPool.runnablePool.get(n3);
            if (downloadLaunchRunnable == null || !downloadLaunchRunnable.isAlive()) continue;
            sparseArray2.put(n3, (Object)downloadLaunchRunnable);
        }
        this.runnablePool = sparseArray2;
    }

    public synchronized boolean setMaxNetworkThreadCount(int n2) {
        Object object;
        if (this.exactSize() > 0) {
            FileDownloadLog.w(this, "Can't change the max network thread count, because the  network thread pool isn't in IDLE, please try again after all running tasks are completed or invoking FileDownloader#pauseAll directly.", new Object[0]);
            return false;
        }
        n2 = FileDownloadProperties.getValidNetworkThreadCount(n2);
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[2];
            object = objectArray;
            object[0] = this.mMaxThreadCount;
            objectArray[1] = n2;
            FileDownloadLog.d(this, "change the max network thread count, from %d to %d", (Object[])object);
        }
        object = this.mThreadPool.shutdownNow();
        this.mThreadPool = FileDownloadExecutors.newDefaultThreadPool(n2, "Network");
        if (object.size() > 0) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object.size();
            FileDownloadLog.w(this, "recreate the network thread pool and discard %d tasks", objectArray2);
        }
        this.mMaxThreadCount = n2;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DownloadLaunchRunnable downloadLaunchRunnable) {
        FileDownloadThreadPool fileDownloadThreadPool = this;
        downloadLaunchRunnable.pending();
        synchronized (fileDownloadThreadPool) {
            fileDownloadThreadPool.runnablePool.put(downloadLaunchRunnable.getId(), (Object)downloadLaunchRunnable);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : v82056
            fileDownloadThreadPool.mThreadPool.execute(downloadLaunchRunnable);
            int n2 = fileDownloadThreadPool.mIgnoreCheckTimes;
            if (n2 >= 600) {
                this.filterOutNoExist();
                this.mIgnoreCheckTimes = 0;
            } else {
                this.mIgnoreCheckTimes = n2 + 1;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void cancel(int var1_1) {
        v0 = this;
        v0.filterOutNoExist();
        synchronized (v0) {
            var2_2 = (DownloadLaunchRunnable)v0.runnablePool.get(var1_1);
            if (var2_2 == null) ** GOTO lbl28
            var2_2.pause();
            var2_3 = this.mThreadPool.remove(var2_2);
            if (!FileDownloadLog.NEED_LOG) ** GOTO lbl28
            v2 = this;
            v3 = "successful cancel %d %B";
            v4 = new Object[2];
            var3_4 = v4;
            v5 = var2_3;
            var2_3 = 0;
            var3_4[var2_3] = var1_1;
            var2_3 = 1;
            v4[var2_3] = (boolean)v5;
            FileDownloadLog.d(v2, v3, var3_4);
lbl28:
            // 3 sources

            v6 = this;
            v6.runnablePool.remove(var1_1);
            // ** MonitorExit[v6] (shouldn't be in output)
            return;
        }
    }

    public boolean isInThreadPool(int n2) {
        DownloadLaunchRunnable downloadLaunchRunnable = (DownloadLaunchRunnable)((FileDownloadThreadPool)((Object)downloadLaunchRunnable)).runnablePool.get(n2);
        return downloadLaunchRunnable != null && downloadLaunchRunnable.isAlive();
    }

    public int findRunningTaskIdBySameTempPath(String string2, int n2) {
        if (string2 == null) {
            return 0;
        }
        int n3 = this.runnablePool.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            DownloadLaunchRunnable downloadLaunchRunnable = (DownloadLaunchRunnable)this.runnablePool.valueAt(i2);
            if (downloadLaunchRunnable == null || !downloadLaunchRunnable.isAlive() || downloadLaunchRunnable.getId() == n2 || !string2.equals(downloadLaunchRunnable.getTempFilePath())) continue;
            return downloadLaunchRunnable.getId();
        }
        return 0;
    }

    public synchronized int exactSize() {
        FileDownloadThreadPool fileDownloadThreadPool = this;
        fileDownloadThreadPool.filterOutNoExist();
        return fileDownloadThreadPool.runnablePool.size();
    }

    public synchronized List<Integer> getAllExactRunningDownloadIds() {
        ArrayList<Integer> arrayList;
        this.filterOutNoExist();
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.runnablePool.size(); ++i2) {
            SparseArray<DownloadLaunchRunnable> sparseArray = this.runnablePool;
            arrayList2.add(((DownloadLaunchRunnable)sparseArray.get(sparseArray.keyAt(i2))).getId());
        }
        return arrayList2;
    }
}

