/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FileDownloadExecutors {
    private static final int DEFAULT_IDLE_SECOND = 15;

    public static ThreadPoolExecutor newFixedThreadPool(String string2) {
        FileDownloadThreadFactory fileDownloadThreadFactory;
        SynchronousQueue<Runnable> synchronousQueue;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        FileDownloadThreadFactory fileDownloadThreadFactory2 = fileDownloadThreadFactory;
        fileDownloadThreadFactory = new FileDownloadThreadFactory(string2);
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 15L, timeUnit, synchronousQueue2, fileDownloadThreadFactory2);
    }

    public static ThreadPoolExecutor newDefaultThreadPool(int n2, String string2) {
        return FileDownloadExecutors.newDefaultThreadPool(n2, new LinkedBlockingQueue<Runnable>(), string2);
    }

    public static ThreadPoolExecutor newDefaultThreadPool(int n2, LinkedBlockingQueue<Runnable> linkedBlockingQueue, String string2) {
        FileDownloadThreadFactory fileDownloadThreadFactory;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        FileDownloadThreadFactory fileDownloadThreadFactory2 = fileDownloadThreadFactory;
        fileDownloadThreadFactory = new FileDownloadThreadFactory(string2);
        int n3 = n2;
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n3, n3, 15L, timeUnit, linkedBlockingQueue, fileDownloadThreadFactory2);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    public static class FileDownloadThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final String namePrefix;
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public FileDownloadThreadFactory(String string2) {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = FileDownloadUtils.getThreadPoolName(string2);
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread;
            Thread thread2 = thread;
            if (new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L).isDaemon()) {
                thread2.setDaemon(false);
            }
            if (thread2.getPriority() != 5) {
                thread2.setPriority(5);
            }
            return thread2;
        }
    }
}

