/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.annotation.SuppressLint;
import android.content.Context;
import com.liulishuo.filedownloader.IThreadPoolMonitor;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.exception.PathConflictException;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.message.MessageSnapshotTaker;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import java.io.File;
import java.io.IOException;

public class FileDownloadHelper {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context APP_CONTEXT;

    public static void holdContext(Context context) {
        APP_CONTEXT = context;
    }

    public static Context getAppContext() {
        return APP_CONTEXT;
    }

    public static boolean inspectAndInflowDownloaded(int n2, String string2, boolean bl, boolean bl2) {
        if (bl) {
            return false;
        }
        if (string2 != null) {
            File file;
            File file2 = file;
            if (new File(string2).exists()) {
                MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.catchCanReusedOldFile(n2, file2, bl2));
                return true;
            }
        }
        return false;
    }

    public static boolean inspectAndInflowDownloading(int n2, FileDownloadModel fileDownloadModel, IThreadPoolMonitor iThreadPoolMonitor, boolean bl) {
        if (iThreadPoolMonitor.isDownloading(fileDownloadModel)) {
            FileDownloadModel fileDownloadModel2 = fileDownloadModel;
            long l2 = fileDownloadModel2.getSoFar();
            long l3 = fileDownloadModel2.getTotal();
            MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.catchWarn(n2, l2, l3, bl));
            return true;
        }
        return false;
    }

    public static boolean inspectAndInflowConflictPath(int n2, long l2, String string2, String string3, IThreadPoolMonitor iThreadPoolMonitor) {
        int n3;
        if (string3 != null && string2 != null && (n3 = iThreadPoolMonitor.findRunningTaskIdBySameTempPath(string2, n2)) != 0) {
            PathConflictException pathConflictException;
            PathConflictException pathConflictException2 = pathConflictException;
            pathConflictException = new PathConflictException(n3, string2, string3);
            MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.catchException(n2, l2, pathConflictException2));
            return true;
        }
        return false;
    }

    public static interface ConnectionCreator {
        public FileDownloadConnection create(String var1) throws IOException;
    }

    public static interface OutputStreamCreator {
        public FileDownloadOutputStream create(File var1) throws IOException;

        public boolean supportSeek();
    }

    public static interface DatabaseCustomMaker {
        public FileDownloadDatabase customMake();
    }

    public static interface ConnectionCountAdapter {
        public int determineConnectionCount(int var1, String var2, String var3, long var4);
    }

    public static interface IdGenerator {
        public int transOldId(int var1, String var2, String var3, boolean var4);

        public int generateId(String var1, String var2, boolean var3);
    }
}

