/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.app.ActivityManager;
import android.content.Context;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.Process;
import android.os.StatFs;
import android.text.TextUtils;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadSecurityException;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileDownloadUtils {
    private static int minProgressStep = 65536;
    private static long minProgressTime = 2000L;
    private static String defaultSaveRootPath;
    private static Boolean isDownloaderProcess;
    private static final String INTERNAL_DOCUMENT_NAME = "filedownloader";
    private static final String OLD_FILE_CONVERTED_FILE_NAME = ".old_file_converted";
    private static Boolean filenameConverted;
    private static final Pattern CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN;
    private static final Pattern CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN;
    private static final String FILEDOWNLOADER_PREFIX = "FileDownloader";

    public static void setMinProgressStep(int n2) throws IllegalAccessException {
        if (FileDownloadUtils.isDownloaderProcess(FileDownloadHelper.getAppContext())) {
            minProgressStep = n2;
            return;
        }
        throw new IllegalAccessException("This value is used in the :filedownloader process, so set this value in your process is without effect. You can add 'process.non-separate=true' in 'filedownloader.properties' to share the main process to FileDownloadService. Or you can configure this value in 'filedownloader.properties' by 'download.min-progress-step'.");
    }

    public static void setMinProgressTime(long l2) throws IllegalAccessException {
        if (FileDownloadUtils.isDownloaderProcess(FileDownloadHelper.getAppContext())) {
            minProgressTime = l2;
            return;
        }
        throw new IllegalAccessException("This value is used in the :filedownloader process, so set this value in your process is without effect. You can add 'process.non-separate=true' in 'filedownloader.properties' to share the main process to FileDownloadService. Or you can configure this value in 'filedownloader.properties' by 'download.min-progress-time'.");
    }

    public static int getMinProgressStep() {
        return minProgressStep;
    }

    public static long getMinProgressTime() {
        return minProgressTime;
    }

    public static boolean isFilenameValid(String string2) {
        return true;
    }

    public static String getDefaultSaveRootPath() {
        if (!TextUtils.isEmpty((CharSequence)defaultSaveRootPath)) {
            return defaultSaveRootPath;
        }
        if (FileDownloadHelper.getAppContext().getExternalCacheDir() == null) {
            return Environment.getDownloadCacheDirectory().getAbsolutePath();
        }
        return FileDownloadHelper.getAppContext().getExternalCacheDir().getAbsolutePath();
    }

    public static String getDefaultSaveFilePath(String string2) {
        return FileDownloadUtils.generateFilePath(FileDownloadUtils.getDefaultSaveRootPath(), FileDownloadUtils.generateFileName(string2));
    }

    public static String generateFileName(String string2) {
        return FileDownloadUtils.md5(string2);
    }

    public static String generateFilePath(String string2, String string3) {
        if (string3 != null) {
            if (string2 != null) {
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string2;
                objectArray[1] = File.separator;
                objectArray[2] = string3;
                return FileDownloadUtils.formatString("%s%s%s", objectArray2);
            }
            throw new IllegalStateException("can't generate real path, the directory is null");
        }
        throw new IllegalStateException("can't generate real path, the file name is null");
    }

    public static void setDefaultSaveRootPath(String string2) {
        defaultSaveRootPath = string2;
    }

    public static String getTempPath(String string2) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        return FileDownloadUtils.formatString("%s.temp", objectArray2);
    }

    public static int generateId(String string2, String string3) {
        return CustomComponentHolder.getImpl().getIdGeneratorInstance().generateId(string2, string3, false);
    }

    public static int generateId(String string2, String string3, boolean bl) {
        return CustomComponentHolder.getImpl().getIdGeneratorInstance().generateId(string2, string3, bl);
    }

    public static String md5(String object) {
        StringBuilder stringBuilder;
        byte[] byArray;
        try {
            byArray = MessageDigest.getInstance("MD5").digest(((String)object).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Huh, UTF-8 should be supported?", unsupportedEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Huh, MD5 should be supported?", noSuchAlgorithmException);
        }
        object = byArray;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(((Object)object).length * 2);
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = object[i2] & 0xFF;
            if (n3 < 16) {
                stringBuilder2.append("0");
            }
            stringBuilder2.append(Integer.toHexString(n3));
        }
        return stringBuilder2.toString();
    }

    public static String getStack() {
        return FileDownloadUtils.getStack(true);
    }

    public static String getStack(boolean bl) {
        return FileDownloadUtils.getStack(new Throwable().getStackTrace(), bl);
    }

    public static String getStack(StackTraceElement[] stackTraceElementArray, boolean bl) {
        if (stackTraceElementArray != null && stackTraceElementArray.length >= 4) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            for (int i2 = 3; i2 < stackTraceElementArray.length; ++i2) {
                if (!stackTraceElementArray[i2].getClassName().contains("com.liulishuo.filedownloader")) continue;
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder2.append("[");
                stringBuilder3.append(stackTraceElementArray[i2].getClassName().substring(28));
                stringBuilder3.append(":");
                stringBuilder2.append(stackTraceElementArray[i2].getMethodName());
                if (bl) {
                    stringBuilder2.append("(").append(stackTraceElementArray[i2].getLineNumber()).append(")]");
                    continue;
                }
                stringBuilder2.append("]");
            }
            return stringBuilder2.toString();
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isDownloaderProcess(Context var0) {
        block6: {
            block5: {
                block4: {
                    var1_4 = FileDownloadUtils.isDownloaderProcess;
                    if (var1_4 != null) {
                        return var1_4;
                    }
                    var1_5 = false;
                    if (!FileDownloadProperties.getImpl().processNonSeparate) break block4;
                    var1_5 = true;
                    break block5;
                }
                var0_1 = Process.myPid();
                var2_6 = (ActivityManager)var0.getSystemService("activity");
                if (var2_6 == null) {
                    var0_2 = new Object[]{};
                    FileDownloadLog.w(FileDownloadUtils.class, "fail to get the activity manager!", var0_2);
                    return false;
                }
                if ((var2_6 = var2_6.getRunningAppProcesses()) != null && !var2_6.isEmpty()) {
                    var2_6 = var2_6.iterator();
                    while (var2_6.hasNext()) {
                        var3_7 = (ActivityManager.RunningAppProcessInfo)var2_6.next();
                        if (var3_7.pid != var0_1) continue;
                        var1_5 = var3_7.processName.endsWith(":filedownloader");
                        ** break;
                    }
                }
                break block6;
            }
            FileDownloadUtils.isDownloaderProcess = var1_5;
            return FileDownloadUtils.isDownloaderProcess;
        }
        var0_3 = new Object[]{};
        FileDownloadLog.w(FileDownloadUtils.class, "The running app process info list from ActivityManager is null or empty, maybe current App is not running.", var0_3);
        return false;
    }

    public static String[] convertHeaderString(String stringArray) {
        stringArray = stringArray.split("\n");
        String[] stringArray2 = new String[stringArray.length * 2];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray3 = stringArray[i2].split(": ");
            int n2 = i2 * 2;
            stringArray2[n2] = stringArray3[0];
            stringArray2[++n2] = stringArray3[1];
        }
        return stringArray2;
    }

    public static long getFreeSpaceBytes(String string2) {
        StatFs statFs;
        StatFs statFs2 = statFs;
        statFs = new StatFs(string2);
        return Build.VERSION.SDK_INT >= 18 ? statFs2.getAvailableBytes() : (long)statFs2.getAvailableBlocks() * (long)statFs2.getBlockSize();
    }

    public static String formatString(String string2, Object ... objectArray) {
        return String.format(Locale.ENGLISH, string2, objectArray);
    }

    public static void markConverted(Context context) {
        File file = FileDownloadUtils.getConvertedMarkedFile(context);
        File file2 = file;
        file.getParentFile().mkdirs();
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isFilenameConverted(Context context) {
        if (filenameConverted == null) {
            filenameConverted = FileDownloadUtils.getConvertedMarkedFile(context).exists();
        }
        return filenameConverted;
    }

    public static File getConvertedMarkedFile(Context context) {
        return new File(context.getFilesDir().getAbsolutePath() + File.separator + INTERNAL_DOCUMENT_NAME, OLD_FILE_CONVERTED_FILE_NAME);
    }

    public static long parseContentRangeFoInstanceLength(String string2) {
        if (string2 == null) {
            return -1L;
        }
        Object[] objectArray = string2.split("/");
        if (objectArray.length >= 2) {
            try {
                return Long.parseLong(objectArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = string2;
                FileDownloadLog.w(FileDownloadUtils.class, "parse instance length failed with %s", objectArray);
            }
        }
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parseContentDisposition(String object) {
        if (object == null) {
            return null;
        }
        try {
            Matcher matcher = CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN.matcher((CharSequence)object);
            if (matcher.find()) {
                Matcher matcher2 = matcher;
                object = matcher2.group(1);
                return URLDecoder.decode(matcher2.group(2), (String)object);
            }
            object = CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN.matcher((CharSequence)object);
            if (!((Matcher)object).find()) return null;
            return ((Matcher)object).group(1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        catch (IllegalStateException illegalStateException) {}
        return null;
    }

    public static String getTargetFilePath(String string2, boolean bl, String string3) {
        if (string2 == null) {
            return null;
        }
        if (bl) {
            if (string3 == null) {
                return null;
            }
            return FileDownloadUtils.generateFilePath(string2, string3);
        }
        return string2;
    }

    public static String getParent(String string2) {
        int n2;
        int n3 = string2.length();
        int n4 = 0;
        if (File.separatorChar == '\\' && n3 > 2 && string2.charAt(1) == ':') {
            n4 = 2;
        }
        if ((n2 = string2.lastIndexOf(File.separatorChar)) == -1 && n4 > 0) {
            n2 = 2;
        }
        if (n2 != -1) {
            char c2 = string2.charAt(n3 - 1);
            char c3 = File.separatorChar;
            n3 = c3;
            if (c2 != c3) {
                if (string2.indexOf(n3) == n2 && string2.charAt(n4) == File.separatorChar) {
                    return string2.substring(0, n2 + 1);
                }
                return string2.substring(0, n2);
            }
        }
        return null;
    }

    public static String getThreadPoolName(String string2) {
        return "FileDownloader-" + string2;
    }

    public static boolean isNetworkNotOnWifiType() {
        NetworkInfo networkInfo = (NetworkInfo)FileDownloadHelper.getAppContext().getSystemService("connectivity");
        if (networkInfo == null) {
            networkInfo = new NetworkInfo[]{};
            FileDownloadLog.w(FileDownloadUtils.class, "failed to get connectivity manager!", (Object[])networkInfo);
            return true;
        }
        return (networkInfo = networkInfo.getActiveNetworkInfo()) == null || networkInfo.getType() != 1;
    }

    public static boolean checkPermission(String string2) {
        return FileDownloadHelper.getAppContext().checkCallingOrSelfPermission(string2) == 0;
    }

    public static long convertContentLengthString(String string2) {
        if (string2 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static String findEtag(int n2, FileDownloadConnection object) {
        if (object != null) {
            object = object.getResponseHeaderField("Etag");
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = object;
                objectArray[1] = n2;
                FileDownloadLog.d(FileDownloadUtils.class, "etag find %s for task(%d)", objectArray2);
            }
            return object;
        }
        throw new RuntimeException("connection is null when findEtag");
    }

    public static boolean isAcceptRange(int n2, FileDownloadConnection fileDownloadConnection) {
        if (n2 != 206 && n2 != 1) {
            return "bytes".equals(fileDownloadConnection.getResponseHeaderField("Accept-Ranges"));
        }
        return true;
    }

    public static long findInstanceLengthForTrial(FileDownloadConnection objectArray) {
        long l2 = FileDownloadUtils.findInstanceLengthFromContentRange((FileDownloadConnection)objectArray);
        if (l2 < 0L) {
            l2 = -1L;
            objectArray = new Object[]{};
            FileDownloadLog.w(FileDownloadUtils.class, "don't get instance length fromContent-Range header", objectArray);
        }
        if (l2 == 0L && FileDownloadProperties.getImpl().trialConnectionHeadMethod) {
            l2 = -1L;
        }
        return l2;
    }

    public static long findInstanceLengthFromContentRange(FileDownloadConnection fileDownloadConnection) {
        return FileDownloadUtils.parseContentRangeFoInstanceLength(FileDownloadUtils.getContentRangeHeader(fileDownloadConnection));
    }

    private static String getContentRangeHeader(FileDownloadConnection fileDownloadConnection) {
        return fileDownloadConnection.getResponseHeaderField("Content-Range");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long findContentLength(int n2, FileDownloadConnection object) {
        long l2 = FileDownloadUtils.convertContentLengthString(object.getResponseHeaderField("Content-Length"));
        object = object.getResponseHeaderField("Transfer-Encoding");
        if (l2 >= 0L) return l2;
        if (object != null && ((String)object).equals("chunked")) {
            return -1L;
        }
        boolean bl = false;
        if (bl) return -1L;
        if (!FileDownloadProperties.getImpl().httpLenient) throw new FileDownloadGiveUpRetryException("can't know the size of the download file, and its Transfer-Encoding is not Chunked either.\nyou can ignore such exception by add http.lenient=true to the filedownloader.properties");
        l2 = -1L;
        if (!FileDownloadLog.NEED_LOG) return l2;
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = n2;
        FileDownloadLog.d(FileDownloadUtils.class, "%d response header is not legal but HTTP lenient is true, so handle as the case of transfer encoding chunk", (Object[])object);
        return l2;
    }

    public static long findContentLengthFromContentRange(FileDownloadConnection fileDownloadConnection) {
        long l2 = FileDownloadUtils.parseContentLengthFromContentRange(FileDownloadUtils.getContentRangeHeader(fileDownloadConnection));
        if (l2 < 0L) {
            l2 = -1L;
        }
        return l2;
    }

    public static long parseContentLengthFromContentRange(String object) {
        if (object != null && ((String)object).length() != 0) {
            block6: {
                object = Pattern.compile("bytes (\\d+)-(\\d+)/\\d+").matcher((CharSequence)object);
                if (!((Matcher)object).find()) break block6;
                Object object2 = object;
                Object object3 = object2;
                long l2 = Long.parseLong(((Matcher)object2).group(1));
                try {
                    return Long.parseLong(((Matcher)object3).group(2)) - l2 + 1L;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{};
                    FileDownloadLog.e(FileDownloadUtils.class, exception, "parse content length from content range error", objectArray);
                }
            }
            return -1L;
        }
        return -1L;
    }

    public static String findFilename(FileDownloadConnection object, String objectArray) throws FileDownloadSecurityException {
        block4: {
            block3: {
                block2: {
                    if (!TextUtils.isEmpty((CharSequence)(object = FileDownloadUtils.parseContentDisposition(object.getResponseHeaderField("Content-Disposition"))))) break block2;
                    object = FileDownloadUtils.generateFileName((String)objectArray);
                    break block3;
                }
                if (((String)object).contains("../")) break block4;
            }
            return object;
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = object;
        throw new FileDownloadSecurityException(FileDownloadUtils.formatString("The filename [%s] from the response is not allowable, because it contains '../', which can raise the directory traversal vulnerability", objectArray));
    }

    public static FileDownloadOutputStream createOutputStream(String objectArray) throws IOException {
        if (!TextUtils.isEmpty((CharSequence)objectArray)) {
            if (FileDownloadUtils.isFilenameValid((String)objectArray)) {
                File file;
                File file2 = file;
                if (new File((String)objectArray).exists() && file2.isDirectory()) {
                    Object[] objectArray2 = new Object[2];
                    Object[] objectArray3 = objectArray2;
                    objectArray3[0] = objectArray;
                    objectArray2[1] = file2.isDirectory();
                    throw new RuntimeException(FileDownloadUtils.formatString("found invalid internal destination path[%s], & path is directory[%B]", objectArray3));
                }
                if (!file2.exists() && !file2.createNewFile()) {
                    Object[] objectArray4 = new Object[1];
                    objectArray = objectArray4;
                    objectArray4[0] = file2.getAbsolutePath();
                    throw new IOException(FileDownloadUtils.formatString("create new file error  %s", objectArray));
                }
                return CustomComponentHolder.getImpl().createOutputStream(file2);
            }
            Object[] objectArray5 = new Object[1];
            Object[] objectArray6 = objectArray5;
            objectArray5[0] = objectArray;
            throw new RuntimeException(FileDownloadUtils.formatString("found invalid internal destination filename %s", objectArray6));
        }
        throw new RuntimeException("found invalid internal destination path, empty");
    }

    public static boolean isBreakpointAvailable(int n2, FileDownloadModel fileDownloadModel) {
        return FileDownloadUtils.isBreakpointAvailable(n2, fileDownloadModel, null);
    }

    public static boolean isBreakpointAvailable(int n2, FileDownloadModel objectArray, Boolean bl) {
        if (objectArray == null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = n2;
                FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d model == null", objectArray);
            }
            return false;
        }
        if (objectArray.getTempFilePath() == null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = n2;
                FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d temp path == null", objectArray);
            }
            return false;
        }
        return FileDownloadUtils.isBreakpointAvailable(n2, (FileDownloadModel)objectArray, objectArray.getTempFilePath(), bl);
    }

    public static boolean isBreakpointAvailable(int n2, FileDownloadModel objectArray, String string2, Boolean objectArray2) {
        boolean bl = false;
        if (string2 == null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = n2;
                FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d path = null", objectArray);
            }
        } else {
            File file;
            File file2 = file;
            boolean bl2 = new File(string2).exists();
            boolean bl3 = file2.isDirectory();
            if (bl2 && !bl3) {
                long l2 = file2.length();
                long l3 = objectArray.getSoFar();
                if (objectArray.getConnectionCount() <= 1 && l3 == 0L) {
                    if (FileDownloadLog.NEED_LOG) {
                        Object[] objectArray4 = new Object[1];
                        objectArray = objectArray4;
                        objectArray4[0] = n2;
                        FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d the downloaded-record is zero.", objectArray);
                    }
                } else {
                    long l4 = objectArray.getTotal();
                    if (l2 >= l3 && (l4 == -1L || l2 <= l4 && l3 < l4)) {
                        if (objectArray2 != null && !objectArray2.booleanValue() && l4 == l2) {
                            if (FileDownloadLog.NEED_LOG) {
                                Object[] objectArray5 = new Object[1];
                                Object[] objectArray6 = objectArray5;
                                objectArray5[0] = n2;
                                FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d, because of the output stream doesn't support seek, but the task has already pre-allocated, so we only can download it from the very beginning.", objectArray6);
                            }
                        } else {
                            bl = true;
                        }
                    } else if (FileDownloadLog.NEED_LOG) {
                        Object[] objectArray7 = new Object[4];
                        objectArray2 = objectArray7;
                        objectArray2[0] = n2;
                        objectArray2[1] = l2;
                        objectArray2[2] = l3;
                        objectArray7[3] = l4;
                        FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d dirty data fileLength[%d] sofar[%d] total[%d]", objectArray2);
                    }
                }
            } else if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray8 = new Object[3];
                objectArray = objectArray8;
                objectArray[0] = n2;
                objectArray[1] = bl2;
                objectArray8[2] = bl3;
                FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d file not suit, exists[%B], directory[%B]", objectArray);
            }
        }
        return bl;
    }

    public static void deleteTaskFiles(String string2, String string3) {
        FileDownloadUtils.deleteTempFile(string3);
        FileDownloadUtils.deleteTargetFile(string2);
    }

    public static void deleteTempFile(String string2) {
        if (string2 != null) {
            File file;
            File file2 = file;
            if (new File(string2).exists()) {
                file2.delete();
            }
        }
    }

    public static void deleteTargetFile(String string2) {
        if (string2 != null) {
            File file;
            File file2 = file;
            if (new File(string2).exists()) {
                file2.delete();
            }
        }
    }

    public static boolean isNeedSync(long l2, long l3) {
        return l2 > (long)FileDownloadUtils.getMinProgressStep() && l3 > FileDownloadUtils.getMinProgressTime();
    }

    public static String defaultUserAgent() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "1.7.6";
        return FileDownloadUtils.formatString("FileDownloader/%s", objectArray2);
    }

    private static boolean isAppOnForeground(Context object) {
        Object object2 = (ActivityManager)object.getApplicationContext().getSystemService("activity");
        if (object2 == null) {
            return false;
        }
        if ((object2 = object2.getRunningAppProcesses()) == null) {
            return false;
        }
        PowerManager powerManager = (PowerManager)object.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT > 19 ? !powerManager.isInteractive() : !powerManager.isScreenOn()) {
            return false;
        }
        object = object.getApplicationContext().getPackageName();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            powerManager = (ActivityManager.RunningAppProcessInfo)object2.next();
            if (!powerManager.processName.equals(object) || powerManager.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static boolean needMakeServiceForeground(Context context) {
        return Build.VERSION.SDK_INT >= 26 && !FileDownloadUtils.isAppOnForeground(context);
    }

    static {
        CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN = Pattern.compile("attachment;\\s*filename\\*\\s*=\\s*\"*([^\"]*)'\\S*'([^\"]*)\"*");
        CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*\"*([^\"\\n]*)\"*");
    }
}

