/*
 * Decompiled with CFR 0.152.
 */
package com.smwl.smsdk.copyCode;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import java.util.ArrayList;

public class UIUtils {
    private static UIUtils instance;
    private static Handler mMainThreadHandler;
    private static long mMainThreadId;
    private static Context mContext;
    private Context context;
    private ArrayList<Activity> activityList;
    private Application.ActivityLifecycleCallbacks activityHelper;

    public UIUtils() {
        Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        this.activityList = object;
        object = activityLifecycleCallbacks;
        activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
                try {
                    UIUtils.this.activityList.add(activity);
                }
                catch (Exception exception) {}
            }

            public void onActivityStarted(@NonNull Activity activity) {
            }

            public void onActivityResumed(@NonNull Activity activity) {
            }

            public void onActivityPaused(@NonNull Activity activity) {
            }

            public void onActivityStopped(@NonNull Activity activity) {
            }

            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
            }

            public void onActivityDestroyed(@NonNull Activity activity) {
                try {
                    UIUtils.this.activityList.remove(activity);
                }
                catch (Exception exception) {}
            }
        };
        this.activityHelper = object;
    }

    public static synchronized UIUtils getInstance() {
        if (instance == null) {
            instance = new UIUtils();
        }
        return instance;
    }

    public static int dip2px(float f2) {
        DisplayMetrics displayMetrics = UIUtils.getContext().getResources().getDisplayMetrics();
        int n2 = displayMetrics.heightPixels;
        int n3 = displayMetrics.widthPixels;
        float f3 = displayMetrics.density;
        float f4 = (float)n2 / f3;
        return (int)(f2 * Math.min((float)n3 / f3, f4) / 360.0f * f3 + 0.5f);
    }

    public static Handler getMainThreadHandler() {
        return mMainThreadHandler;
    }

    public static long getMainThreadId() {
        return mMainThreadId;
    }

    public static void runOnUiThread(Runnable runnable) {
        if ((long)Process.myTid() == UIUtils.getMainThreadId()) {
            runnable.run();
        } else {
            UIUtils.getMainThreadHandler().post(runnable);
        }
    }

    public static void postDelayed(Runnable runnable, long l2) {
        UIUtils.getMainThreadHandler().postDelayed(runnable, l2);
    }

    public static Context getContext() {
        return mContext;
    }

    public static String getString(int n2) {
        return UIUtils.getContext().getResources().getString(n2);
    }

    public void init(Application application) {
        mContext = application;
        mMainThreadId = Process.myTid();
        if (mMainThreadHandler == null) {
            mMainThreadHandler = new Handler(Looper.getMainLooper());
        }
    }

    public void registerActivityLifecycleCallbacks(Application application) {
        application.registerActivityLifecycleCallbacks(this.activityHelper);
    }

    public ArrayList<Activity> getActivityList() {
        return this.activityList;
    }
}

