/*
 * Decompiled with CFR 0.152.
 */
package com.smwl.smsdk.copyCode;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public final class X7LogUtils {
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_VERBOSE = 1;
    public static final int LEVEL_DEBUG = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_WARN = 4;
    public static final int LEVEL_ERROR = 5;
    private static String mTag = "hao";
    private static int mDebuggable = 0;
    private static long mTimestamp = 6L;
    private static final Object mLogLock = new Object();
    public static final String X7_ACCESS_TAG = "[x7_log]";
    public static ErrorCallback errorCallback;

    public static void setLogInputRank(int n2) {
        mDebuggable = n2;
    }

    public static void dLong(String string2) {
        if (mDebuggable >= 2) {
            int n2 = 2001 - mTag.length();
            while (string2.length() > n2) {
                Log.d((String)mTag, (String)string2.substring(0, n2));
                Log.e((String)mTag, (String)"--------------------------------------");
                string2 = string2.substring(n2);
            }
            Log.d((String)mTag, (String)string2);
        }
    }

    public static void iLong(String string2) {
        int n2 = 2001 - mTag.length();
        while (string2.length() > n2) {
            Log.i((String)mTag, (String)string2.substring(0, n2));
            Log.e((String)mTag, (String)"--------------------------------------");
            string2 = string2.substring(n2);
        }
        Log.i((String)mTag, (String)string2);
    }

    public static void v(String string2) {
        if (mDebuggable >= 1) {
            Log.v((String)mTag, (String)string2);
        }
    }

    public static void d(String string2) {
        if (mDebuggable >= 2) {
            Log.d((String)mTag, (String)string2);
        }
    }

    public static void i(String string2) {
        if (mDebuggable >= 3) {
            Log.i((String)mTag, (String)string2);
        }
    }

    public static void w(String string2) {
        Log.e((String)mTag, (String)string2);
    }

    public static void w(Throwable throwable) {
        if (mDebuggable >= 4) {
            Log.w((String)mTag, (String)"", (Throwable)throwable);
        }
    }

    public static void w(String string2, Throwable throwable) {
        if (mDebuggable >= 4 && string2 != null) {
            Log.w((String)mTag, (String)string2, (Throwable)throwable);
        }
    }

    public static void e(String string2) {
        Log.e((String)mTag, (String)string2);
        ErrorCallback errorCallback = X7LogUtils.errorCallback;
        if (errorCallback != null) {
            errorCallback.uploadError(null, string2);
        }
    }

    public static void e(Throwable throwable) {
        X7LogUtils.e("", throwable);
    }

    public static String getErrorTrace(Throwable object) {
        StringWriter stringWriter;
        Throwable throwable = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)object));
        return ((StringWriter)object).getBuffer().toString();
    }

    public static void e(String object, Throwable throwable) {
        block4: {
            Log.e((String)mTag, (String)"e: ", (Throwable)throwable);
            object = errorCallback;
            if (object == null) break block4;
            try {
                object.uploadError(throwable, "");
            }
            catch (Exception exception) {
                System.out.print(exception.toString());
            }
        }
    }

    public static void log2File(String string2, String string3) {
        X7LogUtils.log2File(string2, string3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log2File(String object, String string2, boolean bl) {
        object = mLogLock;
        synchronized (object) {
            return;
        }
    }

    public static void elapsed(String string2) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - mTimestamp;
        mTimestamp = l2;
        X7LogUtils.e("[Elapsed\ufffd?" + l3 + "]" + string2);
    }

    public static <T> void printList(List<T> list) {
        if (list != null && list.size() >= 1) {
            int n2 = list.size();
            X7LogUtils.i("---begin---");
            for (int i2 = 0; i2 < n2; ++i2) {
                X7LogUtils.i(i2 + ":" + list.get(i2).toString());
            }
            X7LogUtils.i("---end---");
            return;
        }
    }

    public static <T> void printArray(T[] TArray) {
        if (TArray != null && TArray.length >= 1) {
            int n2 = TArray.length;
            X7LogUtils.i("---begin---");
            for (int i2 = 0; i2 < n2; ++i2) {
                X7LogUtils.i(i2 + ":" + TArray[i2].toString());
            }
            X7LogUtils.i("---end---");
            return;
        }
    }

    public static int getDebuggableValue() {
        return mDebuggable;
    }

    public static void setErrorCallBack(ErrorCallback errorCallback) {
        X7LogUtils.errorCallback = errorCallback;
    }

    public static interface ErrorCallback {
        public void uploadError(Throwable var1, String var2);
    }
}

