/*
 * Decompiled with CFR 0.152.
 */
package com.smwl.smsdk.plugin;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.util.Log;
import com.smwl.smsdk.copyCode.X7LogUtils;
import com.smwl.smsdk.plugin.Speedup;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipFile;

@Keep
public class SpeedupCallHelper {
    public static final String IS_SHOW_SPEED_BALL = "is_show_speed_ball";
    public static final String IS_INIT_SPEED_BALL = "is_init_speed_ball";
    public static final String IS_LIBC_MODE = "is_libc_mode";
    public static final String SP_ACC_CONFIG_DEBUG = "x7_acc_config_debug";
    public static final String SP_LIBC_MODE = "sp_libc_mode";
    public static SpeedupCallHelper sInstance;
    private Context mApplication;
    private boolean isOldVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SpeedupCallHelper getInstance() {
        Class<SpeedupCallHelper> clazz = SpeedupCallHelper.class;
        synchronized (SpeedupCallHelper.class) {
            if (sInstance == null) {
                sInstance = new SpeedupCallHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private boolean isExist(Context context, String ... stringArray) {
        block20: {
            block19: {
                boolean bl;
                block18: {
                    block17: {
                        block16: {
                            String string2;
                            SpeedupCallHelper speedupCallHelper;
                            try {
                                speedupCallHelper = string7;
                                string2 = "/armeabi/";
                            }
                            catch (Exception exception) {
                                return false;
                            }
                            boolean bl2 = speedupCallHelper.singleLibJudge(context, stringArray, string2);
                            if (!bl2) break block16;
                            return bl2;
                        }
                        SpeedupCallHelper speedupCallHelper = string7;
                        String string3 = "/armeabi-v7a/";
                        boolean bl3 = speedupCallHelper.singleLibJudge(context, stringArray, string3);
                        if (!bl3) break block17;
                        return bl3;
                    }
                    SpeedupCallHelper speedupCallHelper = string7;
                    String string4 = "/arm64-v8a/";
                    bl = speedupCallHelper.singleLibJudge(context, stringArray, string4);
                    if (bl) break block18;
                    Log.d((String)"\u52a0\u901f\u7403so\u6587\u4ef6", (String)"\u6ca1\u6709\u53ef\u4f9b\u624b\u673a\u8fd0\u884c\u7684 SpeedUp \u63d2\u4ef6");
                }
                if (bl) {
                    return bl;
                }
                SpeedupCallHelper speedupCallHelper = string7;
                String string5 = "/mips/";
                boolean bl4 = speedupCallHelper.singleLibJudge(context, stringArray, string5);
                if (!bl4) break block19;
                return bl4;
            }
            SpeedupCallHelper speedupCallHelper = string7;
            String string6 = "/x86/";
            boolean bl = speedupCallHelper.singleLibJudge(context, stringArray, string6);
            if (!bl) break block20;
            return bl;
        }
        SpeedupCallHelper speedupCallHelper = string7;
        String string7 = "/x86_64/";
        boolean bl = speedupCallHelper.singleLibJudge(context, stringArray, string7);
        if (bl) {
            return bl;
        }
        return false;
    }

    private boolean singleLibJudge(Context context, @NonNull String[] stringArray, String string2) {
        int n2;
        ZipFile zipFile;
        String[] stringArray2 = stringArray;
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        ZipFile zipFile2 = zipFile;
        try {
            zipFile = new ZipFile(applicationInfo.sourceDir);
            n2 = stringArray2.length;
        }
        catch (IOException iOException) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            File file;
            String string3;
            block11: {
                SpeedupCallHelper speedupCallHelper = this;
                string3 = stringArray[i2];
                if (!speedupCallHelper.isOldVersion) break block11;
                if (zipFile2.getEntry("lib" + string2 + string3) != null) continue;
                return false;
            }
            File file2 = context.getDir("libs", 0);
            File file3 = file;
            File file4 = file;
            file3(file2.getAbsolutePath() + string2 + string3);
            if (file4.exists()) continue;
            return false;
        }
        return true;
    }

    public void setIsOldVersion(boolean bl) {
        this.isOldVersion = bl;
    }

    public void syncApplication(Context context) {
        this.mApplication = context;
    }

    @Keep
    public void syncSpeedStatusToLocal(String string2, boolean bl) {
        this.mApplication.getSharedPreferences("config", 0).edit().putBoolean(string2, bl).apply();
    }

    @Keep
    public void syncSpeedIntStatusToLocal(String string2, int n2) {
        try {
            this.mApplication.getSharedPreferences("config", 0).edit().putInt(string2, n2).apply();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            X7LogUtils.e(X7LogUtils.getErrorTrace(exception));
        }
    }

    @Keep
    public boolean getSpeedStatus(String string2) {
        return this.mApplication.getSharedPreferences("config", 0).getBoolean(string2, false);
    }

    public SharedPreferences getSharedPreferences() {
        return this.mApplication.getSharedPreferences("config", 0);
    }

    @Keep
    public void speedUp(float f2) {
        Speedup.speedup(this.mApplication, f2);
    }

    @Keep
    public boolean isExistSpeedupSo() {
        if (this.is64Bit().booleanValue()) {
            SpeedupCallHelper speedupCallHelper = this;
            return speedupCallHelper.isExist(speedupCallHelper.mApplication, "libspeedup_plugin.so");
        }
        SpeedupCallHelper speedupCallHelper = this;
        return speedupCallHelper.isExist(speedupCallHelper.mApplication, "libspeedup_plugin.so", "libsubstrate.so");
    }

    public Boolean is64Bit() {
        return Build.CPU_ABI.contains("64");
    }

    public boolean isExistSpeedupConf(Context context) {
        try {
            if (new File(context.getFilesDir().getAbsolutePath(), "/sp.conf").exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public Properties getProperties(String string2) {
        Properties properties = new Properties();
        try {
            properties.load(this.mApplication.getAssets().open(string2));
            return properties;
        }
        catch (Exception exception) {
            Log.d((String)"hao", (String)X7LogUtils.getErrorTrace(exception));
            return null;
        }
    }

    public String isPad() {
        if ((this.mApplication.getResources().getConfiguration().screenLayout & 0xF) >= 3) {
            return "pad";
        }
        return "phone";
    }
}

