/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.manager.installplugin;

import com.tencent.shadow.core.common.Logger;
import com.tencent.shadow.core.common.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MinFileUtils {
    private static final Logger mLogger = LoggerFactory.getLogger(MinFileUtils.class);

    public static void ensureParentDirExists(File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.isDirectory() && !file2.mkdirs()) {
            throw new IOException("\u9352\u6d98\u7f13\u9416\u5241\u6d30\u8930\u66de\u3051\u7490\ufffd,\u93c2\u56e6\u6b22\u9429\ue1bc\u7d8d:" + file.getAbsolutePath() + " parent dir exists=" + file2.exists());
        }
    }

    public static void cleanDirectory(File fileArray) throws IOException {
        fileArray = MinFileUtils.verifiedListFiles((File)fileArray);
        Object var1_1 = null;
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                MinFileUtils.forceDelete(fileArray[i2]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (var1_1 == null) {
            return;
        }
        throw var1_1;
    }

    private static void forceDelete(File object) throws IOException {
        if (((File)object).isDirectory()) {
            MinFileUtils.deleteDirectory((File)object);
        } else {
            File file = object;
            boolean bl = file.exists();
            if (!file.delete()) {
                if (!bl) {
                    throw new FileNotFoundException("File does not exist: " + object);
                }
                object = "Unable to delete file: " + object;
                throw new IOException((String)object);
            }
        }
    }

    private static void deleteDirectory(File object) throws IOException {
        if (!((File)object).exists()) {
            return;
        }
        File file = object;
        MinFileUtils.cleanDirectory(file);
        if (file.delete()) {
            return;
        }
        object = "Unable to delete directory " + object + ".";
        throw new IOException((String)object);
    }

    private static File[] verifiedListFiles(File object) throws IOException {
        if (((File)object).exists()) {
            if (((File)object).isDirectory()) {
                File[] fileArray = ((File)object).listFiles();
                if (fileArray != null) {
                    return fileArray;
                }
                throw new IOException("Failed to list contents of " + object);
            }
            object = object + " is not a directory";
            throw new IllegalArgumentException((String)object);
        }
        object = object + " does not exist";
        throw new IllegalArgumentException((String)object);
    }

    public static void writeOutZipEntry(ZipFile closeable, ZipEntry zipEntry, File file, String string2) throws IOException {
        ZipFile zipFile = closeable;
        closeable = null;
        try {
            closeable = zipFile.getInputStream(zipEntry);
            MinFileUtils.writeOutInputStream(file, string2, (InputStream)closeable);
            return;
        }
        finally {
            if (closeable != null) {
                ((InputStream)closeable).close();
            }
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static void writeOutInputStream(File object, String object2, InputStream object3) throws IOException {
        void var1_4;
        Object object4;
        block11: {
            BufferedInputStream bufferedInputStream;
            BufferedOutputStream bufferedOutputStream;
            File file;
            object4 = null;
            File file2 = file;
            file = new File((File)object, (String)object2);
            object = bufferedOutputStream;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            object2 = bufferedInputStream;
            try {
                bufferedInputStream = new BufferedInputStream((InputStream)object3);
                object3 = new byte[8192];
            }
            catch (Throwable throwable) {
                object4 = object;
            }
            while (true) {
                int n2 = ((BufferedInputStream)object2).read((byte[])object3, 0, 8192);
                if (n2 < 0) break;
                ((BufferedOutputStream)object).write((byte[])object3, 0, n2);
                continue;
                break;
            }
            ((FilterOutputStream)object).close();
            return;
            break block11;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object4 != null) {
            ((FilterOutputStream)object4).close();
        }
        throw var1_4;
    }
}

