/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Pair;
import android.view.LayoutInflater;
import com.tencent.shadow.core.runtime.BroadcastReceiverWrapper;
import com.tencent.shadow.core.runtime.PluginPartInfoManager;
import com.tencent.shadow.core.runtime.ShadowApplication;
import com.tencent.shadow.core.runtime.ShadowLayoutInflater;
import com.tencent.shadow.core.runtime.SubDirContextThemeWrapper;
import com.tencent.shadow.core.runtime.container.GeneratedHostActivityDelegator;

public class ShadowContext
extends SubDirContextThemeWrapper {
    public PluginComponentLauncher mPluginComponentLauncher;
    public ClassLoader mPluginClassLoader;
    public ShadowApplication mShadowApplication;
    public Resources mPluginResources;
    public LayoutInflater mLayoutInflater;
    public ApplicationInfo mApplicationInfo;
    public String mPartKey;
    private String mBusinessName;

    public ShadowContext() {
    }

    public ShadowContext(Context context, int n2) {
        super(context, n2);
    }

    private BroadcastReceiverWrapper receiverToWrapper(BroadcastReceiver broadcastReceiver) {
        return this.mShadowApplication.receiverToWrapper(broadcastReceiver);
    }

    public final void setPluginResources(Resources resources) {
        this.mPluginResources = resources;
    }

    public final void setPluginClassLoader(ClassLoader classLoader) {
        this.mPluginClassLoader = classLoader;
    }

    public void setPluginComponentLauncher(PluginComponentLauncher pluginComponentLauncher) {
        this.mPluginComponentLauncher = pluginComponentLauncher;
    }

    public void setShadowApplication(ShadowApplication shadowApplication) {
        this.mShadowApplication = shadowApplication;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        ApplicationInfo applicationInfo2;
        ShadowContext shadowContext = shadowContext2;
        ShadowContext shadowContext2 = applicationInfo2;
        new ApplicationInfo((ApplicationInfo)applicationInfo).metaData = null;
        shadowContext.mApplicationInfo = shadowContext2;
    }

    public void setBusinessName(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = null;
        }
        this.mBusinessName = string2;
    }

    public void setPluginPartKey(String string2) {
        this.mPartKey = string2;
    }

    public Context getApplicationContext() {
        return this.mShadowApplication;
    }

    public Resources getResources() {
        return this.mPluginResources;
    }

    public AssetManager getAssets() {
        return this.mPluginResources.getAssets();
    }

    public Object getSystemService(String string2) {
        if ("layout_inflater".equals(string2)) {
            if (this.mLayoutInflater == null) {
                ShadowContext shadowContext = this;
                this.mLayoutInflater = ShadowLayoutInflater.build((LayoutInflater)super.getSystemService(string2), (Context)shadowContext, shadowContext.mPartKey);
            }
            return this.mLayoutInflater;
        }
        return super.getSystemService(string2);
    }

    public ClassLoader getClassLoader() {
        return this.mPluginClassLoader;
    }

    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    public void startActivity(Intent intent, Bundle bundle) {
        Intent intent2;
        Intent intent3 = intent2;
        intent3(intent);
        intent2.setExtrasClassLoader(this.mPluginClassLoader);
        if (!this.mPluginComponentLauncher.startActivity(this, intent3, bundle)) {
            super.startActivity(intent, bundle);
        }
    }

    @TargetApi(value=16)
    public void superStartActivity(Intent intent, Bundle bundle) {
        super.startActivity(intent, bundle);
    }

    public void unbindService(ServiceConnection serviceConnection) {
        if (!((Boolean)this.mPluginComponentLauncher.unbindService((ShadowContext)this, (ServiceConnection)serviceConnection).first).booleanValue()) {
            super.unbindService(serviceConnection);
        }
    }

    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int n2) {
        if (intent.getComponent() == null) {
            return super.bindService(intent, serviceConnection, n2);
        }
        Pair<Boolean, Boolean> pair = this.mPluginComponentLauncher.bindService(this, intent, serviceConnection, n2);
        if (!((Boolean)pair.first).booleanValue()) {
            return super.bindService(intent, serviceConnection, n2);
        }
        return (Boolean)pair.second;
    }

    public boolean stopService(Intent intent) {
        if (intent.getComponent() == null) {
            return super.stopService(intent);
        }
        Pair<Boolean, Boolean> pair = this.mPluginComponentLauncher.stopService(this, intent);
        if (!((Boolean)pair.first).booleanValue()) {
            return super.stopService(intent);
        }
        return (Boolean)pair.second;
    }

    public ComponentName startService(Intent intent) {
        if (intent.getComponent() == null) {
            return super.startService(intent);
        }
        Pair<Boolean, ComponentName> pair = this.mPluginComponentLauncher.startService(this, intent);
        if (!((Boolean)pair.first).booleanValue()) {
            return super.startService(intent);
        }
        return (ComponentName)pair.second;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    public PluginComponentLauncher getPendingIntentConverter() {
        return this.mPluginComponentLauncher;
    }

    @Override
    public String getSubDirName() {
        if (this.mBusinessName == null) {
            return null;
        }
        return "ShadowPlugin_" + this.mBusinessName;
    }

    public String getPackageName() {
        return this.mApplicationInfo.packageName;
    }

    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        ShadowContext shadowContext = this;
        return super.registerReceiver((BroadcastReceiver)shadowContext.receiverToWrapper(broadcastReceiver), intentFilter);
    }

    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, int n2) {
        ShadowContext shadowContext = this;
        return super.registerReceiver((BroadcastReceiver)shadowContext.receiverToWrapper(broadcastReceiver), intentFilter, n2);
    }

    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler) {
        ShadowContext shadowContext = this;
        return super.registerReceiver((BroadcastReceiver)shadowContext.receiverToWrapper(broadcastReceiver), intentFilter, string2, handler);
    }

    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler, int n2) {
        ShadowContext shadowContext = this;
        return super.registerReceiver((BroadcastReceiver)shadowContext.receiverToWrapper(broadcastReceiver), intentFilter, string2, handler, n2);
    }

    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        BroadcastReceiverWrapper broadcastReceiverWrapper = this.receiverToWrapper(broadcastReceiver);
        if (broadcastReceiverWrapper != null) {
            super.unregisterReceiver((BroadcastReceiver)broadcastReceiverWrapper);
        } else {
            super.unregisterReceiver(broadcastReceiver);
        }
    }

    public String getPackageCodePath() {
        return PluginPartInfoManager.getPluginInfo((ClassLoader)this.getClassLoader()).packageManager.getArchiveFilePath();
    }

    public static interface PluginComponentLauncher {
        public boolean startActivity(ShadowContext var1, Intent var2, Bundle var3);

        public boolean startActivityForResult(GeneratedHostActivityDelegator var1, Intent var2, int var3, Bundle var4, ComponentName var5);

        public Pair<Boolean, ComponentName> startService(ShadowContext var1, Intent var2);

        public Pair<Boolean, Boolean> stopService(ShadowContext var1, Intent var2);

        public Pair<Boolean, Boolean> bindService(ShadowContext var1, Intent var2, ServiceConnection var3, int var4);

        public Pair<Boolean, ?> unbindService(ShadowContext var1, ServiceConnection var2);

        public Intent convertPluginActivityIntent(Intent var1);
    }
}

