/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.dynamic.host;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.shadow.core.common.Logger;
import com.tencent.shadow.core.common.LoggerFactory;
import com.tencent.shadow.core.utils.Md5;
import com.tencent.shadow.dynamic.host.EnterCallback;
import com.tencent.shadow.dynamic.host.ManagerImplLoader;
import com.tencent.shadow.dynamic.host.PluginManager;
import com.tencent.shadow.dynamic.host.PluginManagerImpl;
import com.tencent.shadow.dynamic.host.PluginManagerUpdater;
import java.io.File;

public final class DynamicPluginManager
implements PluginManager {
    private static final Logger mLogger = LoggerFactory.getLogger(DynamicPluginManager.class);
    private final PluginManagerUpdater mUpdater;
    private PluginManagerImpl mManagerImpl;
    private String mCurrentImplMd5;

    public DynamicPluginManager(PluginManagerUpdater pluginManagerUpdater) {
        if (pluginManagerUpdater.getLatest() != null) {
            this.mUpdater = pluginManagerUpdater;
            return;
        }
        throw new IllegalArgumentException("\u93cb\u52ef\ufffd\u71daynamicPluginManager\u93c3\u6735\u7d36\u934f\u30e7\u6b91PluginManagerUpdater\u8e47\u5474\u300f\u5bb8\u832c\u7ca1\u5bb8\u53c9\u6e41\u93c8\ue100\u6e74\u93c2\u56e6\u6b22\u951b\u5c7d\u5d46getLatest()!=null");
    }

    private void updateManagerImpl(Context object) {
        File file = this.mUpdater.getLatest();
        String string2 = Md5.md5File(file);
        Logger logger = mLogger;
        if (logger.isInfoEnabled()) {
            logger.info("TextUtils.equals(mCurrentImplMd5, md5) : " + TextUtils.equals((CharSequence)this.mCurrentImplMd5, (CharSequence)string2));
        }
        if (!TextUtils.equals((CharSequence)this.mCurrentImplMd5, (CharSequence)string2)) {
            object = new ManagerImplLoader((Context)object, file).load();
            if (this.mManagerImpl != null) {
                Bundle bundle;
                DynamicPluginManager dynamicPluginManager = this;
                file = bundle;
                bundle = new Bundle();
                dynamicPluginManager.mManagerImpl.onSaveInstanceState((Bundle)file);
                dynamicPluginManager.mManagerImpl.onDestroy();
            } else {
                file = null;
            }
            DynamicPluginManager dynamicPluginManager = this;
            object.onCreate((Bundle)file);
            dynamicPluginManager.mManagerImpl = object;
            dynamicPluginManager.mCurrentImplMd5 = string2;
        }
    }

    @Override
    public void enter(Context context, long l2, Bundle bundle, EnterCallback enterCallback) {
        Logger logger = mLogger;
        if (logger.isInfoEnabled()) {
            logger.info("enter fromId:" + l2 + " callback:" + enterCallback);
        }
        DynamicPluginManager dynamicPluginManager = this;
        dynamicPluginManager.updateManagerImpl(context);
        dynamicPluginManager.mManagerImpl.enter(context, l2, bundle, enterCallback);
        dynamicPluginManager.mUpdater.update();
    }

    public void release() {
        Object object = mLogger;
        if (object.isInfoEnabled()) {
            object.info("release");
        }
        if ((object = this.mManagerImpl) != null) {
            object.onDestroy();
            this.mManagerImpl = null;
        }
    }

    public PluginManager getManagerImpl() {
        return this.mManagerImpl;
    }
}

