/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.dynamic.host;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.tencent.shadow.core.common.InstalledApk;
import com.tencent.shadow.core.common.Logger;
import com.tencent.shadow.core.common.LoggerFactory;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.lang.reflect.Field;

public class DynamicRuntime {
    private static final Logger mLogger = LoggerFactory.getLogger(DynamicRuntime.class);
    private static final String SP_NAME = "ShadowRuntimeLoader";
    private static final String KEY_RUNTIME_APK = "KEY_RUNTIME_APK";
    private static final String KEY_RUNTIME_ODEX = "KEY_RUNTIME_ODEX";
    private static final String KEY_RUNTIME_LIB = "KEY_RUNTIME_LIB";

    public static boolean loadRuntime(InstalledApk installedApk) {
        ClassLoader classLoader = DynamicRuntime.class.getClassLoader();
        Object object = DynamicRuntime.getRuntimeClassLoader();
        if (object != null) {
            object = ((RuntimeClassLoader)object).apkPath;
            Logger logger = mLogger;
            if (logger.isInfoEnabled()) {
                logger.info("last apkPath:" + (String)object + " new apkPath:" + installedApk.apkFilePath);
            }
            if (TextUtils.equals((CharSequence)object, (CharSequence)installedApk.apkFilePath)) {
                if (logger.isInfoEnabled()) {
                    logger.info("\u5bb8\u832c\u7ca1\u9354\u72ba\u6d47\u9429\u7a3f\u6093apkPath\u9428\u5245untime\u6d5c\ufffd,\u6d93\u5d89\u6e36\u7455\u4f78\u59de\u675e\ufffd");
                }
                return false;
            }
            if (logger.isInfoEnabled()) {
                logger.info("\u9354\u72ba\u6d47\u6d93\u5d87\u6d49\u935a\u5b8epkPath\u9428\u5245untime\u6d5c\ufffd,\u934f\u581f\u4eee\u6fb6\u5cdclassLoader\u93cd\u6220\u7ca8\u93cb\ufffd");
            }
            try {
                DynamicRuntime.recoveryClassLoader();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        try {
            DynamicRuntime.hackParentToRuntime(installedApk, classLoader);
            return true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void recoveryClassLoader() throws Exception {
        ClassLoader classLoader;
        ClassLoader classLoader2 = DynamicRuntime.class.getClassLoader();
        ClassLoader classLoader3 = classLoader = classLoader2.getParent();
        classLoader = classLoader2;
        classLoader2 = classLoader3;
        while (classLoader2 != null) {
            if (classLoader2 instanceof RuntimeClassLoader) {
                DynamicRuntime.hackParentClassLoader(classLoader, classLoader2.getParent());
                return;
            }
            ClassLoader classLoader4 = classLoader = classLoader2.getParent();
            classLoader = classLoader2;
            classLoader2 = classLoader4;
        }
    }

    private static RuntimeClassLoader getRuntimeClassLoader() {
        for (ClassLoader classLoader = DynamicRuntime.class.getClassLoader().getParent(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof RuntimeClassLoader)) continue;
            return (RuntimeClassLoader)((Object)classLoader);
        }
        return null;
    }

    private static void hackParentToRuntime(InstalledApk object, ClassLoader object2) throws Exception {
        RuntimeClassLoader runtimeClassLoader;
        ClassLoader classLoader = object2;
        RuntimeClassLoader runtimeClassLoader2 = runtimeClassLoader;
        ClassLoader classLoader2 = object2;
        InstalledApk installedApk = object;
        object = installedApk.apkFilePath;
        object2 = installedApk.oDexPath;
        String string2 = installedApk.libraryPath;
        ClassLoader classLoader3 = classLoader2.getParent();
        runtimeClassLoader = new RuntimeClassLoader((String)object, (String)object2, string2, classLoader3);
        DynamicRuntime.hackParentClassLoader(classLoader, (ClassLoader)((Object)runtimeClassLoader2));
    }

    public static void hackParentClassLoader(ClassLoader classLoader, ClassLoader classLoader2) throws Exception {
        Field field = DynamicRuntime.getParentField();
        if (field != null) {
            Field field2 = field;
            field2.setAccessible(true);
            field2.set(classLoader, classLoader2);
            return;
        }
        throw new RuntimeException("\u9366\u2013lassLoader.class\u6d93\ue15f\u75c5\u93b5\u60e7\u57cc\u7eeb\u8bf2\u7037\u6d93\u7bcalassLoader\u9428\u523earent\u9369\ufffd");
    }

    private static Field getParentField() {
        ClassLoader classLoader = DynamicRuntime.class.getClassLoader();
        ClassLoader classLoader2 = classLoader.getParent();
        Field field = null;
        for (Field field2 : ClassLoader.class.getDeclaredFields()) {
            boolean bl;
            Field field3;
            ClassLoader classLoader3;
            try {
                classLoader3 = classLoader;
                Field field4 = field2;
                field3 = field4;
                bl = field4.isAccessible();
            }
            catch (IllegalAccessException illegalAccessException) {}
            field3.setAccessible(true);
            Object object = field2.get(classLoader3);
            field2.setAccessible(bl);
            if (object != classLoader2) continue;
            field = field2;
            break;
        }
        return field;
    }

    public static boolean recoveryRuntime(Context context) {
        InstalledApk installedApk = DynamicRuntime.getLastRuntimeInfo(context);
        if (installedApk != null && new File(installedApk.apkFilePath).exists()) {
            if (installedApk.oDexPath != null && !new File(installedApk.oDexPath).exists()) {
                return false;
            }
            try {
                DynamicRuntime.hackParentToRuntime(installedApk, DynamicRuntime.class.getClassLoader());
                return true;
            }
            catch (Exception exception) {
                Logger logger = mLogger;
                if (logger.isErrorEnabled()) {
                    logger.error("recoveryRuntime \u95bf\u6b12\ue1e4", exception);
                }
                DynamicRuntime.removeLastRuntimeInfo(context);
            }
        }
        return false;
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void saveLastRuntimeInfo(Context context, InstalledApk installedApk) {
        context.getSharedPreferences(SP_NAME, 0).edit().putString(KEY_RUNTIME_APK, installedApk.apkFilePath).putString(KEY_RUNTIME_ODEX, installedApk.oDexPath).putString(KEY_RUNTIME_LIB, installedApk.libraryPath).commit();
    }

    private static InstalledApk getLastRuntimeInfo(Context object) {
        object = object.getSharedPreferences(SP_NAME, 0);
        String string2 = object.getString(KEY_RUNTIME_APK, null);
        Context context = object;
        object = context.getString(KEY_RUNTIME_ODEX, null);
        String string3 = context.getString(KEY_RUNTIME_LIB, null);
        if (string2 == null) {
            return null;
        }
        return new InstalledApk(string2, (String)object, string3);
    }

    @SuppressLint(value={"ApplySharedPref"})
    private static void removeLastRuntimeInfo(Context context) {
        context.getSharedPreferences(SP_NAME, 0).edit().remove(KEY_RUNTIME_APK).remove(KEY_RUNTIME_ODEX).remove(KEY_RUNTIME_LIB).commit();
    }

    public static class RuntimeClassLoader
    extends BaseDexClassLoader {
        private String apkPath;

        public RuntimeClassLoader(String string2, String object, String string3, ClassLoader classLoader) {
            if (object == null) {
                object = null;
            } else {
                File file;
                File file2 = file;
                file = new File((String)object);
                object = file2;
            }
            super(string2, (File)object, string3, classLoader);
            this.apkPath = string2;
        }
    }
}

