/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.dynamic.manager;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import com.tencent.shadow.core.common.InstalledApk;
import com.tencent.shadow.core.common.Logger;
import com.tencent.shadow.core.common.LoggerFactory;
import com.tencent.shadow.core.load_parameters.LoadParameters;
import com.tencent.shadow.core.manager.BasePluginManager;
import com.tencent.shadow.core.manager.installplugin.InstalledPlugin;
import com.tencent.shadow.dynamic.host.FailedException;
import com.tencent.shadow.dynamic.host.NotFoundException;
import com.tencent.shadow.dynamic.manager.UuidManagerImpl;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BaseDynamicPluginManager
extends BasePluginManager
implements UuidManagerImpl {
    private static final Logger mLogger = LoggerFactory.getLogger(BaseDynamicPluginManager.class);
    private AtomicBoolean mServiceConnecting;
    private AtomicReference<CountDownLatch> mConnectCountDownLatch;

    public BaseDynamicPluginManager(Context context) {
        super(context);
        AtomicReference atomicReference;
        AtomicBoolean atomicBoolean;
        Object object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.mServiceConnecting = object;
        object = atomicReference;
        atomicReference = new AtomicReference();
        v1.mConnectCountDownLatch = object;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InstalledApk getInstalledPL(String object, int n2) throws FailedException, NotFoundException {
        Object object2;
        String string2;
        block15: {
            Object object3;
            block14: {
                block13: {
                    block12: {
                        object3 = ((BasePluginManager)object3).getLoaderOrRunTimePart((String)object, n2);
                        string2 = ((InstalledPlugin.Part)object3).pluginFile.getAbsolutePath();
                        {
                            catch (RuntimeException runtimeException) {
                                throw new FailedException(runtimeException);
                            }
                        }
                        object2 = ((InstalledPlugin.Part)object3).oDexDir;
                        if (object2 != null) break block12;
                        object2 = null;
                        break block13;
                    }
                    object2 = ((File)object2).getAbsolutePath();
                }
                object3 = ((InstalledPlugin.Part)object3).libraryDir;
                if (object3 != null) break block14;
                object3 = null;
                break block15;
            }
            object3 = ((File)object3).getAbsolutePath();
        }
        Object object4 = object;
        ((InstalledApk)object4)(string2, (String)object2, (String)object3);
        return object4;
        catch (RuntimeException runtimeException) {
            if (!mLogger.isErrorEnabled()) throw new NotFoundException("uuid==" + (String)object + " type==" + n2 + "\u6ca1\u627e\u5230\u3002cause\uff1a" + runtimeException.getMessage());
            mLogger.error("getInstalledPL exception:", runtimeException);
            throw new NotFoundException("uuid==" + (String)object + " type==" + n2 + "\u6ca1\u627e\u5230\u3002cause\uff1a" + runtimeException.getMessage());
        }
    }

    public final void bindPluginProcessService(final String string2) {
        block7: {
            CountDownLatch countDownLatch;
            if (((BaseDynamicPluginManager)((Object)logger)).mServiceConnecting.get()) {
                Logger logger = mLogger;
                if (logger.isInfoEnabled()) {
                    logger.info("pps service connecting");
                }
                return;
            }
            Object object = mLogger;
            if (object.isInfoEnabled()) {
                object.info("bindPluginProcessService " + string2);
            }
            Logger logger = logger;
            ((BaseDynamicPluginManager)((Object)logger)).mConnectCountDownLatch.set(new CountDownLatch(1));
            ((BaseDynamicPluginManager)((Object)logger)).mServiceConnecting.set(true);
            object = countDownLatch;
            countDownLatch = new CountDownLatch(1);
            final boolean[] blArray = new boolean[1];
            ((BasePluginManager)((Object)logger)).mUiHandler.post(new Runnable((CountDownLatch)object){
                public final /* synthetic */ CountDownLatch val$startBindingLatch;
                {
                    this.val$startBindingLatch = countDownLatch;
                }

                @Override
                public void run() {
                    boolean bl;
                    ServiceConnection serviceConnection;
                    Intent intent;
                    1 v0 = this;
                    Object object = intent;
                    1 v2 = this;
                    Context context = v2.BaseDynamicPluginManager.this.mHostContext;
                    new Intent().setComponent(new ComponentName(context, v2.string2));
                    Intent intent2 = object;
                    object = serviceConnection;
                    serviceConnection = new ServiceConnection(){

                        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                            if (mLogger.isInfoEnabled()) {
                                mLogger.info("onServiceConnected connectCountDownLatch:" + BaseDynamicPluginManager.this.mConnectCountDownLatch);
                            }
                            1 v0 = this;
                            v0.BaseDynamicPluginManager.this.mServiceConnecting.set(false);
                            v0.BaseDynamicPluginManager.this.onPluginServiceConnected(componentName, iBinder);
                            ((CountDownLatch)v0.BaseDynamicPluginManager.this.mConnectCountDownLatch.get()).countDown();
                            if (mLogger.isInfoEnabled()) {
                                mLogger.info("onServiceConnected countDown:" + BaseDynamicPluginManager.this.mConnectCountDownLatch);
                            }
                        }

                        public void onServiceDisconnected(ComponentName componentName) {
                            if (mLogger.isInfoEnabled()) {
                                mLogger.info("onServiceDisconnected");
                            }
                            1 v0 = this;
                            v0.BaseDynamicPluginManager.this.mServiceConnecting.set(false);
                            v0.BaseDynamicPluginManager.this.onPluginServiceDisconnected(componentName);
                        }
                    };
                    v0.blArray[0] = bl = v0.BaseDynamicPluginManager.this.mHostContext.bindService(intent2, (ServiceConnection)object, 1);
                    v0.val$startBindingLatch.countDown();
                }
            });
            try {
                ((CountDownLatch)object).await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            if (!blArray[0]) break block7;
            return;
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u7ed1\u5b9aPPS:" + string2);
    }

    /*
     * Unable to fully structure code
     */
    public final void waitServiceConnected(int var1_2, TimeUnit var2_3) throws TimeoutException {
        block10: {
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) break block10;
            try {
                var3_4 = BaseDynamicPluginManager.mLogger;
            }
            catch (InterruptedException var0_1) {
                throw new RuntimeException(var0_1);
            }
            if (!var3_4.isInfoEnabled()) ** GOTO lbl10
            var3_4.info("waiting service connect connectCountDownLatch:" + this.mConnectCountDownLatch);
lbl10:
            // 2 sources

            v0 = this;
            var4_5 = System.currentTimeMillis();
            v1 = v0.mConnectCountDownLatch.get();
            if (v1.await(var1_2, var2_3) ^ true) ** GOTO lbl25
            if (!var3_4.isInfoEnabled()) ** GOTO lbl24
            v2 = var3_4;
            v3 = new StringBuilder().append("service connected ");
            v4 = System.currentTimeMillis();
            v2.info(v3.append(v4 - var4_5).toString());
lbl24:
            // 2 sources

            return;
lbl25:
            // 1 sources

            v5 = v6;
            v7 = v6;
            v8 = new StringBuilder().append("\u8fde\u63a5Service\u8d85\u65f6 ,\u7b49\u5f85\u4e86\uff1a");
            v9 = System.currentTimeMillis();
            v5(v8.append(v9 - var4_5).toString());
            throw v7;
        }
        throw new RuntimeException("waitServiceConnected \u4e0d\u80fd\u5728\u4e3b\u7ebf\u7a0b\u4e2d\u8c03\u7528");
    }

    public abstract void onPluginServiceConnected(ComponentName var1, IBinder var2);

    public abstract void onPluginServiceDisconnected(ComponentName var1);

    public void onCreate(Bundle bundle) {
        Logger logger = mLogger;
        if (logger.isInfoEnabled()) {
            logger.info("onCreate bundle:" + bundle);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        Logger logger = mLogger;
        if (logger.isInfoEnabled()) {
            logger.info("onSaveInstanceState:" + bundle);
        }
    }

    public void onDestroy() {
        Logger logger = mLogger;
        if (logger.isInfoEnabled()) {
            logger.info("onDestroy:");
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public InstalledApk getPlugin(String object, String object2) throws FailedException, NotFoundException {
        Object object3;
        Object object4;
        block30: {
            Object object5;
            block29: {
                block28: {
                    block27: {
                        LoadParameters loadParameters;
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                object5 = ((BasePluginManager)object5).getPluginPartByPartKey((String)object, (String)object2);
                                                if (!(object5 instanceof InstalledPlugin.PluginPart)) break block21;
                                                {
                                                    catch (RuntimeException runtimeException) {
                                                        object = mLogger;
                                                        if (object.isErrorEnabled()) {
                                                            object.error("getPlugin exception:", runtimeException);
                                                        }
                                                        throw new FailedException(runtimeException);
                                                    }
                                                }
                                                object = ((InstalledPlugin.PluginPart)object5).businessName;
                                                break block22;
                                            }
                                            object = null;
                                        }
                                        if (!(object5 instanceof InstalledPlugin.PluginPart)) break block23;
                                        object4 = ((InstalledPlugin.PluginPart)object5).dependsOn;
                                        break block24;
                                    }
                                    object4 = null;
                                }
                                if (!(object5 instanceof InstalledPlugin.PluginPart)) break block25;
                                object3 = ((InstalledPlugin.PluginPart)object5).hostWhiteList;
                                break block26;
                            }
                            object3 = null;
                        }
                        Object object6 = object5;
                        Object object7 = object6;
                        Object object8 = object6;
                        LoadParameters loadParameters2 = loadParameters;
                        loadParameters = new LoadParameters((String)object, (String)object2, object4, (String[])object3);
                        Parcel parcel = Parcel.obtain();
                        loadParameters2.writeToParcel(parcel, 0);
                        object = parcel.marshall();
                        parcel.recycle();
                        object4 = ((InstalledPlugin.Part)object7).pluginFile.getAbsolutePath();
                        object3 = ((InstalledPlugin.Part)object8).oDexDir;
                        if (object3 != null) break block27;
                        object3 = null;
                        break block28;
                    }
                    object3 = ((File)object3).getAbsolutePath();
                }
                object5 = ((InstalledPlugin.Part)object5).libraryDir;
                if (object5 != null) break block29;
                object5 = null;
                break block30;
            }
            object5 = ((File)object5).getAbsolutePath();
        }
        Object object9 = object2;
        ((InstalledApk)object9)((String)object4, (String)object3, (String)object5, (byte[])object);
        return object9;
        catch (RuntimeException runtimeException) {
            throw new NotFoundException("uuid==" + (String)object + "partKey==" + (String)object2 + "\u7684Plugin\u627e\u4e0d\u5230");
        }
    }

    @Override
    public InstalledApk getPluginLoader(String string2) throws FailedException, NotFoundException {
        return this.getInstalledPL(string2, 3);
    }

    @Override
    public InstalledApk getRuntime(String string2) throws FailedException, NotFoundException {
        return this.getInstalledPL(string2, 4);
    }
}

