/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiapxx.starter.uidgenerator.properties;

import io.github.xiapxx.starter.uidgenerator.enums.UGWorkerTypeEnum;
import io.github.xiapxx.starter.uidgenerator.properties.UGWorkerConfig;
import io.github.xiapxx.starter.uidgenerator.properties.UGWorkerDataSourceConfig;
import java.sql.Driver;
import java.util.ServiceLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="uid.generator")
public class UidGeneratorProperties
implements InitializingBean {
    public static final String PREFIX = "uid.generator";
    private int timeBits = 29;
    private int workerBits = 21;
    private int seqBits = 13;
    private String epochStr = "2025-03-07";
    private int boostPower = 3;
    private int paddingFactor = 50;
    private Long scheduleInterval;
    private UGWorkerConfig worker = new UGWorkerConfig();

    public int getTimeBits() {
        return this.timeBits;
    }

    public void setTimeBits(int timeBits) {
        this.timeBits = timeBits;
    }

    public int getWorkerBits() {
        return this.workerBits;
    }

    public void setWorkerBits(int workerBits) {
        this.workerBits = workerBits;
    }

    public int getSeqBits() {
        return this.seqBits;
    }

    public void setSeqBits(int seqBits) {
        this.seqBits = seqBits;
    }

    public String getEpochStr() {
        return this.epochStr;
    }

    public void setEpochStr(String epochStr) {
        this.epochStr = epochStr;
    }

    public int getBoostPower() {
        return this.boostPower;
    }

    public void setBoostPower(int boostPower) {
        this.boostPower = boostPower;
    }

    public int getPaddingFactor() {
        return this.paddingFactor;
    }

    public void setPaddingFactor(int paddingFactor) {
        this.paddingFactor = paddingFactor;
    }

    public Long getScheduleInterval() {
        return this.scheduleInterval;
    }

    public void setScheduleInterval(Long scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    public UGWorkerConfig getWorker() {
        return this.worker;
    }

    public void setWorker(UGWorkerConfig worker) {
        this.worker = worker;
    }

    public void afterPropertiesSet() throws Exception {
        this.loadDriverClass();
    }

    private void loadDriverClass() {
        if (this.worker.getType() == null || UGWorkerTypeEnum.redis == this.worker.getType()) {
            return;
        }
        UGWorkerDataSourceConfig dataSource = this.worker.getDataSource();
        if (dataSource.getDriverClass() != null && dataSource.getDriverClass().length() > 0) {
            return;
        }
        ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class);
        if (serviceLoader == null) {
            return;
        }
        for (Driver driver : serviceLoader) {
            String driverClassName = driver.getClass().getName();
            if (!driverClassName.toLowerCase().contains(this.worker.getType().name())) continue;
            dataSource.setDriverClass(driverClassName);
            return;
        }
    }
}

