/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiapxx.starter.uidgenerator.worker;

import io.github.xiapxx.starter.uidgenerator.worker.AbstractWorkerIdAssigner;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisWorkerIdAssigner
extends AbstractWorkerIdAssigner
implements Runnable {
    private static final String REDIS_KEY = "uid_generator:";
    private static final int REDIS_TIME_OUT = 300;
    private static final int RENEW_INTERVAL = 200;
    private StringRedisTemplate stringRedisTemplate;
    private String currentIp;
    private ScheduledThreadPoolExecutor scheduler;

    public RedisWorkerIdAssigner(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.currentIp = this.getLocalIp();
    }

    private String getLocalIp() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostAddress();
        }
        catch (UnknownHostException e) {
            return "UnknownHost";
        }
    }

    @Override
    public long createWorkId(long maxWorkerId) {
        Set<Long> usingWorkerIdSet = this.getUsingWorkerId();
        for (long i = 1L; i < maxWorkerId; ++i) {
            if (usingWorkerIdSet.contains(i)) continue;
            String redisKey = "uid_generator::" + i;
            if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)this.currentIp, 300L, TimeUnit.SECONDS).booleanValue()) continue;
            this.startRenewWorkerId();
            return i;
        }
        throw new IllegalArgumentException("Unable to allocate Worker ID");
    }

    private void startRenewWorkerId() {
        this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleWithFixedDelay(this, 10L, 200L, TimeUnit.SECONDS);
    }

    private Set<Long> getUsingWorkerId() {
        Set keys = this.stringRedisTemplate.keys((Object)"uid_generator:*");
        if (keys == null || keys.isEmpty()) {
            return new HashSet<Long>();
        }
        return keys.stream().map(item -> Long.valueOf(item)).collect(Collectors.toSet());
    }

    @Override
    public void run() {
        Long currentWorkId = this.getCurrentWorkId();
        if (currentWorkId == null) {
            return;
        }
        this.stringRedisTemplate.expire((Object)("uid_generator::" + currentWorkId), 300L, TimeUnit.SECONDS);
    }
}

