/*
 * Decompiled with CFR 0.152.
 */
package io.github.xn32.json5k.deserialization;

import io.github.xn32.json5k.DuplicateKeyError;
import io.github.xn32.json5k.ErrorHandlingKt;
import io.github.xn32.json5k.deserialization.MainDecoder;
import io.github.xn32.json5k.format.Token;
import io.github.xn32.json5k.parsing.Event;
import io.github.xn32.json5k.parsing.LinePosition;
import io.github.xn32.json5k.parsing.LookaheadParser;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0014H\u0017J\b\u0010%\u001a\u00020&H\u0017J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/github/xn32/json5k/deserialization/KeyDecoder;", "Lkotlinx/serialization/encoding/Decoder;", "parent", "Lio/github/xn32/json5k/deserialization/MainDecoder;", "(Lio/github/xn32/json5k/deserialization/MainDecoder;)V", "parser", "Lio/github/xn32/json5k/parsing/LookaheadParser;", "Lio/github/xn32/json5k/format/Token;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "specifiedKeys", "", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeEnum", "", "enumDescriptor", "decodeFloat", "", "decodeInline", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeShort", "", "decodeString", "json5k"})
final class KeyDecoder
implements Decoder {
    @NotNull
    private final MainDecoder parent;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Set<String> specifiedKeys;
    @NotNull
    private final LookaheadParser<Token> parser;

    public KeyDecoder(@NotNull MainDecoder parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.serializersModule = this.parent.getSerializersModule();
        this.specifiedKeys = new LinkedHashSet();
        this.parser = this.parent.getParser();
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public boolean decodeBoolean() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public byte decodeByte() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public short decodeShort() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public int decodeInt() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public long decodeLong() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public char decodeChar() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public float decodeFloat() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    public double decodeDouble() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    @ExperimentalSerializationApi
    public boolean decodeNotNullMark() {
        return this.parent.decodeNotNullMark();
    }

    @ExperimentalSerializationApi
    @NotNull
    public Void decodeNull() {
        ErrorHandlingKt.throwKeyTypeException();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this;
    }

    @NotNull
    public String decodeString() {
        Event event = this.parser.next();
        LinePosition pos = event.component1();
        Token token = (Token)event.component2();
        if (!(token instanceof Token.MemberName)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String name = ((Token.MemberName)token).unbox-impl();
        if (!this.specifiedKeys.add(name)) {
            throw new DuplicateKeyError(name, pos);
        }
        return name;
    }

    @ExperimentalSerializationApi
    @Nullable
    public <T> T decodeNullableSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        return (T)Decoder.DefaultImpls.decodeNullableSerializableValue((Decoder)this, deserializer);
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        return (T)Decoder.DefaultImpls.decodeSerializableValue((Decoder)this, deserializer);
    }
}

