/*
 * Decompiled with CFR 0.152.
 */
package io.github.xn32.json5k.generation;

import io.github.xn32.json5k.OutputStrategy;
import io.github.xn32.json5k.format.DocumentTracker;
import io.github.xn32.json5k.format.Specification;
import io.github.xn32.json5k.format.Token;
import io.github.xn32.json5k.generation.FormatGeneratorKt;
import io.github.xn32.json5k.generation.OutputSink;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J\u001d\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\nH\u0002J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\n2\b\b\u0002\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lio/github/xn32/json5k/generation/FormatGenerator;", "", "sink", "Lio/github/xn32/json5k/generation/OutputSink;", "outputStrategy", "Lio/github/xn32/json5k/OutputStrategy;", "(Lio/github/xn32/json5k/generation/OutputSink;Lio/github/xn32/json5k/OutputStrategy;)V", "tracker", "Lio/github/xn32/json5k/format/DocumentTracker;", "handleBeginToken", "", "token", "Lio/github/xn32/json5k/format/Token$BeginToken;", "handleEndToken", "Lio/github/xn32/json5k/format/Token$EndToken;", "handleMemberName", "Lio/github/xn32/json5k/format/Token$MemberName;", "handleMemberName-g79HYq0", "(Ljava/lang/String;)V", "handleNextItem", "Lio/github/xn32/json5k/format/Token;", "handleToken", "put", "putValue", "Lio/github/xn32/json5k/format/Token$Value;", "writeComma", "writeComment", "comment", "", "writeQuoted", "sequence", "", "writeVisualSep", "levelOffset", "", "json5k"})
public final class FormatGenerator {
    @NotNull
    private final OutputSink sink;
    @NotNull
    private final OutputStrategy outputStrategy;
    @NotNull
    private final DocumentTracker tracker;

    public FormatGenerator(@NotNull OutputSink sink, @NotNull OutputStrategy outputStrategy) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)outputStrategy, (String)"outputStrategy");
        this.sink = sink;
        this.outputStrategy = outputStrategy;
        this.tracker = new DocumentTracker();
    }

    public final void put(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.handleToken(token);
        this.tracker.supply(token);
    }

    public final void writeComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        if (!this.tracker.getInObjectStruct()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (this.tracker.getNextTokenType() == DocumentTracker.TokenType.COMMA) {
            this.writeComma();
        }
        if (!(this.tracker.getNextTokenType() == DocumentTracker.TokenType.NEXT_ITEM)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.outputStrategy instanceof OutputStrategy.HumanReadable)) {
            return;
        }
        String[] stringArray = FormatGeneratorKt.access$getLINE_DELIMITERS$p();
        for (String line : StringsKt.splitToSequence$default((CharSequence)comment, (String[])Arrays.copyOf(stringArray, stringArray.length), (boolean)false, (int)0, (int)6, null)) {
            FormatGenerator.writeVisualSep$default(this, 0, 1, null);
            FormatGeneratorKt.access$write(this.sink, "// " + line);
        }
    }

    private final void writeComma() {
        this.sink.write(',');
        this.tracker.supplyComma();
    }

    private final void writeQuoted(CharSequence sequence) {
        FormatGeneratorKt.access$writeQuoted(this.sink, this.outputStrategy.getQuoteCharacter(), sequence);
    }

    private final void writeVisualSep(int levelOffset) {
        if (!(this.outputStrategy instanceof OutputStrategy.HumanReadable)) {
            return;
        }
        FormatGeneratorKt.access$write(this.sink, "\n");
        int n = ((OutputStrategy.HumanReadable)this.outputStrategy).getIndentationWith() * (this.tracker.getNestingLevel() + levelOffset);
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this.sink.write(' ');
        }
    }

    static /* synthetic */ void writeVisualSep$default(FormatGenerator formatGenerator, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        formatGenerator.writeVisualSep(n);
    }

    private final void handleToken(Token token) {
        if (token instanceof Token.EndToken) {
            if (this.tracker.getNextTokenType() == DocumentTracker.TokenType.COMMA) {
                this.writeVisualSep(-1);
            }
            this.handleEndToken((Token.EndToken)token);
            return;
        }
        if (this.tracker.getNextTokenType() == DocumentTracker.TokenType.NEXT_ITEM && this.tracker.getNestingLevel() > 0) {
            FormatGenerator.writeVisualSep$default(this, 0, 1, null);
        }
        if (this.tracker.getNextTokenType() == DocumentTracker.TokenType.COMMA) {
            this.writeComma();
            if (token instanceof Token.BeginToken && this.outputStrategy instanceof OutputStrategy.HumanReadable) {
                this.sink.write(' ');
            } else if (!(token instanceof Token.BeginToken)) {
                FormatGenerator.writeVisualSep$default(this, 0, 1, null);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.tracker.getNextTokenType().ordinal()]) {
            case 1: {
                if (token instanceof Token.EndOfFile) break;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            case 2: 
            case 3: {
                if (this.tracker.getInObjectStruct()) {
                    if (!(token instanceof Token.MemberName)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.handleMemberName-g79HYq0(((Token.MemberName)token).unbox-impl());
                    break;
                }
                this.handleNextItem(token);
                break;
            }
            case 4: {
                this.handleNextItem(token);
            }
        }
    }

    private final void handleEndToken(Token.EndToken token) {
        Token.EndToken endToken = token;
        if (Intrinsics.areEqual((Object)endToken, (Object)Token.EndObject.INSTANCE)) {
            this.sink.write('}');
        } else if (Intrinsics.areEqual((Object)endToken, (Object)Token.EndArray.INSTANCE)) {
            this.sink.write(']');
        }
    }

    private final void handleBeginToken(Token.BeginToken token) {
        Token.BeginToken beginToken = token;
        if (Intrinsics.areEqual((Object)beginToken, (Object)Token.BeginObject.INSTANCE)) {
            this.sink.write('{');
        } else if (Intrinsics.areEqual((Object)beginToken, (Object)Token.BeginArray.INSTANCE)) {
            this.sink.write('[');
        }
    }

    private final void handleMemberName-g79HYq0(String token) {
        String name = token;
        if (!Specification.INSTANCE.isIdentifier(name) || this.outputStrategy.getQuoteMemberNames()) {
            this.writeQuoted(name);
        } else {
            FormatGeneratorKt.access$write(this.sink, token);
        }
        this.sink.write(':');
        if (this.outputStrategy instanceof OutputStrategy.HumanReadable) {
            this.sink.write(' ');
        }
    }

    private final void handleNextItem(Token token) {
        Token token2 = token;
        if (token2 instanceof Token.BeginToken) {
            this.handleBeginToken((Token.BeginToken)token);
        } else if (token2 instanceof Token.Value) {
            this.putValue((Token.Value)token);
        } else {
            throw new IllegalArgumentException("unexpected token type");
        }
    }

    private final void putValue(Token.Value token) {
        Token.Value value = token;
        if (value instanceof Token.Bool) {
            FormatGeneratorKt.access$write(this.sink, String.valueOf(((Token.Bool)token).unbox-impl()));
        } else if (Intrinsics.areEqual((Object)value, (Object)Token.Null.INSTANCE)) {
            FormatGeneratorKt.access$write(this.sink, "null");
        } else if (value instanceof Token.FloatingPoint) {
            FormatGeneratorKt.access$write(this.sink, String.valueOf(((Token.FloatingPoint)token).unbox-impl()));
        } else if (value instanceof Token.SignedInteger) {
            FormatGeneratorKt.access$write(this.sink, String.valueOf(((Token.SignedInteger)token).unbox-impl()));
        } else if (value instanceof Token.UnsignedInteger) {
            FormatGeneratorKt.access$write(this.sink, Long.toUnsignedString(((Token.UnsignedInteger)token).unbox-impl()));
        } else if (value instanceof Token.Str) {
            this.writeQuoted(((Token.Str)token).unbox-impl());
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocumentTracker.TokenType.values().length];
            try {
                nArray[DocumentTracker.TokenType.END_OF_FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentTracker.TokenType.NEXT_ITEM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentTracker.TokenType.COMMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentTracker.TokenType.MEMBER_VALUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

