/*
 * Decompiled with CFR 0.152.
 */
package io.github.xn32.json5k.parsing;

import io.github.xn32.json5k.ErrorHandlingKt;
import io.github.xn32.json5k.LiteralError;
import io.github.xn32.json5k.format.DocumentTracker;
import io.github.xn32.json5k.format.Specification;
import io.github.xn32.json5k.format.Token;
import io.github.xn32.json5k.parsing.Event;
import io.github.xn32.json5k.parsing.FormatParser;
import io.github.xn32.json5k.parsing.FormatParserKt;
import io.github.xn32.json5k.parsing.FormatReader;
import io.github.xn32.json5k.parsing.FormatReaderKt;
import io.github.xn32.json5k.parsing.InputSource;
import io.github.xn32.json5k.parsing.LinePosition;
import io.github.xn32.json5k.parsing.NumParser;
import io.github.xn32.json5k.parsing.Parser;
import io.github.xn32.json5k.parsing.StringParser;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0002H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u0018H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0002H\u0002J\b\u0010\u001c\u001a\u00020\u0002H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lio/github/xn32/json5k/parsing/FormatParser;", "Lio/github/xn32/json5k/parsing/Parser;", "Lio/github/xn32/json5k/format/Token;", "streamReader", "Lio/github/xn32/json5k/parsing/InputSource;", "(Lio/github/xn32/json5k/parsing/InputSource;)V", "numParser", "Lio/github/xn32/json5k/parsing/NumParser;", "reader", "Lio/github/xn32/json5k/parsing/FormatReader;", "stringParser", "Lio/github/xn32/json5k/parsing/StringParser;", "tracker", "Lio/github/xn32/json5k/format/DocumentTracker;", "advanceToPrimaryToken", "", "next", "Lio/github/xn32/json5k/parsing/Event;", "nextPrimaryToken", "parseIdentifierName", "", "parseLiteral", "Lio/github/xn32/json5k/format/Token$Value;", "parseMemberName", "Lio/github/xn32/json5k/format/Token$MemberName;", "parseMemberName-pN0VByY", "()Ljava/lang/String;", "parseStructCloser", "parseValue", "json5k"})
public final class FormatParser
implements Parser<Token> {
    @NotNull
    private final FormatReader reader;
    @NotNull
    private final StringParser stringParser;
    @NotNull
    private final NumParser numParser;
    @NotNull
    private final DocumentTracker tracker;

    public FormatParser(@NotNull InputSource streamReader) {
        Intrinsics.checkNotNullParameter((Object)streamReader, (String)"streamReader");
        this.reader = new FormatReader(streamReader);
        this.stringParser = new StringParser(this.reader);
        this.numParser = new NumParser(this.reader);
        this.tracker = new DocumentTracker();
    }

    @Override
    @NotNull
    public Event<Token> next() {
        this.advanceToPrimaryToken();
        LinePosition pos = this.reader.getPos();
        Token token = this.nextPrimaryToken();
        this.tracker.supply(token);
        return new Event<Token>(pos, token);
    }

    private final void advanceToPrimaryToken() {
        this.reader.advance();
        if (this.tracker.getNextTokenType() == DocumentTracker.TokenType.COMMA) {
            Character c = FormatReaderKt.peekOrNull(this.reader);
            char c2 = ',';
            if (c != null && c.charValue() == c2) {
                this.reader.consume();
                this.tracker.supplyComma();
                this.reader.advance();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Token nextPrimaryToken() {
        v0 = next = FormatReaderKt.peekOrNull(this.reader);
        var3_2 = '}';
        if (v0 != null && v0.charValue() == var3_2) ** GOTO lbl-1000
        v1 = next;
        var3_2 = ']';
        if (v1 != null && v1.charValue() == var3_2) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        structCloserPending = v2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.tracker.getNextTokenType().ordinal()]) {
            case 1: {
                v3 = this.parseValue();
                break;
            }
            case 2: {
                if (this.tracker.getInStruct() && structCloserPending) {
                    v3 = this.parseStructCloser();
                    break;
                }
                if (this.tracker.getInObjectStruct()) {
                    v3 = Token.MemberName.box-impl(this.parseMemberName-pN0VByY());
                    break;
                }
                v3 = this.parseValue();
                break;
            }
            case 3: {
                if (structCloserPending) {
                    v3 = this.parseStructCloser();
                    break;
                }
                ErrorHandlingKt.throwTokenError(this.reader);
                throw new KotlinNothingValueException();
            }
            case 4: {
                if (next != null) {
                    ErrorHandlingKt.throwTokenError(this.reader);
                    throw new KotlinNothingValueException();
                }
                v3 = Token.EndOfFile.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v3;
    }

    private final String parseMemberName-pN0VByY() {
        char c = this.reader.peek();
        String memberName = Token.MemberName.constructor-impl((c == '\"' ? true : c == '\'') ? this.stringParser.parseQuotedString() : this.parseIdentifierName());
        this.reader.advance();
        if (this.reader.getDone() || this.reader.peek() != ':') {
            ErrorHandlingKt.throwTokenError(this.reader);
            throw new KotlinNothingValueException();
        }
        this.reader.consume();
        return memberName;
    }

    private final String parseIdentifierName() {
        if (!Specification.INSTANCE.startsIdentifier(this.reader.peek()) && this.reader.peek() != '\\') {
            ErrorHandlingKt.throwTokenError(this.reader);
            throw new KotlinNothingValueException();
        }
        StringBuilder builder = new StringBuilder();
        while (true) {
            Character c;
            Character c2 = c = FormatReaderKt.peekOrNull(this.reader);
            char c3 = '\\';
            if (c2 != null && c2.charValue() == c3) {
                this.reader.consume();
                Character c4 = FormatReaderKt.peekOrNull(this.reader);
                c3 = 'u';
                if (c4 == null || c4.charValue() != c3) {
                    ErrorHandlingKt.throwTokenError(this.reader);
                    throw new KotlinNothingValueException();
                }
                this.reader.consume();
                builder.append(FormatParserKt.access$readHexSequence(this.reader, 4));
                continue;
            }
            if (c == null || !Specification.INSTANCE.isIdentifierPart(c.charValue())) break;
            builder.append(this.reader.consume());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final Token parseValue() {
        Token token;
        boolean bl;
        Character c;
        Character c2 = c = FormatReaderKt.peekOrNull(this.reader);
        char c3 = '\"';
        if (c2 != null && c2.charValue() == c3) {
            bl = true;
        } else {
            Character c4 = c;
            c3 = '\'';
            bl = c4 != null && c4.charValue() == c3;
        }
        if (bl) {
            token = Token.Str.box-impl(Token.Str.constructor-impl(this.stringParser.parseQuotedString()));
        } else {
            boolean bl2;
            CharRange charRange = new CharRange('a', 'z');
            if (c != null && charRange.contains(c.charValue())) {
                bl2 = true;
            } else {
                charRange = new CharRange('A', 'Z');
                bl2 = c != null && charRange.contains(c.charValue());
            }
            if (bl2) {
                token = this.parseLiteral();
            } else {
                boolean bl3;
                boolean bl4;
                boolean bl5;
                charRange = new CharRange('0', '9');
                if (c != null && charRange.contains(c.charValue())) {
                    bl5 = true;
                } else {
                    Character c5 = c;
                    char c6 = '+';
                    bl5 = c5 != null && c5.charValue() == c6;
                }
                if (bl5) {
                    bl4 = true;
                } else {
                    Character c7 = c;
                    char c8 = '-';
                    bl4 = c7 != null && c7.charValue() == c8;
                }
                if (bl4) {
                    bl3 = true;
                } else {
                    Character c9 = c;
                    char c10 = '.';
                    bl3 = c9 != null && c9.charValue() == c10;
                }
                if (bl3) {
                    token = this.numParser.parseNumber();
                } else {
                    Character c11 = c;
                    char c12 = '{';
                    if (c11 != null && c11.charValue() == c12) {
                        this.reader.consume();
                        token = Token.BeginObject.INSTANCE;
                    } else {
                        Character c13 = c;
                        c12 = '[';
                        if (c13 != null && c13.charValue() == c12) {
                            this.reader.consume();
                            token = Token.BeginArray.INSTANCE;
                        } else {
                            ErrorHandlingKt.throwTokenError(this.reader);
                            throw new KotlinNothingValueException();
                        }
                    }
                }
            }
        }
        return token;
    }

    private final Token.Value parseLiteral() {
        Token.Value value;
        LinePosition pos = this.reader.getPos();
        String letters2 = FormatReaderKt.consumeWhile(this.reader, (Function1<? super Character, Boolean>)((Function1)parseLiteral.letters.1.INSTANCE));
        Token.Num num = FormatParserKt.access$numLiteralOf(letters2);
        if (num != null) {
            value = num;
        } else {
            value = FormatParserKt.access$miscLiteralOf(letters2);
            if (value == null) {
                throw new LiteralError(letters2, pos);
            }
        }
        return value;
    }

    private final Token parseStructCloser() {
        Token.EndToken endToken;
        char c = this.reader.peek();
        if (this.tracker.getInObjectStruct() && c == '}') {
            endToken = Token.EndObject.INSTANCE;
        } else if (this.tracker.getInArrayStruct() && c == ']') {
            endToken = Token.EndArray.INSTANCE;
        } else {
            ErrorHandlingKt.throwTokenError(this.reader);
            throw new KotlinNothingValueException();
        }
        Token.EndToken token = endToken;
        this.reader.consume();
        return token;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocumentTracker.TokenType.values().length];
            try {
                nArray[DocumentTracker.TokenType.MEMBER_VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentTracker.TokenType.NEXT_ITEM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentTracker.TokenType.COMMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentTracker.TokenType.END_OF_FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

