/*
 * Decompiled with CFR 0.152.
 */
package io.github.xn32.json5k.parsing;

import io.github.xn32.json5k.CharHelpersKt;
import io.github.xn32.json5k.ErrorHandlingKt;
import io.github.xn32.json5k.format.Token;
import io.github.xn32.json5k.parsing.FormatParserKt;
import io.github.xn32.json5k.parsing.FormatReaderKt;
import io.github.xn32.json5k.parsing.Sign;
import io.github.xn32.json5k.parsing.SourceReader;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a,\u0010\f\u001a\u00020\r*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0014*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0018\u001a\u00020\t*\u00020\u0011H\u0002\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"EXPONENTIAL_BASE", "", "HEX_BASE", "", "U_HEX_DIGITS", "X_HEX_DIGITS", "miscLiteralOf", "Lio/github/xn32/json5k/format/Token$Value;", "letters", "", "numLiteralOf", "Lio/github/xn32/json5k/format/Token$Num;", "appendWhile", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "reader", "Lio/github/xn32/json5k/parsing/SourceReader;", "predicate", "Lkotlin/Function1;", "", "", "readHexSequence", "width", "readHexString", "readOptionalSign", "Lio/github/xn32/json5k/parsing/Sign;", "json5k"})
public final class FormatParserKt {
    private static final double EXPONENTIAL_BASE = 10.0;
    private static final int HEX_BASE = 16;
    private static final int U_HEX_DIGITS = 4;
    private static final int X_HEX_DIGITS = 2;

    private static final Sign readOptionalSign(SourceReader $this$readOptionalSign) {
        Sign sign;
        Object object;
        Character c = object = FormatReaderKt.peekOrNull($this$readOptionalSign);
        char c2 = '+';
        if (c != null && c.charValue() == c2) {
            sign = Sign.PLUS;
        } else {
            Character c3 = object;
            c2 = '-';
            if (c3 != null && c3.charValue() == c2) {
                sign = Sign.MINUS;
            } else {
                return Sign.PLUS;
            }
        }
        Object it = object = sign;
        boolean bl = false;
        $this$readOptionalSign.consume();
        return object;
    }

    private static final char readHexSequence(SourceReader $this$readHexSequence, int width) {
        StringBuilder builder = new StringBuilder();
        int n = 0;
        while (n < width) {
            int it = n++;
            boolean bl = false;
            if ($this$readHexSequence.getDone() || !CharHelpersKt.isHexDigit($this$readHexSequence.peek())) {
                ErrorHandlingKt.throwTokenError($this$readHexSequence);
                throw new KotlinNothingValueException();
            }
            builder.append($this$readHexSequence.consume());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        String string2 = string;
        int n2 = 16;
        return (char)Integer.parseInt(string2, CharsKt.checkRadix((int)n2));
    }

    private static final void appendWhile(StringBuilder $this$appendWhile, SourceReader reader, Function1<? super Character, Boolean> predicate) {
        Character next;
        while ((next = FormatReaderKt.peekOrNull(reader)) != null && ((Boolean)predicate.invoke((Object)next)).booleanValue()) {
            $this$appendWhile.append(reader.consume());
        }
    }

    private static final Token.Num numLiteralOf(String letters2) {
        String string = letters2;
        return Intrinsics.areEqual((Object)string, (Object)"Infinity") ? Token.FloatingPoint.box-impl(Token.FloatingPoint.constructor-impl(Double.POSITIVE_INFINITY)) : (Intrinsics.areEqual((Object)string, (Object)"NaN") ? Token.FloatingPoint.box-impl(Token.FloatingPoint.constructor-impl(Double.NaN)) : null);
    }

    private static final Token.Value miscLiteralOf(String letters2) {
        Token.Value value;
        switch (letters2) {
            case "true": {
                value = Token.Bool.box-impl(Token.Bool.constructor-impl(true));
                break;
            }
            case "false": {
                value = Token.Bool.box-impl(Token.Bool.constructor-impl(false));
                break;
            }
            case "null": {
                value = Token.Null.INSTANCE;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private static final String readHexString(SourceReader $this$readHexString) {
        return FormatReaderKt.consumeWhile($this$readHexString, (Function1<? super Character, Boolean>)((Function1)readHexString.1.INSTANCE));
    }

    public static final /* synthetic */ char access$readHexSequence(SourceReader $receiver, int width) {
        return FormatParserKt.readHexSequence($receiver, width);
    }

    public static final /* synthetic */ Token.Num access$numLiteralOf(String letters2) {
        return FormatParserKt.numLiteralOf(letters2);
    }

    public static final /* synthetic */ Token.Value access$miscLiteralOf(String letters2) {
        return FormatParserKt.miscLiteralOf(letters2);
    }

    public static final /* synthetic */ Sign access$readOptionalSign(SourceReader $receiver) {
        return FormatParserKt.readOptionalSign($receiver);
    }

    public static final /* synthetic */ String access$readHexString(SourceReader $receiver) {
        return FormatParserKt.readHexString($receiver);
    }

    public static final /* synthetic */ void access$appendWhile(StringBuilder $receiver, SourceReader reader, Function1 predicate) {
        FormatParserKt.appendWhile($receiver, reader, (Function1<? super Character, Boolean>)predicate);
    }
}

