/*
 * Decompiled with CFR 0.152.
 */
package io.github.xn32.json5k.parsing;

import io.github.xn32.json5k.CharHelpersKt;
import io.github.xn32.json5k.ErrorHandlingKt;
import io.github.xn32.json5k.LiteralError;
import io.github.xn32.json5k.OverflowError;
import io.github.xn32.json5k.format.Token;
import io.github.xn32.json5k.parsing.FormatParserKt;
import io.github.xn32.json5k.parsing.FormatReader;
import io.github.xn32.json5k.parsing.FormatReaderKt;
import io.github.xn32.json5k.parsing.LinePosition;
import io.github.xn32.json5k.parsing.NumParser;
import io.github.xn32.json5k.parsing.Sign;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ULong;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0006H\u0002J\u0006\u0010\u000e\u001a\u00020\u0006J\b\u0010\u000f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/xn32/json5k/parsing/NumParser;", "", "reader", "Lio/github/xn32/json5k/parsing/FormatReader;", "(Lio/github/xn32/json5k/parsing/FormatReader;)V", "parseDecimal", "Lio/github/xn32/json5k/format/Token$Num;", "parseExponent", "", "()Ljava/lang/Integer;", "parseHexNumber", "startPos", "Lio/github/xn32/json5k/parsing/LinePosition;", "parseNumLiteral", "parseNumber", "parseZeroPrefixedNumber", "json5k"})
@SourceDebugExtension(value={"SMAP\nFormatParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatParser.kt\nio/github/xn32/json5k/parsing/NumParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n1#2:386\n*E\n"})
final class NumParser {
    @NotNull
    private final FormatReader reader;

    public NumParser(@NotNull FormatReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
    }

    @NotNull
    public final Token.Num parseNumber() {
        Token.Num num;
        Token.Num value;
        LinePosition pos = this.reader.getPos();
        boolean negate = FormatParserKt.access$readOptionalSign(this.reader) == Sign.MINUS;
        Character c = FormatReaderKt.peekOrNull(this.reader);
        if (c == null) {
            ErrorHandlingKt.throwTokenError(this.reader);
            throw new KotlinNothingValueException();
        }
        char next = c.charValue();
        Token.Num num2 = next == '0' ? this.parseZeroPrefixedNumber() : (value = next == '.' || CharHelpersKt.isDecimalDigit(next) ? this.parseDecimal() : this.parseNumLiteral());
        if (negate && value instanceof Token.FloatingPoint) {
            num = Token.FloatingPoint.box-impl(Token.FloatingPoint.constructor-impl(-((Token.FloatingPoint)value).unbox-impl()));
        } else if (negate && value instanceof Token.UnsignedInteger) {
            if (Long.compareUnsigned(((Token.UnsignedInteger)value).unbox-impl(), ULong.constructor-impl((long)Long.MIN_VALUE)) > 0) {
                throw new OverflowError(pos);
            }
            num = Token.SignedInteger.box-impl(Token.SignedInteger.constructor-impl(-((Token.UnsignedInteger)value).unbox-impl()));
        } else {
            num = value;
        }
        return num;
    }

    private final Token.Num parseZeroPrefixedNumber() {
        Token.Num num;
        boolean bl;
        Character c;
        LinePosition pos = this.reader.getPos();
        this.reader.consume();
        Character c2 = c = FormatReaderKt.peekOrNull(this.reader);
        char c3 = 'x';
        if (c2 != null && c2.charValue() == c3) {
            bl = true;
        } else {
            Character c4 = c;
            c3 = 'X';
            bl = c4 != null && c4.charValue() == c3;
        }
        if (bl) {
            num = this.parseHexNumber(pos);
        } else {
            Character c5 = c;
            c3 = '.';
            num = c5 != null && c5.charValue() == c3 ? this.parseDecimal() : Token.UnsignedInteger.box-impl(Token.UnsignedInteger.constructor-impl(0L));
        }
        return num;
    }

    private final Token.Num parseNumLiteral() {
        LinePosition pos = this.reader.getPos();
        String letters2 = FormatReaderKt.consumeWhile(this.reader, (Function1<? super Character, Boolean>)((Function1)parseNumLiteral.letters.1.INSTANCE));
        Token.Num num = FormatParserKt.access$numLiteralOf(letters2);
        if (num == null) {
            throw new LiteralError(letters2, pos);
        }
        return num;
    }

    private final Token.Num parseHexNumber(LinePosition startPos) {
        long l;
        this.reader.consume();
        String hexString = FormatParserKt.access$readHexString(this.reader);
        if (((CharSequence)hexString).length() == 0) {
            ErrorHandlingKt.throwTokenError(this.reader);
            throw new KotlinNothingValueException();
        }
        try {
            l = UStringsKt.toULong((String)hexString, (int)16);
        }
        catch (NumberFormatException e) {
            throw new OverflowError(startPos);
        }
        long number = l;
        return Token.UnsignedInteger.box-impl(Token.UnsignedInteger.constructor-impl(number));
    }

    private final Integer parseExponent() {
        Integer n;
        Character c = FormatReaderKt.peekOrNull(this.reader);
        boolean bl = c != null ? Character.toLowerCase(c.charValue()) == 'e' : false;
        if (bl) {
            int n2;
            this.reader.consume();
            switch (WhenMappings.$EnumSwitchMapping$0[FormatParserKt.access$readOptionalSign(this.reader).ordinal()]) {
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = -1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int factor = n2;
            String str2 = FormatReaderKt.consumeWhile(this.reader, (Function1<? super Character, Boolean>)((Function1)parseExponent.str.1.INSTANCE));
            if (((CharSequence)str2).length() == 0) {
                ErrorHandlingKt.throwTokenError(this.reader);
                throw new KotlinNothingValueException();
            }
            n = factor * Integer.parseInt(str2);
        } else {
            n = null;
        }
        return n;
    }

    private final Token.Num parseDecimal() {
        Token.Num num;
        boolean hasDecimalPoint;
        StringBuilder builder = new StringBuilder();
        FormatParserKt.access$appendWhile(builder, this.reader, parseDecimal.1.INSTANCE);
        Character c = FormatReaderKt.peekOrNull(this.reader);
        char c2 = '.';
        boolean bl = hasDecimalPoint = c != null && c.charValue() == c2;
        if (hasDecimalPoint) {
            builder.append(this.reader.consume());
            FormatParserKt.access$appendWhile(builder, this.reader, parseDecimal.2.INSTANCE);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        String token = string;
        if (Intrinsics.areEqual((Object)token, (Object)".")) {
            ErrorHandlingKt.throwTokenError(this.reader);
            throw new KotlinNothingValueException();
        }
        Integer exp = this.parseExponent();
        if (hasDecimalPoint || exp != null) {
            double d;
            Integer n = exp;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                d = Math.pow(10.0, it);
            } else {
                d = 1.0;
            }
            double factor = d;
            num = Token.FloatingPoint.box-impl(Token.FloatingPoint.constructor-impl(factor * Double.parseDouble(token)));
        } else {
            num = Token.UnsignedInteger.box-impl(Token.UnsignedInteger.constructor-impl(UStringsKt.toULong((String)token)));
        }
        return num;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Sign.values().length];
            try {
                nArray[Sign.PLUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Sign.MINUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

