/*
 * Decompiled with CFR 0.152.
 */
package io.github.xn32.json5k.parsing;

import io.github.xn32.json5k.ErrorHandlingKt;
import io.github.xn32.json5k.format.Specification;
import io.github.xn32.json5k.parsing.FormatParserKt;
import io.github.xn32.json5k.parsing.FormatReader;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/xn32/json5k/parsing/StringParser;", "", "reader", "Lio/github/xn32/json5k/parsing/FormatReader;", "(Lio/github/xn32/json5k/parsing/FormatReader;)V", "handleStringBackslash", "", "sink", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "parseQuotedString", "", "json5k"})
@SourceDebugExtension(value={"SMAP\nFormatParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatParser.kt\nio/github/xn32/json5k/parsing/StringParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n1#2:386\n*E\n"})
final class StringParser {
    @NotNull
    private final FormatReader reader;

    public StringParser(@NotNull FormatReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
    }

    @NotNull
    public final String parseQuotedString() {
        char quote = this.reader.consume();
        StringBuilder builder = new StringBuilder();
        while (!this.reader.getDone()) {
            char c = this.reader.peek();
            if (c == '\\') {
                this.handleStringBackslash(builder);
                continue;
            }
            if (c == quote) {
                String string;
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
                String it = string = string2;
                boolean bl = false;
                this.reader.consume();
                return string;
            }
            if (Specification.INSTANCE.getUNESCAPED_STRING_CHARS().contains(Character.valueOf(c))) {
                builder.append(this.reader.consume());
                continue;
            }
            if (Specification.INSTANCE.getLINE_TERMINATORS().contains(Character.valueOf(c))) break;
            builder.append(this.reader.consume());
        }
        ErrorHandlingKt.throwTokenError(this.reader);
        throw new KotlinNothingValueException();
    }

    private final void handleStringBackslash(Appendable sink) {
        this.reader.consume();
        if (this.reader.getDone()) {
            ErrorHandlingKt.throwTokenError(this.reader);
            throw new KotlinNothingValueException();
        }
        char c = this.reader.peek();
        if (Specification.INSTANCE.getLINE_TERMINATORS().contains(Character.valueOf(c))) {
            this.reader.consume();
        } else {
            Character c2 = Character.valueOf(c);
            if (Specification.INSTANCE.getSINGLE_ESCAPE_CHARS().containsKey(c2)) {
                Character c3 = Specification.INSTANCE.getSINGLE_ESCAPE_CHARS().get(Character.valueOf(this.reader.consume()));
                Intrinsics.checkNotNull((Object)c3);
                sink.append(c3.charValue());
            } else {
                boolean bl = '1' <= c ? c < ':' : false;
                if (bl) {
                    ErrorHandlingKt.throwTokenError(this.reader);
                    throw new KotlinNothingValueException();
                }
                if (c == '0') {
                    Appendable appendable;
                    Appendable it = appendable = sink.append('\u0000');
                    boolean bl2 = false;
                    this.reader.consume();
                } else if (c == 'x' ? true : c == 'u') {
                    this.reader.consume();
                    sink.append(FormatParserKt.access$readHexSequence(this.reader, c == 'u' ? 4 : 2));
                } else {
                    sink.append(this.reader.consume());
                }
            }
        }
    }
}

