/*
 * Decompiled with CFR 0.152.
 */
package io.github.xn32.json5k.serialization;

import io.github.xn32.json5k.Json5Kt;
import io.github.xn32.json5k.Settings;
import io.github.xn32.json5k.format.Token;
import io.github.xn32.json5k.generation.FormatGenerator;
import io.github.xn32.json5k.serialization.ClassEncoder;
import io.github.xn32.json5k.serialization.ListEncoder;
import io.github.xn32.json5k.serialization.MapEncoder;
import io.github.xn32.json5k.serialization.PolymorphicEncoder;
import io.github.xn32.json5k.serialization.UnsignedEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020+H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lio/github/xn32/json5k/serialization/MainEncoder;", "Lkotlinx/serialization/encoding/Encoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "generator", "Lio/github/xn32/json5k/generation/FormatGenerator;", "settings", "Lio/github/xn32/json5k/Settings;", "(Lkotlinx/serialization/modules/SerializersModule;Lio/github/xn32/json5k/generation/FormatGenerator;Lio/github/xn32/json5k/Settings;)V", "getGenerator", "()Lio/github/xn32/json5k/generation/FormatGenerator;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getSettings", "()Lio/github/xn32/json5k/Settings;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeBoolean", "", "value", "", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeEnum", "enumDescriptor", "index", "", "encodeFloat", "", "encodeInline", "encodeInt", "encodeLong", "", "encodeNull", "encodeShort", "", "encodeString", "", "json5k"})
public final class MainEncoder
implements Encoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final FormatGenerator generator;
    @NotNull
    private final Settings settings;

    public MainEncoder(@NotNull SerializersModule serializersModule, @NotNull FormatGenerator generator, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.serializersModule = serializersModule;
        this.generator = generator;
        this.settings = settings;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public final FormatGenerator getGenerator() {
        return this.generator;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) ? true : Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            compositeEncoder = new ClassEncoder(this, false, null, 6, null);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            compositeEncoder = new ListEncoder(this);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            compositeEncoder = new MapEncoder(this);
        } else if (serialKind instanceof PolymorphicKind) {
            compositeEncoder = new PolymorphicEncoder(descriptor, this);
        } else {
            throw new UnsupportedOperationException();
        }
        return compositeEncoder;
    }

    public void encodeBoolean(boolean value) {
        this.generator.put(Token.Bool.box-impl(Token.Bool.constructor-impl(value)));
    }

    public void encodeFloat(float value) {
        this.encodeDouble(value);
    }

    public void encodeByte(byte value) {
        this.encodeLong(value);
    }

    public void encodeShort(short value) {
        this.encodeLong(value);
    }

    public void encodeInt(int value) {
        this.encodeLong(value);
    }

    public void encodeLong(long value) {
        this.generator.put(Token.SignedInteger.box-impl(Token.SignedInteger.constructor-impl(value)));
    }

    public void encodeDouble(double value) {
        this.generator.put(Token.FloatingPoint.box-impl(Token.FloatingPoint.constructor-impl(value)));
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.generator.put(Token.Str.box-impl(Token.Str.constructor-impl(value)));
    }

    public void encodeChar(char value) {
        this.generator.put(Token.Str.box-impl(Token.Str.constructor-impl(String.valueOf(value))));
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.generator.put(Token.Str.box-impl(Token.Str.constructor-impl(enumDescriptor.getElementName(index))));
    }

    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return Json5Kt.isUnsignedNumber(descriptor) ? (Encoder)new UnsignedEncoder(this) : (Encoder)this;
    }

    public void encodeNull() {
        this.generator.put(Token.Null.INSTANCE);
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        return Encoder.DefaultImpls.beginCollection((Encoder)this, (SerialDescriptor)descriptor, (int)collectionSize);
    }

    @ExperimentalSerializationApi
    public void encodeNotNullMark() {
        Encoder.DefaultImpls.encodeNotNullMark((Encoder)this);
    }

    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Encoder.DefaultImpls.encodeNullableSerializableValue((Encoder)this, serializer, value);
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Encoder.DefaultImpls.encodeSerializableValue((Encoder)this, serializer, value);
    }
}

