/*
 * Decompiled with CFR 0.152.
 */
package com.xgr.wechatpay.wxpay;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.xgr.easypay.base.IPayStrategy;
import com.xgr.easypay.callback.IPayCallback;
import com.xgr.wechatpay.wxpay.WXErrCodeEx;
import com.xgr.wechatpay.wxpay.WXPayInfoImpli;

public class WXPay
implements IPayStrategy<WXPayInfoImpli> {
    private static WXPay mWXPay;
    private WXPayInfoImpli payInfoImpli;
    private static IPayCallback sPayCallback;
    private IWXAPI mWXApi;
    private boolean initializated;

    private WXPay() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXPay getInstance() {
        if (mWXPay != null) return mWXPay;
        Class<WXPay> clazz = WXPay.class;
        synchronized (WXPay.class) {
            if (mWXPay != null) return mWXPay;
            mWXPay = new WXPay();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mWXPay;
        }
    }

    public IWXAPI getWXApi() {
        return this.mWXApi;
    }

    private void initWXApi(Context context, String appId) {
        this.mWXApi = WXAPIFactory.createWXAPI((Context)context.getApplicationContext(), (String)appId);
        this.mWXApi.registerApp(appId);
        this.initializated = true;
    }

    public void pay(Activity activity, WXPayInfoImpli payInfo, IPayCallback payCallback) {
        this.payInfoImpli = payInfo;
        sPayCallback = payCallback;
        if (this.payInfoImpli == null || TextUtils.isEmpty((CharSequence)this.payInfoImpli.getAppid()) || TextUtils.isEmpty((CharSequence)this.payInfoImpli.getPartnerid()) || TextUtils.isEmpty((CharSequence)this.payInfoImpli.getPrepayId()) || TextUtils.isEmpty((CharSequence)this.payInfoImpli.getPackageValue()) || TextUtils.isEmpty((CharSequence)this.payInfoImpli.getNonceStr()) || TextUtils.isEmpty((CharSequence)this.payInfoImpli.getTimestamp()) || TextUtils.isEmpty((CharSequence)this.payInfoImpli.getSign())) {
            if (payCallback != null) {
                payCallback.failed(1001, WXErrCodeEx.getMessageByCode(1001));
            }
            return;
        }
        if (!this.initializated) {
            this.initWXApi(activity.getApplicationContext(), this.payInfoImpli.getAppid());
        }
        if (!this.check()) {
            if (payCallback != null) {
                payCallback.failed(1000, WXErrCodeEx.getMessageByCode(1000));
            }
            return;
        }
        PayReq req = new PayReq();
        req.appId = this.payInfoImpli.getAppid();
        req.partnerId = this.payInfoImpli.getPartnerid();
        req.prepayId = this.payInfoImpli.getPrepayId();
        req.packageValue = this.payInfoImpli.getPackageValue();
        req.nonceStr = this.payInfoImpli.getNonceStr();
        req.timeStamp = this.payInfoImpli.getTimestamp();
        req.sign = this.payInfoImpli.getSign();
        this.mWXApi.sendReq((BaseReq)req);
    }

    public void onResp(int errorCode, String errorMsg) {
        if (sPayCallback == null) {
            return;
        }
        if (errorCode == 0) {
            sPayCallback.success();
        } else if (errorCode == -1) {
            sPayCallback.failed(errorCode, errorMsg);
        } else if (errorCode == -2) {
            sPayCallback.cancel();
        } else {
            sPayCallback.failed(errorCode, errorMsg);
        }
        sPayCallback = null;
    }

    private boolean check() {
        return this.mWXApi.isWXAppInstalled() && this.mWXApi.getWXAppSupportAPI() >= 0x22000001;
    }
}

