/*
 * Decompiled with CFR 0.152.
 */
package io.github.yeagy.bss;

import io.github.yeagy.bss.BetterPreparedStatement;
import io.github.yeagy.bss.DelayedBindingProxy;
import io.github.yeagy.bss.NamedParameters;
import io.github.yeagy.bss.TypeMappers;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class BetterPreparedStatementImpl
implements BetterPreparedStatement {
    private final PreparedStatement ps;
    private final NamedParameters namedParameters;

    BetterPreparedStatementImpl(PreparedStatement ps, NamedParameters namedParameters) {
        this.ps = ps;
        this.namedParameters = namedParameters;
    }

    static BetterPreparedStatement from(Connection connection, String statement, boolean returnGeneratedKeys, boolean simulatedIn) throws SQLException {
        Objects.requireNonNull(statement);
        Objects.requireNonNull(connection);
        if (simulatedIn && BetterPreparedStatementImpl.detectInClause(statement)) {
            return DelayedBindingProxy.from(connection, statement, returnGeneratedKeys);
        }
        NamedParameters named = NamedParameters.from(statement);
        if (named != null) {
            statement = named.getProcessedSql();
        }
        int returnKeys = returnGeneratedKeys ? 1 : 2;
        return new BetterPreparedStatementImpl(connection.prepareStatement(statement, returnKeys), named);
    }

    private static boolean detectInClause(String statement) {
        return statement.toLowerCase().matches(".+[\t\n ]+in[\t\n ]+\\(.*");
    }

    private void setNamedParameter(String namedParameter, NamedParameterSetter setter) throws SQLException {
        if (this.namedParameters == null) {
            throw new IllegalStateException("no named parameters found in statement");
        }
        List<Integer> indices = this.namedParameters.getIndices(namedParameter);
        if (indices != null) {
            for (Integer idx : indices) {
                setter.set(this, idx);
            }
        } else {
            throw new IllegalStateException(String.format("no named parameter %s found in statement: %s", namedParameter, this.namedParameters.getUnprocessedSql()));
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.ps.getConnection().createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.ps.getConnection().createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.ps.getConnection().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.ps.getConnection().createSQLXML();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.ps.getConnection().createArrayOf(typeName, elements);
    }

    @Override
    public Array createArray(Object[] elements) throws SQLException {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("array must have elements");
        }
        Class<?> clazz = elements[0].getClass();
        String sqlType = TypeMappers.getSqlType(clazz);
        if (sqlType == null) {
            throw new SQLException("no sql type found for java class " + clazz.getName());
        }
        return this.createArrayOf(sqlType, elements);
    }

    @Override
    public Array createArray(Collection<?> elements) throws SQLException {
        return this.createArray(elements == null ? null : elements.toArray());
    }

    @Override
    public void setArray(int parameterIndex, Collection<?> x) throws SQLException {
        this.setArray(parameterIndex, this.createArray(x));
    }

    @Override
    public void setArray(String namedParameter, Collection<?> x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setArray(parameterIndex, x));
    }

    @Override
    public void setArray(int parameterIndex, Object[] x) throws SQLException {
        this.setArray(parameterIndex, this.createArray(x));
    }

    @Override
    public void setArray(String namedParameter, Object[] x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setArray(parameterIndex, x));
    }

    @Override
    public void setTime(int parameterIndex, LocalTime x) throws SQLException {
        this.setTime(parameterIndex, x == null ? null : Time.valueOf(x));
    }

    @Override
    public void setTime(String namedParameter, LocalTime x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setTime(parameterIndex, x));
    }

    @Override
    public void setDate(int parameterIndex, LocalDate x) throws SQLException {
        this.setDate(parameterIndex, x == null ? null : Date.valueOf(x));
    }

    @Override
    public void setDate(String namedParameter, LocalDate x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setDate(parameterIndex, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, LocalDateTime x) throws SQLException {
        this.setTimestamp(parameterIndex, x == null ? null : Timestamp.valueOf(x));
    }

    @Override
    public void setTimestamp(String namedParameter, LocalDateTime x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setTimestamp(parameterIndex, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, OffsetDateTime x) throws SQLException {
        this.setTimestamp(parameterIndex, x == null ? null : x.toInstant());
    }

    @Override
    public void setTimestamp(String namedParameter, OffsetDateTime x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setTimestamp(parameterIndex, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Instant x) throws SQLException {
        this.setTimestamp(parameterIndex, x == null ? null : Timestamp.from(x));
    }

    @Override
    public void setTimestamp(String namedParameter, Instant x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setTimestamp(parameterIndex, x));
    }

    @Override
    public void setNull(String namedParameter, int sqlType) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setNull(parameterIndex, sqlType));
    }

    @Override
    public void setBoolean(String namedParameter, boolean x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBoolean(parameterIndex, x));
    }

    @Override
    public void setByte(String namedParameter, byte x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setByte(parameterIndex, x));
    }

    @Override
    public void setShort(String namedParameter, short x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setShort(parameterIndex, x));
    }

    @Override
    public void setInt(String namedParameter, int x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setInt(parameterIndex, x));
    }

    @Override
    public void setLong(String namedParameter, long x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setLong(parameterIndex, x));
    }

    @Override
    public void setFloat(String namedParameter, float x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setFloat(parameterIndex, x));
    }

    @Override
    public void setDouble(String namedParameter, double x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setDouble(parameterIndex, x));
    }

    @Override
    public void setBigDecimal(String namedParameter, BigDecimal x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBigDecimal(parameterIndex, x));
    }

    @Override
    public void setString(String namedParameter, String x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setString(parameterIndex, x));
    }

    @Override
    public void setBytes(String namedParameter, byte[] x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBytes(parameterIndex, x));
    }

    @Override
    public void setDate(String namedParameter, Date x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setDate(parameterIndex, x));
    }

    @Override
    public void setTime(String namedParameter, Time x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setTime(parameterIndex, x));
    }

    @Override
    public void setTimestamp(String namedParameter, Timestamp x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setTimestamp(parameterIndex, x));
    }

    @Override
    public void setAsciiStream(String namedParameter, InputStream x, int length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setAsciiStream(parameterIndex, x, length));
    }

    @Override
    public void setBinaryStream(String namedParameter, InputStream x, int length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBinaryStream(parameterIndex, x, length));
    }

    @Override
    public void setObject(String namedParameter, Object x, int targetSqlType) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setObject(parameterIndex, x, targetSqlType));
    }

    @Override
    public void setObject(String namedParameter, Object x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setObject(parameterIndex, x));
    }

    @Override
    public void setCharacterStream(String namedParameter, Reader reader, int length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setCharacterStream(parameterIndex, reader, length));
    }

    @Override
    public void setRef(String namedParameter, Ref x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setRef(parameterIndex, x));
    }

    @Override
    public void setBlob(String namedParameter, Blob x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBlob(parameterIndex, x));
    }

    @Override
    public void setClob(String namedParameter, Clob x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setClob(parameterIndex, x));
    }

    @Override
    public void setArray(String namedParameter, Array x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setArray(parameterIndex, x));
    }

    @Override
    public void setDate(String namedParameter, Date x, Calendar cal) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setDate(parameterIndex, x, cal));
    }

    @Override
    public void setTime(String namedParameter, Time x, Calendar cal) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setTime(parameterIndex, x, cal));
    }

    @Override
    public void setTimestamp(String namedParameter, Timestamp x, Calendar cal) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setTimestamp(parameterIndex, x, cal));
    }

    @Override
    public void setNull(String namedParameter, int sqlType, String typeName) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setNull(parameterIndex, sqlType, typeName));
    }

    @Override
    public void setURL(String namedParameter, URL x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setURL(parameterIndex, x));
    }

    @Override
    public void setRowId(String namedParameter, RowId x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setRowId(parameterIndex, x));
    }

    @Override
    public void setNString(String namedParameter, String value) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setNString(parameterIndex, value));
    }

    @Override
    public void setNCharacterStream(String namedParameter, Reader value, long length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setNCharacterStream(parameterIndex, value, length));
    }

    @Override
    public void setNClob(String namedParameter, NClob value) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setNClob(parameterIndex, value));
    }

    @Override
    public void setClob(String namedParameter, Reader reader, long length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setClob(parameterIndex, reader, length));
    }

    @Override
    public void setBlob(String namedParameter, InputStream inputStream, long length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBlob(parameterIndex, inputStream, length));
    }

    @Override
    public void setNClob(String namedParameter, Reader reader, long length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setNClob(parameterIndex, reader, length));
    }

    @Override
    public void setSQLXML(String namedParameter, SQLXML xmlObject) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setSQLXML(parameterIndex, xmlObject));
    }

    @Override
    public void setObject(String namedParameter, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setObject(parameterIndex, x, targetSqlType, scaleOrLength));
    }

    @Override
    public void setAsciiStream(String namedParameter, InputStream x, long length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setAsciiStream(parameterIndex, x, length));
    }

    @Override
    public void setBinaryStream(String namedParameter, InputStream x, long length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBinaryStream(parameterIndex, x, length));
    }

    @Override
    public void setCharacterStream(String namedParameter, Reader reader, long length) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setCharacterStream(parameterIndex, reader, length));
    }

    @Override
    public void setAsciiStream(String namedParameter, InputStream x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setAsciiStream(parameterIndex, x));
    }

    @Override
    public void setBinaryStream(String namedParameter, InputStream x) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBinaryStream(parameterIndex, x));
    }

    @Override
    public void setCharacterStream(String namedParameter, Reader reader) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setCharacterStream(parameterIndex, reader));
    }

    @Override
    public void setNCharacterStream(String namedParameter, Reader value) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setNCharacterStream(parameterIndex, value));
    }

    @Override
    public void setClob(String namedParameter, Reader reader) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setClob(parameterIndex, reader));
    }

    @Override
    public void setBlob(String namedParameter, InputStream inputStream) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setBlob(parameterIndex, inputStream));
    }

    @Override
    public void setNClob(String namedParameter, Reader reader) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setNClob(parameterIndex, reader));
    }

    @Override
    public void setObject(String namedParameter, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setObject(parameterIndex, x, targetSqlType, scaleOrLength));
    }

    @Override
    public void setObject(String namedParameter, Object x, SQLType targetSqlType) throws SQLException {
        this.setNamedParameter(namedParameter, (ps, parameterIndex) -> this.setObject(parameterIndex, x, targetSqlType));
    }

    @Override
    public void setBooleanNullable(String namedParameter, Boolean x) throws SQLException {
        if (x == null) {
            this.setNull(namedParameter, 16);
        } else {
            this.setBoolean(namedParameter, (boolean)x);
        }
    }

    @Override
    public void setByteNullable(String namedParameter, Byte x) throws SQLException {
        if (x == null) {
            this.setNull(namedParameter, -6);
        } else {
            this.setByte(namedParameter, (byte)x);
        }
    }

    @Override
    public void setShortNullable(String namedParameter, Short x) throws SQLException {
        if (x == null) {
            this.setNull(namedParameter, 5);
        } else {
            this.setShort(namedParameter, (short)x);
        }
    }

    @Override
    public void setIntNullable(String namedParameter, Integer x) throws SQLException {
        if (x == null) {
            this.setNull(namedParameter, 4);
        } else {
            this.setInt(namedParameter, (int)x);
        }
    }

    @Override
    public void setLongNullable(String namedParameter, Long x) throws SQLException {
        if (x == null) {
            this.setNull(namedParameter, -5);
        } else {
            this.setLong(namedParameter, (long)x);
        }
    }

    @Override
    public void setFloatNullable(String namedParameter, Float x) throws SQLException {
        if (x == null) {
            this.setNull(namedParameter, 7);
        } else {
            this.setFloat(namedParameter, x.floatValue());
        }
    }

    @Override
    public void setDoubleNullable(String namedParameter, Double x) throws SQLException {
        if (x == null) {
            this.setNull(namedParameter, 8);
        } else {
            this.setDouble(namedParameter, (double)x);
        }
    }

    @Override
    public void setBooleanNullable(int parameterIndex, Boolean x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 16);
        } else {
            this.ps.setBoolean(parameterIndex, x);
        }
    }

    @Override
    public void setByteNullable(int parameterIndex, Byte x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -6);
        } else {
            this.ps.setByte(parameterIndex, x);
        }
    }

    @Override
    public void setShortNullable(int parameterIndex, Short x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 5);
        } else {
            this.ps.setShort(parameterIndex, x);
        }
    }

    @Override
    public void setIntNullable(int parameterIndex, Integer x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 4);
        } else {
            this.ps.setInt(parameterIndex, x);
        }
    }

    @Override
    public void setLongNullable(int parameterIndex, Long x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -5);
        } else {
            this.ps.setLong(parameterIndex, x);
        }
    }

    @Override
    public void setFloatNullable(int parameterIndex, Float x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 7);
        } else {
            this.ps.setFloat(parameterIndex, x.floatValue());
        }
    }

    @Override
    public void setDoubleNullable(int parameterIndex, Double x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 8);
        } else {
            this.ps.setDouble(parameterIndex, x);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ps.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ps.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ps.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ps.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ps.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ps.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ps.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ps.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ps.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ps.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.ps.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.ps.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ps.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.ps.setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.ps.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.ps.setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.ps.setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ps.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ps.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ps.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ps.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.ps.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.ps.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.ps.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setNClob(parameterIndex, reader);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.ps.executeLargeUpdate();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.ps.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.ps.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.ps.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ps.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.ps.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ps.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.ps.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ps.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.ps.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ps.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ps.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ps.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.ps.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.ps.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ps.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.ps.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ps.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.ps.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.ps.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.ps.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.ps.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.ps.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.ps.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ps.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ps.isWrapperFor(iface);
    }

    @FunctionalInterface
    private static interface NamedParameterSetter {
        public void set(BetterPreparedStatement var1, int var2) throws SQLException;
    }
}

