/*
 * Decompiled with CFR 0.152.
 */
package io.github.yeagy.bss;

import io.github.yeagy.bss.BetterOptions;
import io.github.yeagy.bss.TableData;
import io.github.yeagy.bss.TypeMappers;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class BetterSqlGenerator {
    private static final Collector<CharSequence, ?, String> COMMA_JOIN = Collectors.joining(", ");
    private static final Collector<CharSequence, ?, String> AND_JOIN = Collectors.joining(" AND ");
    private final BetterOptions options;

    private BetterSqlGenerator(BetterOptions options) {
        this.options = options;
    }

    public static BetterSqlGenerator fromDefaults() {
        return BetterSqlGenerator.from(BetterOptions.fromDefaults());
    }

    public static BetterSqlGenerator from(BetterOptions options) {
        return new BetterSqlGenerator(options);
    }

    public String generateSelectSqlTemplate(TableData table) {
        return this.formatSelect(this.columns(table, true), table.getTableName(), this.primaryKeysWithIndexParams(table));
    }

    public String generateSelectSqlTemplateNamed(TableData table) {
        return this.formatSelect(this.columns(table, true), table.getTableName(), this.primaryKeysWithNamedParams(table));
    }

    private String formatSelect(String columns, String tableName, String conditions) {
        return String.format("SELECT %s FROM %s WHERE %s", columns, tableName, conditions);
    }

    public String generateBulkSelectSqlTemplate(TableData table) {
        if (table.hasCompositeKey()) {
            throw new UnsupportedOperationException("bulk select sql generation not supported for compound keys");
        }
        String pk = TableData.getColumnName(table.getPrimaryKey());
        if (this.options.arraySupport()) {
            return this.formatBulkSelectArrayUnnest(this.columns(table, true), table.getTableName(), pk, "?");
        }
        return this.formatBulkSelect(this.columns(table, true), table.getTableName(), pk, "?");
    }

    public String generateBulkSelectSqlTemplateNamed(TableData table) {
        if (table.hasCompositeKey()) {
            throw new UnsupportedOperationException("bulk select sql generation not supported for compound keys");
        }
        String pk = TableData.getColumnName(table.getPrimaryKey());
        if (this.options.arraySupport()) {
            return this.formatBulkSelectArrayUnnest(this.columns(table, true), table.getTableName(), pk, ":" + pk);
        }
        return this.formatBulkSelect(this.columns(table, true), table.getTableName(), pk, ":" + pk);
    }

    private String formatBulkSelect(String columns, String tableName, String primaryKey, String primaryKeyValue) {
        return String.format("SELECT %s FROM %s WHERE %s IN (%s)", columns, tableName, primaryKey, primaryKeyValue);
    }

    private String formatBulkSelectArrayUnnest(String columns, String tableName, String primaryKey, String primaryKeyValue) {
        return String.format("SELECT %s FROM %s WHERE %s IN (SELECT unnest(%s))", columns, tableName, primaryKey, primaryKeyValue);
    }

    public String generateInsertSqlTemplate(TableData table) {
        return this.generateInsertSqlTemplate(table, false);
    }

    public String generateInsertSqlTemplateNamed(TableData table) {
        return this.generateInsertSqlTemplateNamed(table, false);
    }

    public String generateInsertSqlTemplate(TableData table, boolean includePrimaryKey) {
        String columns = this.columns(table, includePrimaryKey);
        int numCols = includePrimaryKey ? table.getPrimaryKeys().size() + table.getColumns().size() : table.getColumns().size();
        return this.formatInsert(table.getTableName(), columns, this.columnsIndexParams(numCols));
    }

    public String generateInsertSqlTemplateNamed(TableData table, boolean includePrimaryKey) {
        String columns = this.columns(table, includePrimaryKey);
        String namedParams = this.columnsAsNamedParams(table, includePrimaryKey);
        return this.formatInsert(table.getTableName(), columns, namedParams);
    }

    private String formatInsert(String tableName, String columns, String values) {
        return String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, columns, values);
    }

    public String generateUpdateSqlTemplate(TableData table) {
        return this.formatUpdate(table.getTableName(), this.columnsWithIndexParams(table), this.primaryKeysWithIndexParams(table));
    }

    public String generateUpdateSqlTemplateNamed(TableData table) {
        return this.formatUpdate(table.getTableName(), this.columnsWithNamedParams(table), this.primaryKeysWithNamedParams(table));
    }

    private String formatUpdate(String tableName, String columnsAndValues, String conditions) {
        return String.format("UPDATE %s SET %s WHERE %s", tableName, columnsAndValues, conditions);
    }

    public String generateDeleteSqlTemplate(TableData table) {
        return this.formatDelete(table.getTableName(), this.primaryKeysWithIndexParams(table));
    }

    public String generateDeleteSqlTemplateNamed(TableData table) {
        return this.formatDelete(table.getTableName(), this.primaryKeysWithNamedParams(table));
    }

    private String formatDelete(String tableName, String conditions) {
        return String.format("DELETE FROM %s WHERE %s", tableName, conditions);
    }

    public String generateBulkDeleteSqlTemplate(TableData table) {
        if (table.hasCompositeKey()) {
            throw new UnsupportedOperationException("bulk delete sql generation not supported for compound keys");
        }
        String pk = TableData.getColumnName(table.getPrimaryKey());
        if (this.options.arraySupport()) {
            return this.formatBulkDeleteArrayUnnest(table.getTableName(), pk, "?");
        }
        return this.formatBulkDelete(table.getTableName(), pk, "?");
    }

    public String generateBulkDeleteSqlTemplateNamed(TableData table) {
        if (table.hasCompositeKey()) {
            throw new UnsupportedOperationException("bulk delete sql generation not supported for compound keys");
        }
        String pk = TableData.getColumnName(table.getPrimaryKey());
        if (this.options.arraySupport()) {
            return this.formatBulkDeleteArrayUnnest(table.getTableName(), pk, ":" + pk);
        }
        return this.formatBulkDelete(table.getTableName(), pk, ":" + pk);
    }

    private String formatBulkDelete(String tableName, String primaryKey, String primaryKeyValue) {
        return String.format("DELETE FROM %s WHERE %s IN (%s)", tableName, primaryKey, primaryKeyValue);
    }

    private String formatBulkDeleteArrayUnnest(String tableName, String primaryKey, String primaryKeyValue) {
        return String.format("DELETE FROM %s WHERE %s IN (SELECT unnest(%s))", tableName, primaryKey, primaryKeyValue);
    }

    public String generateCreateStatement(TableData table) {
        ArrayList<String> columns = new ArrayList<String>(table.getColumns().size() + table.getPrimaryKeys().size());
        for (Field field : table.getPrimaryKeys()) {
            columns.add(TableData.getColumnName(field) + " " + TypeMappers.getSqlType(field.getType()).toUpperCase() + " PRIMARY KEY");
        }
        for (Field field : table.getColumns()) {
            columns.add(TableData.getColumnName(field) + " " + TypeMappers.getSqlType(field.getType()).toUpperCase() + (field.getType().isPrimitive() ? " NOT NULL" : ""));
        }
        return this.formatCreate(table.getTableName(), columns);
    }

    private String formatCreate(String tableName, List<String> columns) {
        return String.format("CREATE TABLE %s (%s)", tableName, columns.stream().collect(COMMA_JOIN));
    }

    private String primaryKeysWithIndexParams(TableData table) {
        return table.getPrimaryKeys().stream().map(k -> TableData.getColumnName(k) + " = ?").collect(AND_JOIN);
    }

    private String primaryKeysWithNamedParams(TableData table) {
        return table.getPrimaryKeys().stream().map(k -> TableData.getColumnName(k) + " = :" + TableData.getColumnName(k)).collect(AND_JOIN);
    }

    private String columns(TableData table, boolean includePrimaryKeys) {
        String columns = table.getColumns().stream().map(TableData::getColumnName).collect(COMMA_JOIN);
        if (includePrimaryKeys) {
            return table.getPrimaryKeys().stream().map(TableData::getColumnName).collect(COMMA_JOIN) + ", " + columns;
        }
        return columns;
    }

    private String columnsAsNamedParams(TableData table, boolean includePrimaryKeys) {
        String columns = table.getColumns().stream().map(f -> ":" + TableData.getColumnName(f)).collect(COMMA_JOIN);
        if (includePrimaryKeys) {
            return table.getPrimaryKeys().stream().map(f -> ":" + TableData.getColumnName(f)).collect(COMMA_JOIN) + ", " + columns;
        }
        return columns;
    }

    private String columnsWithIndexParams(TableData table) {
        return table.getColumns().stream().map(f -> TableData.getColumnName(f) + " = ?").collect(COMMA_JOIN);
    }

    private String columnsWithNamedParams(TableData table) {
        return table.getColumns().stream().map(f -> TableData.getColumnName(f) + " = :" + TableData.getColumnName(f)).collect(COMMA_JOIN);
    }

    private String columnsIndexParams(int size) {
        return String.join((CharSequence)", ", Collections.nCopies(size, "?"));
    }
}

