/*
 * Decompiled with CFR 0.152.
 */
package io.github.yeagy.bss;

import io.github.yeagy.bss.BetterOptions;
import io.github.yeagy.bss.BetterPreparedStatement;
import io.github.yeagy.bss.BetterResultSet;
import io.github.yeagy.bss.BetterSqlException;
import io.github.yeagy.bss.BetterSqlGenerator;
import io.github.yeagy.bss.BetterSqlSupport;
import io.github.yeagy.bss.ResultMapping;
import io.github.yeagy.bss.StatementBinding;
import io.github.yeagy.bss.TableData;
import io.github.yeagy.bss.TypeMappers;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BetterSqlMapper {
    private final BetterSqlGenerator generator;
    private final BetterSqlSupport support;

    private BetterSqlMapper(BetterOptions options) {
        this.generator = BetterSqlGenerator.from(options);
        this.support = BetterSqlSupport.from(options);
    }

    public static BetterSqlMapper fromDefaults() {
        return BetterSqlMapper.from(BetterOptions.fromDefaults());
    }

    public static BetterSqlMapper from(BetterOptions options) {
        return new BetterSqlMapper(options);
    }

    public <T> T find(Connection connection, Object key, Class<T> clazz) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(key);
        Objects.requireNonNull(clazz);
        TableData tableData = TableData.from(clazz);
        if (tableData.hasCompositeKey()) {
            throw new BetterSqlException("method not supported for entities with composite keys. try the select builder");
        }
        String select = this.generator.generateSelectSqlTemplate(tableData);
        return (T)this.support.builder(select).bind(ps -> BetterSqlMapper.setParameter(ps, key, 1)).mapResult(rs -> BetterSqlMapper.createEntity(rs, tableData, clazz)).query(connection);
    }

    public <T> List<T> find(Connection connection, Collection<?> keys, Class<T> clazz) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(keys);
        Objects.requireNonNull(clazz);
        TableData tableData = TableData.from(clazz);
        if (tableData.hasCompositeKey()) {
            throw new BetterSqlException("method not supported for entities with composite keys. try the select builder");
        }
        String select = this.generator.generateBulkSelectSqlTemplate(tableData);
        return this.support.builder(select).bind(ps -> ps.setArray(1, keys)).mapResult(rs -> BetterSqlMapper.createEntity(rs, tableData, clazz)).queryList(connection);
    }

    public <T> T insert(Connection connection, T entity) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(entity);
        T result = null;
        TableData tableData = TableData.from(entity.getClass());
        List<FieldValue> primaryKeyValues = BetterSqlMapper.getPrimaryKeyValues(entity, tableData);
        String insert = this.generator.generateInsertSqlTemplate(tableData, !primaryKeyValues.isEmpty());
        try {
            BetterSqlSupport.BoundBuilder builder = this.support.builder(insert).bind(ps -> {
                int idx = 0;
                for (FieldValue primaryKeyValue : primaryKeyValues) {
                    BetterSqlMapper.setParameter(ps, primaryKeyValue.value, ++idx);
                }
                for (Field field : tableData.getColumns()) {
                    BetterSqlMapper.setParameter(ps, field, entity, ++idx);
                }
            });
            if (primaryKeyValues.isEmpty()) {
                List<FieldValue> generatedKeys;
                if (!tableData.hasCompositeKey()) {
                    Object generatedKey = builder.insert(connection);
                    generatedKeys = Collections.singletonList(new FieldValue(tableData.getPrimaryKey(), generatedKey));
                } else {
                    generatedKeys = builder.mapKey(rs -> {
                        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
                        for (Field field : tableData.getPrimaryKeys()) {
                            values.add(new FieldValue(field, rs.getObject(TableData.getColumnName(field))));
                        }
                        return values;
                    }).insert(connection);
                }
                if (!generatedKeys.isEmpty()) {
                    result = (T)BetterSqlMapper.constructNewInstance(entity.getClass());
                    for (FieldValue key : generatedKeys) {
                        key.field.set(result, key.value);
                    }
                    for (Field field : tableData.getColumns()) {
                        BetterSqlMapper.copyField(field, result, entity);
                    }
                }
            } else {
                builder.update(connection);
                result = entity;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BetterSqlException(e);
        }
        return result;
    }

    public void update(Connection connection, Object entity) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(entity);
        TableData tableData = TableData.from(entity.getClass());
        List<FieldValue> primaryKeyValues = BetterSqlMapper.getPrimaryKeyValues(entity, tableData);
        if (primaryKeyValues.isEmpty()) {
            throw new BetterSqlException("primary key(s) cannot be null");
        }
        String update = this.generator.generateUpdateSqlTemplate(tableData);
        int count = this.support.update(connection, update, ps -> {
            int idx = 0;
            for (Field field : tableData.getColumns()) {
                BetterSqlMapper.setParameter(ps, field, entity, ++idx);
            }
            for (FieldValue primaryKeyValue : primaryKeyValues) {
                BetterSqlMapper.setParameter(ps, primaryKeyValue.value, ++idx);
            }
        });
        if (count != 1) {
            String pks = primaryKeyValues.stream().map(pk -> TableData.getColumnName(((FieldValue)pk).field) + ": " + ((FieldValue)pk).value).collect(Collectors.joining(", "));
            throw new BetterSqlException(String.format("%s rows updated. 1 row expected. [table %s] primary key(s) %s", count, tableData.getTableName(), pks));
        }
    }

    public void delete(Connection connection, Object entity) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(entity);
        TableData tableData = TableData.from(entity.getClass());
        List<FieldValue> primaryKeyValues = BetterSqlMapper.getPrimaryKeyValues(entity, tableData);
        if (primaryKeyValues.isEmpty()) {
            throw new BetterSqlException("primary key(s) cannot be null");
        }
        String delete = this.generator.generateDeleteSqlTemplate(tableData);
        int count = this.support.update(connection, delete, ps -> {
            int idx = 0;
            for (FieldValue pk : primaryKeyValues) {
                BetterSqlMapper.setParameter(ps, pk.value, ++idx);
            }
        });
        if (count != 1) {
            String pks = primaryKeyValues.stream().map(pk -> TableData.getColumnName(((FieldValue)pk).field) + ": " + ((FieldValue)pk).value).collect(Collectors.joining(", "));
            throw new BetterSqlException(String.format("%s rows deleted. 1 row expected. [table %s] primary key(s) %s", count, tableData.getTableName(), pks));
        }
    }

    public int delete(Connection connection, Object key, Class<?> clazz) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(key);
        Objects.requireNonNull(clazz);
        TableData tableData = TableData.from(clazz);
        if (tableData.hasCompositeKey()) {
            throw new BetterSqlException("method not supported for entities with composite keys");
        }
        String delete = this.generator.generateDeleteSqlTemplate(tableData);
        return this.support.update(connection, delete, ps -> BetterSqlMapper.setParameter(ps, key, 1));
    }

    public int delete(Connection connection, Collection<?> keys, Class<?> clazz) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(keys);
        Objects.requireNonNull(clazz);
        TableData tableData = TableData.from(clazz);
        if (tableData.hasCompositeKey()) {
            throw new BetterSqlException("method not supported for entities with composite keys");
        }
        String delete = this.generator.generateBulkDeleteSqlTemplate(tableData);
        return this.support.update(connection, delete, ps -> ps.setArray(1, keys));
    }

    public <T> SelectBuilder<T> select(String sql, Class<T> clazz) {
        return new SelectBuilder(sql, clazz);
    }

    private static List<FieldValue> getPrimaryKeyValues(Object entity, TableData tableData) {
        try {
            if (!tableData.hasCompositeKey()) {
                Field field = tableData.getPrimaryKey();
                Object value = field.get(entity);
                return value != null ? Collections.singletonList(new FieldValue(field, value)) : Collections.EMPTY_LIST;
            }
            ArrayList<FieldValue> values = new ArrayList<FieldValue>();
            for (Field field : tableData.getPrimaryKeys()) {
                Object value = field.get(entity);
                if (value == null) continue;
                values.add(new FieldValue(field, value));
            }
            if (!values.isEmpty() && values.size() != tableData.getPrimaryKeys().size()) {
                throw new BetterSqlException("composite keys must either be all null or all non-null");
            }
            return values;
        }
        catch (IllegalAccessException e) {
            throw new BetterSqlException(e);
        }
    }

    private static void copyField(Field field, Object target, Object origin) throws IllegalAccessException {
        TypeMappers.FieldCopier copier = TypeMappers.getFieldCopier(field.getType());
        if (copier != null) {
            copier.copy(field, target, origin);
        } else {
            field.set(target, field.get(origin));
        }
    }

    private static void setParameter(BetterPreparedStatement ps, Object value, int idx) throws SQLException {
        TypeMappers.ObjectParamSetter setter = TypeMappers.getObjectParamSetter(value.getClass());
        if (setter != null) {
            setter.set(ps, value, idx);
        } else if (value.getClass().isEnum()) {
            ps.setString(idx, value.toString());
        } else {
            ps.setObject(idx, value);
        }
    }

    private static void setParameter(BetterPreparedStatement ps, Field field, Object target, int idx) throws IllegalAccessException, SQLException {
        TypeMappers.FieldParamSetter setter = TypeMappers.getFieldParamSetter(field.getType());
        if (setter != null) {
            setter.set(ps, field, target, idx);
        } else if (field.getType().isEnum()) {
            ps.setString(idx, field.get(target).toString());
        } else {
            ps.setObject(idx, field.get(target));
        }
    }

    private static void setField(BetterResultSet rs, Field field, Object target, Integer idx) throws SQLException, IllegalAccessException {
        TypeMappers.FieldResultWriter writer = TypeMappers.getFieldResultWriter(field.getType());
        if (writer != null) {
            writer.write(rs, field, target, idx);
        } else if (field.getType().isEnum()) {
            String s = idx == null ? rs.getString(TableData.getColumnName(field)) : rs.getString(idx);
            field.set(target, Enum.valueOf(field.getType(), s));
        } else {
            Object v = idx == null ? rs.getObject(TableData.getColumnName(field)) : rs.getObject(idx);
            field.set(target, v);
        }
    }

    private static <T> T createEntity(BetterResultSet rs, TableData tableData, Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, SQLException {
        T result = BetterSqlMapper.constructNewInstance(clazz);
        for (Field field : tableData.getPrimaryKeys()) {
            BetterSqlMapper.setField(rs, field, result, null);
        }
        for (Field field : tableData.getColumns()) {
            BetterSqlMapper.setField(rs, field, result, null);
        }
        return result;
    }

    private static <T> T constructNewInstance(Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        if (constructor == null) {
            throw new BetterSqlException("zero argument constructor not found on class " + clazz.getSimpleName());
        }
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(new Object[0]);
    }

    private static final class FieldValue {
        private final Field field;
        private final Object value;

        FieldValue(Field field, Object value) {
            this.field = field;
            this.value = value;
        }
    }

    public final class SelectBuilder<T> {
        private final String sql;
        private final Class<T> clazz;
        private StatementBinding statementBinding = null;

        private SelectBuilder(String sql, Class<T> clazz) {
            Objects.requireNonNull(sql);
            Objects.requireNonNull(clazz);
            this.sql = sql;
            this.clazz = clazz;
        }

        public SelectBuilder<T> bind(StatementBinding statementBinding) {
            Objects.requireNonNull(statementBinding);
            this.statementBinding = statementBinding;
            return this;
        }

        public T one(Connection connection) {
            return this.prepareBuilder(connection).query(connection);
        }

        public List<T> list(Connection connection) {
            return this.prepareBuilder(connection).queryList(connection);
        }

        public <K> Map<K, T> map(Connection connection, ResultMapping<K> keyMapping) {
            return this.prepareBuilder(connection).mapKey(keyMapping).queryMap(connection);
        }

        public <K> Map<K, List<T>> multiMap(Connection connection, ResultMapping<K> keyMapping) {
            return this.prepareBuilder(connection).mapKey(keyMapping).queryMultiMap(connection);
        }

        private BetterSqlSupport.BoundResultBuilder<T> prepareBuilder(Connection connection) {
            Objects.requireNonNull(connection);
            TableData tableData = TableData.from(this.clazz);
            return BetterSqlMapper.this.support.builder(this.sql).bind(this.statementBinding).mapResult(rs -> BetterSqlMapper.createEntity(rs, tableData, this.clazz));
        }
    }
}

