/*
 * Decompiled with CFR 0.152.
 */
package io.github.yeagy.bss;

import io.github.yeagy.bss.BetterOptions;
import io.github.yeagy.bss.BetterPreparedStatement;
import io.github.yeagy.bss.BetterResultSet;
import io.github.yeagy.bss.BetterSqlException;
import io.github.yeagy.bss.MetadataTranslatingResultSet;
import io.github.yeagy.bss.ResultMapping;
import io.github.yeagy.bss.StatementBinding;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BetterSqlSupport {
    private final BetterOptions options;

    private BetterSqlSupport(BetterOptions options) {
        this.options = options;
    }

    public static BetterSqlSupport fromDefaults() {
        return BetterSqlSupport.from(BetterOptions.fromDefaults());
    }

    public static BetterSqlSupport from(BetterOptions options) {
        return new BetterSqlSupport(options);
    }

    public <T> T query(Connection connection, String sql, StatementBinding binding, ResultMapping<T> mapping) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sql);
        Objects.requireNonNull(mapping);
        T entity = null;
        try (BetterPreparedStatement ps = BetterPreparedStatement.create(connection, sql, false, !this.options.arraySupport());){
            if (binding != null) {
                binding.bind(ps);
            }
            try (BetterResultSet rs = BetterResultSet.from(ps.executeQuery());){
                if (rs.next()) {
                    entity = mapping.map(rs);
                }
            }
        }
        catch (Exception e) {
            throw new BetterSqlException(e);
        }
        return entity;
    }

    public <T> List<T> queryList(Connection connection, String sql, StatementBinding binding, ResultMapping<T> mapping) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sql);
        Objects.requireNonNull(mapping);
        ArrayList<T> entities = new ArrayList<T>();
        try (BetterPreparedStatement ps = BetterPreparedStatement.create(connection, sql, false, !this.options.arraySupport());){
            if (binding != null) {
                binding.bind(ps);
            }
            try (BetterResultSet rs = BetterResultSet.from(ps.executeQuery());){
                while (rs.next()) {
                    entities.add(mapping.map(rs));
                }
            }
        }
        catch (Exception e) {
            throw new BetterSqlException(e);
        }
        return Collections.unmodifiableList(entities);
    }

    public <K, T> Map<K, T> queryMap(Connection connection, String sql, StatementBinding binding, ResultMapping<T> resultMapping, ResultMapping<K> keyMapping) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sql);
        Objects.requireNonNull(resultMapping);
        Objects.requireNonNull(keyMapping);
        HashMap<K, T> map = new HashMap<K, T>();
        try (BetterPreparedStatement ps = BetterPreparedStatement.create(connection, sql, false, !this.options.arraySupport());){
            if (binding != null) {
                binding.bind(ps);
            }
            try (BetterResultSet rs = BetterResultSet.from(ps.executeQuery());){
                while (rs.next()) {
                    map.put(keyMapping.map(rs), resultMapping.map(rs));
                }
            }
        }
        catch (Exception e) {
            throw new BetterSqlException(e);
        }
        return Collections.unmodifiableMap(map);
    }

    public <K, T> Map<K, List<T>> queryMultiMap(Connection connection, String sql, StatementBinding binding, ResultMapping<T> resultMapping, ResultMapping<K> keyMapping) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sql);
        Objects.requireNonNull(resultMapping);
        Objects.requireNonNull(keyMapping);
        HashMap<Object, List> mmap = new HashMap<Object, List>();
        try (BetterPreparedStatement ps = BetterPreparedStatement.create(connection, sql, false, !this.options.arraySupport());){
            if (binding != null) {
                binding.bind(ps);
            }
            try (BetterResultSet rs = BetterResultSet.from(ps.executeQuery());){
                while (rs.next()) {
                    mmap.computeIfAbsent(keyMapping.map(rs), k -> new ArrayList()).add(resultMapping.map(rs));
                }
            }
        }
        catch (Exception e) {
            throw new BetterSqlException(e);
        }
        return Collections.unmodifiableMap(mmap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int update(Connection connection, String sql, StatementBinding binding) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sql);
        try (BetterPreparedStatement ps = BetterPreparedStatement.create(connection, sql, false, !this.options.arraySupport());){
            if (binding != null) {
                binding.bind(ps);
            }
            int n = ps.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new BetterSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <K> K insert(Connection connection, String sql, StatementBinding binding, ResultMapping<K> generatedKeyMapping) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sql);
        try (BetterPreparedStatement ps = BetterPreparedStatement.create(connection, sql, true, !this.options.arraySupport());){
            if (binding != null) {
                binding.bind(ps);
            }
            ps.executeUpdate();
            try (MetadataTranslatingResultSet rs = MetadataTranslatingResultSet.fromGeneratedKeys(ps);){
                if (!rs.next()) return null;
                K k = generatedKeyMapping.map(rs);
                return k;
            }
        }
        catch (Exception e) {
            throw new BetterSqlException(e);
        }
    }

    public <K> K insert(Connection connection, String sql, StatementBinding binding) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sql);
        Object key = null;
        try (BetterPreparedStatement ps = BetterPreparedStatement.create(connection, sql, true, !this.options.arraySupport());){
            if (binding != null) {
                binding.bind(ps);
            }
            ps.executeUpdate();
            try (BetterResultSet rs = BetterResultSet.from(ps.getGeneratedKeys());){
                if (rs.next()) {
                    key = rs.getObject(1);
                }
            }
        }
        catch (Exception e) {
            throw new BetterSqlException(e);
        }
        return (K)key;
    }

    public Builder builder(String sql) {
        return new Builder(sql);
    }

    public final class BoundKeyedResultBuilder<K, T> {
        private final String sql;
        private final StatementBinding statementBinding;
        private final ResultMapping<T> resultMapping;
        private final ResultMapping<K> keyMapping;

        private BoundKeyedResultBuilder(String sql, StatementBinding statementBinding, ResultMapping<T> resultMapping, ResultMapping<K> keyMapping) {
            this.sql = sql;
            this.statementBinding = statementBinding;
            this.resultMapping = resultMapping;
            this.keyMapping = keyMapping;
        }

        public Map<K, T> queryMap(Connection connection) {
            return BetterSqlSupport.this.queryMap(connection, this.sql, this.statementBinding, this.resultMapping, this.keyMapping);
        }

        public Map<K, List<T>> queryMultiMap(Connection connection) {
            return BetterSqlSupport.this.queryMultiMap(connection, this.sql, this.statementBinding, this.resultMapping, this.keyMapping);
        }
    }

    public final class KeyedResultBuilder<K, T> {
        private final String sql;
        private final ResultMapping<T> resultMapping;
        private final ResultMapping<K> keyMapping;

        private KeyedResultBuilder(String sql, ResultMapping<T> resultMapping, ResultMapping<K> keyMapping) {
            this.sql = sql;
            this.resultMapping = resultMapping;
            this.keyMapping = keyMapping;
        }

        public Map<K, T> queryMap(Connection connection) {
            return BetterSqlSupport.this.queryMap(connection, this.sql, null, this.resultMapping, this.keyMapping);
        }

        public Map<K, List<T>> queryMultiMap(Connection connection) {
            return BetterSqlSupport.this.queryMultiMap(connection, this.sql, null, this.resultMapping, this.keyMapping);
        }

        public BoundKeyedResultBuilder<K, T> bind(StatementBinding statementBinding) {
            return new BoundKeyedResultBuilder(this.sql, statementBinding, this.resultMapping, this.keyMapping);
        }
    }

    public final class BoundResultBuilder<T> {
        private final String sql;
        private final StatementBinding statementBinding;
        private final ResultMapping<T> resultMapping;

        private BoundResultBuilder(String sql, StatementBinding statementBinding, ResultMapping<T> resultMapping) {
            this.sql = sql;
            this.statementBinding = statementBinding;
            this.resultMapping = resultMapping;
        }

        public T query(Connection connection) {
            return BetterSqlSupport.this.query(connection, this.sql, this.statementBinding, this.resultMapping);
        }

        public List<T> queryList(Connection connection) {
            return BetterSqlSupport.this.queryList(connection, this.sql, this.statementBinding, this.resultMapping);
        }

        public <K> BoundKeyedResultBuilder<K, T> mapKey(ResultMapping<K> keyMapping) {
            return new BoundKeyedResultBuilder(this.sql, this.statementBinding, this.resultMapping, keyMapping);
        }
    }

    public final class ResultBuilder<T> {
        private final String sql;
        private final ResultMapping<T> resultMapping;

        private ResultBuilder(String sql, ResultMapping<T> resultMapping) {
            this.sql = sql;
            this.resultMapping = resultMapping;
        }

        public T query(Connection connection) {
            return BetterSqlSupport.this.query(connection, this.sql, null, this.resultMapping);
        }

        public List<T> queryList(Connection connection) {
            return BetterSqlSupport.this.queryList(connection, this.sql, null, this.resultMapping);
        }

        public BoundResultBuilder<T> bind(StatementBinding statementBinding) {
            return new BoundResultBuilder(this.sql, statementBinding, this.resultMapping);
        }

        public <K> KeyedResultBuilder<K, T> mapKey(ResultMapping<K> keyMapping) {
            return new KeyedResultBuilder(this.sql, this.resultMapping, keyMapping);
        }
    }

    public final class BoundKeyedBuilder<K> {
        private final String sql;
        private final StatementBinding statementBinding;
        private final ResultMapping<K> keyMapping;

        public BoundKeyedBuilder(String sql, StatementBinding statementBinding, ResultMapping<K> keyMapping) {
            this.sql = sql;
            this.statementBinding = statementBinding;
            this.keyMapping = keyMapping;
        }

        public K insert(Connection connection) {
            return BetterSqlSupport.this.insert(connection, this.sql, this.statementBinding, this.keyMapping);
        }

        public <T> BoundKeyedResultBuilder<K, T> mapResult(ResultMapping<T> resultMapping) {
            return new BoundKeyedResultBuilder(this.sql, this.statementBinding, resultMapping, this.keyMapping);
        }
    }

    public final class KeyedBuilder<K> {
        private final String sql;
        private final ResultMapping<K> keyMapping;

        public KeyedBuilder(String sql, ResultMapping<K> keyMapping) {
            this.sql = sql;
            this.keyMapping = keyMapping;
        }

        public K insert(Connection connection) {
            return BetterSqlSupport.this.insert(connection, this.sql, null, this.keyMapping);
        }

        public BoundKeyedBuilder<K> bind(StatementBinding statementBinding) {
            return new BoundKeyedBuilder<K>(this.sql, statementBinding, this.keyMapping);
        }

        public <T> KeyedResultBuilder<K, T> mapResult(ResultMapping<T> resultMapping) {
            return new KeyedResultBuilder(this.sql, resultMapping, this.keyMapping);
        }
    }

    public final class BoundBuilder {
        private final String sql;
        private final StatementBinding statementBinding;

        private BoundBuilder(String sql, StatementBinding statementBinding) {
            this.sql = sql;
            this.statementBinding = statementBinding;
        }

        public int update(Connection connection) {
            return BetterSqlSupport.this.update(connection, this.sql, this.statementBinding);
        }

        public <K> K insert(Connection connection) {
            return BetterSqlSupport.this.insert(connection, this.sql, this.statementBinding);
        }

        public <T> BoundResultBuilder<T> mapResult(ResultMapping<T> resultMapping) {
            return new BoundResultBuilder(this.sql, this.statementBinding, resultMapping);
        }

        public <K> BoundKeyedBuilder<K> mapKey(ResultMapping<K> keyMapping) {
            return new BoundKeyedBuilder<K>(this.sql, this.statementBinding, keyMapping);
        }
    }

    public final class Builder {
        private final String sql;

        private Builder(String sql) {
            this.sql = sql;
        }

        public int update(Connection connection) {
            return BetterSqlSupport.this.update(connection, this.sql, null);
        }

        public <K> K insert(Connection connection) {
            return BetterSqlSupport.this.insert(connection, this.sql, null);
        }

        public BoundBuilder bind(StatementBinding statementBinding) {
            return new BoundBuilder(this.sql, statementBinding);
        }

        public <T> ResultBuilder<T> mapResult(ResultMapping<T> resultMapping) {
            return new ResultBuilder(this.sql, resultMapping);
        }

        public <K> KeyedBuilder<K> mapKey(ResultMapping<K> keyMapping) {
            return new KeyedBuilder<K>(this.sql, keyMapping);
        }
    }
}

