/*
 * Decompiled with CFR 0.152.
 */
package io.github.yeagy.bss;

import io.github.yeagy.bss.BetterSqlException;
import io.github.yeagy.bss.ConnectionSupplier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

public final class BetterSqlTransaction {
    private BetterSqlTransaction() {
    }

    public static <T> ReturningTransaction<T> returning(TransactionTransformer<T> transformer) {
        return BetterSqlTransaction.returning(null, transformer);
    }

    public static <T> ReturningTransaction<T> returning(Isolation isolation, TransactionTransformer<T> transformer) {
        Objects.requireNonNull(transformer);
        return new ReturningTransaction<T>(transformer, isolation);
    }

    public static VoidTransaction with(TransactionConsumer consumer) {
        return BetterSqlTransaction.with(null, consumer);
    }

    public static VoidTransaction with(Isolation isolation, TransactionConsumer consumer) {
        Objects.requireNonNull(consumer);
        return new VoidTransaction(consumer, isolation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static <T> T executeInternalChecked(Connection connection, TransactionTransformer<T> transformer, Isolation isolation) throws SQLException {
        SQLException caught;
        T returning;
        block24: {
            int iso;
            Objects.requireNonNull(connection);
            if (!connection.getAutoCommit()) {
                throw new SQLException("transaction on connection already started!");
            }
            Integer previousIsolation = null;
            if (isolation != null && (iso = connection.getTransactionIsolation()) != isolation.isolationLevel) {
                previousIsolation = iso;
                connection.setTransactionIsolation(isolation.isolationLevel);
            }
            returning = null;
            caught = null;
            connection.setAutoCommit(false);
            returning = transformer.transform(connection);
            connection.commit();
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                caught = BetterSqlTransaction.chainException(caught, e);
            }
            if (previousIsolation != null) {
                try {
                    connection.setTransactionIsolation(previousIsolation);
                }
                catch (SQLException e) {
                    caught = BetterSqlTransaction.chainException(caught, e);
                }
            }
            break block24;
            catch (Exception e) {
                try {
                    caught = e instanceof SQLException ? (SQLException)e : new SQLException("uncaught exception in transaction", e);
                    try {
                        connection.rollback();
                    }
                    catch (SQLException re) {
                        caught = BetterSqlTransaction.chainException(caught, re);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (SQLException e2) {
                        caught = BetterSqlTransaction.chainException(caught, e2);
                    }
                    if (previousIsolation != null) {
                        try {
                            connection.setTransactionIsolation(previousIsolation);
                        }
                        catch (SQLException e3) {
                            caught = BetterSqlTransaction.chainException(caught, e3);
                        }
                    }
                    throw throwable;
                }
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException e4) {
                    caught = BetterSqlTransaction.chainException(caught, e4);
                }
                if (previousIsolation != null) {
                    try {
                        connection.setTransactionIsolation(previousIsolation);
                    }
                    catch (SQLException e5) {
                        caught = BetterSqlTransaction.chainException(caught, e5);
                    }
                }
            }
        }
        if (caught != null) {
            throw caught;
        }
        return returning;
    }

    private static <T> T executeInternal(Connection connection, TransactionTransformer<T> transformer, Isolation isolation) {
        try {
            return BetterSqlTransaction.executeInternalChecked(connection, transformer, isolation);
        }
        catch (SQLException e) {
            throw new BetterSqlException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T executeInternal(ConnectionSupplier supplier, TransactionTransformer<T> transformer, Isolation isolation) {
        Objects.requireNonNull(supplier);
        Connection connection = null;
        T returning = null;
        SQLException caught = null;
        try {
            connection = supplier.get();
            returning = BetterSqlTransaction.executeInternalChecked(connection, transformer, isolation);
        }
        catch (SQLException e) {
            caught = e;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    caught = BetterSqlTransaction.chainException(caught, e);
                }
            }
        }
        if (caught != null) {
            throw new BetterSqlException(caught);
        }
        return returning;
    }

    private static SQLException chainException(SQLException last, SQLException next) {
        if (last != null) {
            last.setNextException(next);
            return last;
        }
        return next;
    }

    @FunctionalInterface
    public static interface TransactionTransformer<T> {
        public T transform(Connection var1) throws Exception;
    }

    @FunctionalInterface
    public static interface TransactionConsumer
    extends TransactionTransformer<Void> {
        public void consume(Connection var1) throws Exception;

        @Override
        default public Void transform(Connection connection) throws Exception {
            this.consume(connection);
            return null;
        }
    }

    public static final class ReturningTransaction<T> {
        private final TransactionTransformer<T> transformer;
        private final Isolation isolation;

        public ReturningTransaction(TransactionTransformer<T> transformer, Isolation isolation) {
            this.transformer = transformer;
            this.isolation = isolation;
        }

        public T execute(Connection connection) {
            return (T)BetterSqlTransaction.executeInternal(connection, this.transformer, this.isolation);
        }

        public T execute(ConnectionSupplier supplier) {
            return (T)BetterSqlTransaction.executeInternal(supplier, this.transformer, this.isolation);
        }
    }

    public static final class VoidTransaction {
        private final TransactionConsumer consumer;
        private final Isolation isolation;

        private VoidTransaction(TransactionConsumer consumer, Isolation isolation) {
            this.consumer = consumer;
            this.isolation = isolation;
        }

        public void execute(Connection connection) {
            BetterSqlTransaction.executeInternal(connection, this.consumer, this.isolation);
        }

        public void execute(ConnectionSupplier supplier) {
            BetterSqlTransaction.executeInternal(supplier, this.consumer, this.isolation);
        }
    }

    public static enum Isolation {
        READ_UNCOMMITTED(1),
        READ_COMMITTED(2),
        REPEATABLE_READ(4),
        SERIALIZABLE(8);

        private final int isolationLevel;

        private Isolation(int isolationLevel) {
            this.isolationLevel = isolationLevel;
        }
    }
}

