/*
 * Decompiled with CFR 0.152.
 */
package io.github.yeagy.bss;

import io.github.yeagy.bss.BetterResultSetImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

final class MetadataTranslatingResultSet
extends BetterResultSetImpl {
    private final Map<String, Integer> metadataColumnNames;

    private MetadataTranslatingResultSet(ResultSet rs, Map<String, Integer> metadataColumnNames) {
        super(rs);
        this.metadataColumnNames = metadataColumnNames;
    }

    static MetadataTranslatingResultSet fromGeneratedKeys(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.getGeneratedKeys();
        ResultSetMetaData metaData = rs.getMetaData();
        HashMap<String, Integer> metadataColumnNames = new HashMap<String, Integer>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            metadataColumnNames.put(metaData.getColumnLabel(i), i);
        }
        return new MetadataTranslatingResultSet(rs, metadataColumnNames);
    }

    private int columnIndex(String columnLabel) {
        Integer index = this.metadataColumnNames.get(columnLabel);
        if (index == null) {
            throw new IllegalArgumentException("metadata contained no index for column label: " + columnLabel);
        }
        return index;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return super.getString(this.columnIndex(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return super.getBoolean(this.columnIndex(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return super.getByte(this.columnIndex(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return super.getShort(this.columnIndex(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return super.getInt(this.columnIndex(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return super.getLong(this.columnIndex(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return super.getFloat(this.columnIndex(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return super.getDouble(this.columnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return super.getBigDecimal(this.columnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return super.getBytes(this.columnIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return super.getDate(this.columnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return super.getTime(this.columnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return super.getTimestamp(this.columnIndex(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return super.getAsciiStream(this.columnIndex(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return super.getUnicodeStream(this.columnIndex(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return super.getBinaryStream(this.columnIndex(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return super.getObject(this.columnIndex(columnLabel));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return super.getCharacterStream(this.columnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return super.getBigDecimal(this.columnIndex(columnLabel));
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        super.updateNull(this.columnIndex(columnLabel));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        super.updateBoolean(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        super.updateByte(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        super.updateShort(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        super.updateInt(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        super.updateLong(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        super.updateFloat(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        super.updateDouble(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        super.updateBigDecimal(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        super.updateString(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        super.updateBytes(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        super.updateDate(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        super.updateTime(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        super.updateTimestamp(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        super.updateAsciiStream(this.columnIndex(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        super.updateBinaryStream(this.columnIndex(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        super.updateCharacterStream(this.columnIndex(columnLabel), reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        super.updateObject(this.columnIndex(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        super.updateObject(this.columnIndex(columnLabel), x);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return super.getRef(this.columnIndex(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return super.getObject(this.columnIndex(columnLabel), map);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return super.getBlob(this.columnIndex(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return super.getClob(this.columnIndex(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return super.getArray(this.columnIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return super.getDate(this.columnIndex(columnLabel), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return super.getTime(this.columnIndex(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return super.getTimestamp(this.columnIndex(columnLabel), cal);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return super.getURL(this.columnIndex(columnLabel));
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        super.updateRef(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        super.updateBlob(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        super.updateClob(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        super.updateArray(this.columnIndex(columnLabel), x);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return super.getRowId(this.columnIndex(columnLabel));
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        super.updateRowId(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        super.updateNString(this.columnIndex(columnLabel), nString);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        super.updateNClob(this.columnIndex(columnLabel), nClob);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return super.getNClob(this.columnIndex(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return super.getSQLXML(this.columnIndex(columnLabel));
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        super.updateSQLXML(this.columnIndex(columnLabel), xmlObject);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return super.getNString(this.columnIndex(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return super.getNCharacterStream(this.columnIndex(columnLabel));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        super.updateNCharacterStream(this.columnIndex(columnLabel), reader, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        super.updateAsciiStream(this.columnIndex(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        super.updateBinaryStream(this.columnIndex(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        super.updateCharacterStream(this.columnIndex(columnLabel), reader, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        super.updateBlob(this.columnIndex(columnLabel), inputStream, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        super.updateClob(this.columnIndex(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        super.updateNClob(this.columnIndex(columnLabel), reader, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        super.updateNCharacterStream(this.columnIndex(columnLabel), reader);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        super.updateAsciiStream(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        super.updateBinaryStream(this.columnIndex(columnLabel), x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        super.updateCharacterStream(this.columnIndex(columnLabel), reader);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        super.updateBlob(this.columnIndex(columnLabel), inputStream);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        super.updateClob(this.columnIndex(columnLabel), reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        super.updateNClob(this.columnIndex(columnLabel), reader);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return super.getObject(this.columnIndex(columnLabel), type);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        super.updateObject(this.columnIndex(columnLabel), x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        super.updateObject(this.columnIndex(columnLabel), x, targetSqlType);
    }
}

