/*
 * Decompiled with CFR 0.152.
 */
package io.github.yeagy.bss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class NamedParameters {
    private final String unprocessedSql;
    private final String processedSql;
    private final Map<String, List<Integer>> indices;

    private NamedParameters(String unprocessedSql, String processedSql, Map<String, List<Integer>> indices) {
        this.unprocessedSql = unprocessedSql;
        this.processedSql = processedSql;
        this.indices = indices;
    }

    String getUnprocessedSql() {
        return this.unprocessedSql;
    }

    String getProcessedSql() {
        return this.processedSql;
    }

    List<Integer> getIndices(String namedParameter) {
        return this.indices.get(namedParameter);
    }

    static NamedParameters from(String sql) {
        if (!sql.contains("?") && sql.contains(":")) {
            StringBuilder processedSql = new StringBuilder(sql.length());
            HashMap<String, List<Integer>> indices = new HashMap<String, List<Integer>>();
            int idx = 1;
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            for (int i = 0; i < sql.length(); ++i) {
                int c = sql.charAt(i);
                if (inSingleQuote) {
                    if (c == 39) {
                        inSingleQuote = false;
                    }
                } else if (inDoubleQuote) {
                    if (c == 34) {
                        inDoubleQuote = false;
                    }
                } else if (c == 39) {
                    inSingleQuote = true;
                } else if (c == 34) {
                    inDoubleQuote = true;
                } else if (c == 58 && i + 1 < sql.length() && Character.isJavaIdentifierStart(sql.charAt(i + 1))) {
                    int j;
                    for (j = i + 2; j < sql.length() && Character.isJavaIdentifierPart(sql.charAt(j)); ++j) {
                    }
                    String name = sql.substring(i + 1, j);
                    c = 63;
                    i += name.length();
                    indices.computeIfAbsent(name, k -> new ArrayList()).add(idx++);
                }
                processedSql.append((char)c);
            }
            if (!indices.isEmpty()) {
                return new NamedParameters(sql, processedSql.toString(), indices);
            }
        }
        return null;
    }
}

