/*
 * Decompiled with CFR 0.152.
 */
package io.github.yeagy.bss;

import io.github.yeagy.bss.BetterSqlException;
import io.github.yeagy.bss.Column;
import io.github.yeagy.bss.Id;
import io.github.yeagy.bss.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TableData {
    private final String tableName;
    private final List<Field> primaryKeys;
    private final List<Field> columns;
    private static final Map<Class<?>, TableData> METADATA_CACHE = new HashMap();

    private TableData(String tableName, List<Field> primaryKeys, List<Field> columns) {
        this.tableName = tableName;
        this.primaryKeys = Collections.unmodifiableList(primaryKeys);
        this.columns = Collections.unmodifiableList(columns);
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Field> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<Field> getColumns() {
        return this.columns;
    }

    public boolean hasCompositeKey() {
        return this.primaryKeys.size() > 1;
    }

    public Field getPrimaryKey() {
        if (this.primaryKeys.size() != 1) {
            throw new BetterSqlException(String.format("table %s has %s primary keys!", this.tableName, this.primaryKeys.size()));
        }
        return this.primaryKeys.get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableData tableData = (TableData)o;
        return Objects.equals(this.tableName, tableData.tableName) && Objects.equals(this.primaryKeys, tableData.primaryKeys) && Objects.equals(this.columns, tableData.columns);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.primaryKeys, this.columns);
    }

    public static TableData from(Class<?> clazz) {
        return TableData.from(clazz, true);
    }

    public static TableData from(Class<?> clazz, boolean forceAccessible) {
        TableData tableData = METADATA_CACHE.get(clazz);
        if (tableData == null) {
            String tableName = TableData.getTableName(clazz);
            Field[] fields = clazz.getDeclaredFields();
            ArrayList<Field> columns = new ArrayList<Field>(fields.length - 1);
            ArrayList<Field> primaryKeys = new ArrayList<Field>(2);
            for (Field field : fields) {
                if (Modifier.isTransient(field.getModifiers())) continue;
                if (field.isAnnotationPresent(Id.class)) {
                    primaryKeys.add(field);
                } else {
                    columns.add(field);
                }
                if (!forceAccessible || field.isAccessible()) continue;
                field.setAccessible(true);
            }
            if (primaryKeys.isEmpty()) {
                throw new BetterSqlException("primary key annotation(s) not found on class " + clazz.getSimpleName());
            }
            tableData = new TableData(tableName, primaryKeys, Collections.unmodifiableList(columns));
            METADATA_CACHE.put(clazz, tableData);
        }
        return tableData;
    }

    public static String getColumnName(Field field) {
        Column annotation = field.getDeclaredAnnotation(Column.class);
        return TableData.camelToSnake(annotation == null ? field.getName() : annotation.name());
    }

    public static String getTableName(Class<?> clazz) {
        Table annotation = clazz.getDeclaredAnnotation(Table.class);
        if (annotation != null) {
            if (!annotation.schema().isEmpty()) {
                if (!annotation.name().isEmpty()) {
                    return annotation.schema() + "." + annotation.name();
                }
                return annotation.schema() + "." + TableData.camelToSnake(clazz.getSimpleName());
            }
            if (!annotation.name().isEmpty()) {
                return annotation.name();
            }
        }
        return TableData.camelToSnake(clazz.getSimpleName());
    }

    private static String camelToSnake(String camel) {
        StringBuilder sb = new StringBuilder();
        boolean prevLower = false;
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                if (prevLower) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                prevLower = false;
                continue;
            }
            sb.append(c);
            prevLower = true;
        }
        return sb.toString();
    }
}

