/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.parser;

import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.LogUtils;
import io.github.yedaxia.apidocs.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PlayRoutesParser {
    private String routeFile;
    private String javaSrcPath;
    private List<RouteNode> routeNodeList = new ArrayList<RouteNode>();
    public static PlayRoutesParser INSTANCE = new PlayRoutesParser();

    private PlayRoutesParser() {
        this.routeFile = DocContext.getProjectPath().concat("conf/routes");
        this.javaSrcPath = DocContext.getJavaSrcPaths().get(0);
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        BufferedReader reader = null;
        try {
            String lineText;
            reader = new BufferedReader(new FileReader(new File(this.routeFile)));
            while ((lineText = reader.readLine()) != null) {
                String[] actions;
                String[] nodes;
                if (!Utils.isNotEmpty(lineText = lineText.trim()) || lineText.startsWith("#") || (nodes = lineText.split("\\s+")).length < 3 || nodes[2].matches("\\d+") || (actions = nodes[2].split("\\.")).length == 1) continue;
                StringBuilder ctrlPathBuilder = new StringBuilder();
                ctrlPathBuilder.append("controllers");
                for (int i = 0; i != actions.length - 1; ++i) {
                    ctrlPathBuilder.append('/');
                    ctrlPathBuilder.append(actions[i]);
                }
                String controllerFileName = this.getControllerFile(ctrlPathBuilder.toString());
                if (!new File(controllerFileName).exists()) continue;
                RouteNode routeNode = new RouteNode(nodes[0].trim(), nodes[1].trim(), controllerFileName, actions[actions.length - 1]);
                this.routeNodeList.add(routeNode);
            }
            Utils.closeSilently(reader);
        }
        catch (IOException e) {
            LogUtils.error("parse Play Routes Error", e);
        }
        finally {
            Utils.closeSilently(reader);
        }
    }

    public RouteNode getRouteNode(File controllerFile, String methodName) {
        Optional<RouteNode> routeNode = this.routeNodeList.stream().filter(node -> controllerFile.getAbsolutePath().equals(node.controllerFile) && node.actionMethod.equals(methodName)).findFirst();
        return routeNode.isPresent() ? routeNode.get() : null;
    }

    public List<RouteNode> getRouteNodeList() {
        return this.routeNodeList;
    }

    private String getControllerFile(String relativePath) {
        return this.javaSrcPath + relativePath + ".java";
    }

    public static class RouteNode {
        public final String method;
        public final String routeUrl;
        public final String controllerFile;
        public final String actionMethod;

        public RouteNode(String method, String routeUrl, String controllerFile, String actionMethod) {
            this.method = method;
            this.routeUrl = routeUrl;
            this.controllerFile = controllerFile;
            this.actionMethod = actionMethod;
        }
    }
}

