/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs;

import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import io.github.yedaxia.apidocs.DocContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Resources {
    private static boolean isDebug = false;
    private static String debugResourcePath;

    public static InputStream getTemplateFile(String fileName) throws FileNotFoundException {
        File tplFile;
        if (isDebug) {
            return new FileInputStream(new File(debugResourcePath, fileName));
        }
        String userResPath = Resources.getUserResourcePath();
        if (Resources.getUserResourcePath() != null && (tplFile = new File(userResPath, fileName)).isFile() && tplFile.exists()) {
            return new FileInputStream(tplFile);
        }
        return Resources.class.getResourceAsStream("/" + fileName);
    }

    public static InputStream getCodeTemplateFile(String fileName) throws FileNotFoundException {
        return Resources.getTemplateFile(fileName);
    }

    public static Template getFreemarkerTemplate(String fileName) throws IOException {
        Configuration conf = new Configuration(Configuration.VERSION_2_3_0);
        conf.setDefaultEncoding("utf-8");
        if (isDebug) {
            conf.setDirectoryForTemplateLoading(new File(debugResourcePath));
        } else {
            String userResPath = Resources.getUserResourcePath();
            File tplFile = new File(userResPath, fileName);
            if (tplFile.isFile() && tplFile.exists()) {
                conf.setDirectoryForTemplateLoading(new File(userResPath));
            } else {
                conf.setClassForTemplateLoading(Resources.class, "/");
            }
        }
        return conf.getTemplate(fileName);
    }

    private static String getUserResourcePath() {
        return DocContext.getDocsConfig().resourcePath;
    }

    public static void setDebug() {
        isDebug = true;
        debugResourcePath = System.getProperty("user.dir") + "/build/resources/main";
    }

    static {
        try {
            if (!isDebug) {
                Logger.selectLoggerLibrary((int)0);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

